# ReminderApp (Recordatorio) - Manual del usuario

Con ReminderApp (Recordatorio), ¡no más olvidos!    
Tenga la seguridad, este programa está ahí para recordarle todo lo importante gracias a recordatorios como (por ejemplo: tomar su medicación, no olvidar una cita o la visita de alguien, con la niñera, ayuda doméstica, enfermera, etc.).    
¡Incluso recordatorios de cumpleaños!    
Todos hemos vivido al menos una vez en la vida este momento embarazoso: ¡olvidar el cumpleaños de un ser querido! Hay que decir que no siempre es fácil recordar las fechas de cumpleaños de todas las personas que estás acostumbrado a conocer (especialmente cuando vienes de una familia numerosa o formas parte de un grupo numeroso de amigos).    
Introduces las fechas de cumpleaños de toda la familia y el programa te las recordará cada año con una alarma, ¡incluidos recordatorios de un aniversario!    
¡Este programa también contiene una libreta de direcciones y mucho más por descubrir!    

Para obtener más información y configurar este programa, lea esta documentación en su totalidad. GRACIAS.    

Nota: En este documento se ha adoptado una terminología específica para los usuarios que utilizan ayudas informáticas para personas ciegas.    

# Guía del usuario

* Autor: [Adriano Barbieri](mailto:adrianobarb@yahoo.it)
* Última modificación: Noviembre 2024

## Tabla de contenido

* [1.\ Introducción](#toc1)
* [2.\ Configurando el programa](#toc2)
* [3.\ Los menús](#toc3)
* [4.\ Información adicional para la ventana principal de la opción "Recordatorio para el día seleccionado:"](#toc4)
* [5.\ ¿Cómo funciona la Libreta de direcciones?](#toc5)
* [6.\ ¿Cómo abrir el programa desde la bandeja del sistema?](#toc6)


---


# 1.\ Introducción <a name="toc1"></a>
Este programa que es una combinación de agenda y libreta de direcciones desarrollado por mí mismo, lo llamé ReminderApp (nombre interno) pero en realidad la ventana del programa y en la bandeja del sistema aparecen con el nombre "Recordatorio".    

El programa ReminderApp es portátil y se puede configurar para minimizarse y ejecutarse automáticamente cuando se inicia Windows.    

Este programa es muy intuitivo y no requiere mucha explicación, sin embargo te daré algunas pautas a seguir.    

# 2.\ Configurando el programa <a name="toc2"></a>
Si obtuvo el archivo ReminderApp.zip, extráigalo, por ejemplo, en la ruta:    
`C:\Archivos de programa\ReminderApp`    

También puedes extraerlo a la raíz del disco `C:\`, ejemplo:    

`C:\ReminderApp`    

o puedes colocarlo donde quieras.    

Una vez extraído, este archivo contiene los siguientes elementos:    

* La carpeta "Doc" que contiene los archivos de ayuda del programa para el idioma que estás utilizando actualmente (si está disponible).    
* La carpeta "locale" que contiene los archivos de traducción de la interfaz de idioma disponible para el programa.    
* La carpeta "Sounds" que contiene los archivos de sonido de alarma, puedes agregarlos directamente a esta carpeta siempre que estén en formato "wav", y su duración es inferior a 2 segundos, ReminderApp cargará automáticamente los nombres y los ordenará al insertarlos en la opción de configuración "Establecer notificaciones", lo que significa que si agregas alarmas, el número de alarmas que configures puede cambiar y tendrás que restablecerlo en el menú Ajustes submenú Alt+a y luego en el cuadro de diálogo "Establecer notificaciones" en la lista desplegable llamada: Usa alarma: seguido del nombre de la alarma.    
También hay una carpeta "Samples" dentro de la carpeta "Sounds", estos sonidos son utilizados por el programa.    
* El archivo "ReminderApp.exe" (archivo ejecutable para iniciar el programa en cualquier momento).    
* El archivo ReminderApp.ico (el formato de archivo ICO es el formato de archivo que administra iconos en el sistema operativo Microsoft Windows, pero este formato también se usa ampliamente para favicons. Este icono es visible en la barra de tareas tan pronto como se minimiza el programa y se elimina cuando se cierra la aplicación).    

# Advertencia

El archivo ReminderApp.zip, una vez extraído, contendrá su ejecutable llamado ReminderApp.exe, que su antivirus declarará ¡falso positivo al ejecutarlo por primera vez!    

Esto sucede con el antivirus Windows Defender, por ejemplo.    

¿Cómo puedo permitir que Windows Defender Antivirus ejecute el programa de todos modos?    

Para permitir que el programa aún se ejecute con Windows Defender, debes hacer clic en "Información adicional". Luego aparece el botón "Ejecutar de todos modos", simplemente haga clic en él para comenzar a ejecutar el programa en Windows.    

Esto debe hacerse cada vez que se instala el nuevo archivo ejecutable ReminderApp.exe en la carpeta ReminderApp.    

# 3.\ Los menús <a name="toc3"></a>
En la ventana principal del programa al inicio encontraremos los siguientes cinco menús con sus respectivas órdenes de teclado.    

# Menú Archivo submenú Alt+ a

En este primer menú tendremos las siguientes opciones:    

# Submenú de Contactos
* Exportar contactos de la libreta de direcciones... Ctrl+Shift+e    
Pulsa Intro, aparece un cuadro de diálogo con el nombre:    
`Exportar contactos`    
Selecciona la ubicación y el nombre de exportación de tu lista, en el campo de edición:    
`Nombre de archivo`    
Luego indicando txt o json en el tipo de documento.    
`Tipo:  Archivos de texto (*.txt)`    
Flecha abajo para encontrar:    
`Archivos JSON (*.json)`    
Finalmente guarda tu archivo pulsando en el botón::    
`Guardar`    
Si todo ha ido bien aparecerá el siguiente mensaje:    
`¡Advertencia! ¡Contactos exportados exitosamente!`    
* Importar contactos a tu libreta de direcciones... Ctrl+Shift+i    
Pulsa Intro, aparece un cuadro de diálogo con el nombre:    
`Selecciona un archivo para importar`    
`Nombre de archivo`    
Luego indicando txt o json en el tipo de documento.    
`Tipos de archivos: Archivos JSON (*.json)`    
Flecha abajo para encontrar:    
Tipos de archivos: Archivos de texto (*.txt)    
Selecciona el archivo txt o json previamente exportado, luego ábrelo pulsando el botón:    
`Abrir`    
Si todo ha ido bien aparecerá el siguiente mensaje:    
`¡Advertencia! ¡Importación completada exitosamente!`    
Pulsa el botón `OK`. Aparece un nuevo cuadro de diálogo con el nombre:    
`Elige cómo proceder`    
`Al elegir Sí, los contactos se sobrescribirán.`    
`Al elegir No, solo se agregarán a los existentes.`    
Pulsa el botón Sí o No según tu elección.    
PARA TU INFORMACIÓN    
`Los archivos JSON en el caso de este programa están estructurados como una lista de datos, por ejemplo: ["...", "...", "..."] y son más convenientes de administrar para el programa, mientras que Los archivos de texto están estructurados con un marcador de nueva línea, por ejemplo:    
línea    
línea    
línea, etc., que son más legibles para los humanos.    

# Submenú de Configuración:
* Exportar la carpeta de configuración... Ctrl+E    
Presiona Enter, aparecerá un cuadro de diálogo con el nombre:    
`Elige la carpeta de destino`    
Selecciona la ubicación para exportar la carpeta ReminderApp_config en el campo de edición:    
Flecha abajo para encontrar:    
Seleccionar carpeta    
Si todo ha ido bien, aparecerá el siguiente mensaje:    
`¡Advertencia! ¡Configuración exportada con éxito!`    
* Importar la carpeta de configuración... Ctrl+I    
Presiona Enter, aparecerá un cuadro de diálogo con el nombre:    
`Elige la carpeta de origen`    
Selecciona la ubicación de la carpeta ReminderApp_config en el campo de edición:    
Flecha abajo para encontrar:    
Seleccionar carpeta    
Si todo ha ido bien, aparecerá el siguiente mensaje:    
`¡Advertencia! ¡Configuración importada con éxito!`    
* Salir Alt+f4    
Esta opción cierra el programa hasta el próximo reinicio a través del archivo ejecutable (ReminderApp.exe), a menos que lo haya configurado al iniciar Windows.    

# Menú Editar submenú Alt+ e

En este segundo menú tendremos las siguientes opciones:    

* Agregar recordatorio... Ctrl+n    
* Editar recordatorio... F2    
* Mover recordatorio... Ctrl+F2    
* Eliminar recordatorios... Del    
* Notas adicionales del recordatorio (submenú) con 3 elementos:    
* Añadir... Ctrl+Shift+1    
* Editar Ctrl+Shift+2    
* Eliminar Ctrl+Shift+3    
Si añades una nota a un recordatorio, quedará guardado en la  carpeta ReminderApp_config /ReminderApp_notes.    
La nota es un número único en el nombre del archivo, por ejemplo: "Notes_xxxx.txt", por lo tanto, el programa es capaz de encontrarlos y gestionarlos.    
Nota: En el cuadro de diálogo, al agregar un Aniversario o Cumpleaños, también puede seleccionar una melodía y reproducirla/detenerla mediante un cuadro combinado y un botón.    
Las melodías se almacenan en la carpeta  Sounds, Samples, Melodies y están en formato .wav.    
Puedes añadir más siempre que sean del mismo formato y de corta duración.    
Si hay varios aniversarios/cumpleaños en el mismo día, estos se agruparán en una sola notificación, por lo tanto se utilizará la primera melodía de la lista.    
Continuando con el menú Editar:    
* Eliminar citas pasadas... Ctrl+Shift+a    
* Eliminar medicamentos pasados... Ctrl+Shift+m    
* Libreta de direcciones... F4    
Se abrirá un cuadro de diálogo para las opciones que acabamos de describir, siga las instrucciones en pantalla.    
* Establecer a la fecha actual Ctrl+Shift+h    
Restablecerá el selector de fecha a la fecha actual.    
* Detener la notificación actual Ctrl+Shift+F1    

# Menú Ver submenú Alt+ v

En este tercer menú tendremos las siguientes opciones:    

* Ver cumpleaños F5    
* Ver citas F6    
* Ver citas recurrentes Shift+F6    
* Ver repetición del recordatorio Ctrl+F6    
* Ver aniversarios F7    
* Ver medicamentos F8    
* Ver medicamentos recurrentes Shift+F8    
Pulsa Intro en la opción deseada para mostrarla en una lista.    
Pulsa la tecla de aplicaciones o shift+f10 para mostrar las opciones disponibles.    
Pulsa tab y luego haz clic en el botón Cerrar o pulsa la tecla Escape o Intro para cerrar este cuadro de diálogo y luego regresar a la ventana principal del programa.    
Nota:    
Cuando creas/editas un recordatorio, también notarás 2 tipos recurrentes: (Cita recurrente y Medicamento recurrente)    
Estos dos tipos de recordatorios se pueden configurar con recurrencia: (Diario, Semanal, Anual), dependiendo de la semana para Semanal, se activará la elección del día y la elección del mes para Anual.    
Puedes establecer de 5 a 60 minutos, Se te avisará a tiempo y tendrás la oportunidad de, no sé, cambiarte, prepararte, y cuando expire el aviso sonará la verdadera alarma.    
Los recordatorios recurrentes son inteligentes: pasan a la siguiente fecha equivalente cuando caducan. Por ejemplo, un recordatorio diario recurrente, siempre lo encontrarás también al día siguiente, y así sucesivamente.    
No he previsto la posibilidad de eliminar recordatorios recurrentes (por razones obvias), pero puedes verlos a partir del menú "Ver".    
Si desea eliminar uno, simplemente active la primera columna "Fecha" en las listas, excluyendo citas y medicamentos.    
A continuación, seleccione el tipo de recordatorio recurrente que desea eliminar en el menú "Ver" y anote su fecha de entrada, visible en la primera columna de la izquierda.    
Finalmente, establece esta fecha en el selector principal para que puedas verla y proceder con la eliminación.    
Continuando con el menú Ver:    
* Mostrar la primera columna "Fecha" en las listas mostradas (excluyendo citas y medicamentos) (está desmarcada de forma predeterminada)    
Ver estas fechas es útil para encontrar fácilmente recordatorios para cambiarlas o eliminarlas configurando la fecha desde el selector principal.    

# Menú Ajustes submenú Alt+ a

En este cuarto menú tendremos las siguientes opciones:    

* Establecer notificaciones Ctrl+Shift+n    
Pulsa Intro, aparece un cuadro de diálogo, moverse con "Tab" y "Shift+Tab" para moverse entre los controles, flechas  arriba y abajo para cambiar el valor del parámetro.    
`Número de repeticiones: 3`    
`Intervalo entre repeticiones (segundos): 8`    
`Usa la alarma: Alarm 01`    
`Habilitar lectura de horas en formato 24 horas`    
Esta es una casilla de verificación para elegir si deseas configurar el formato en 24 horas o 12 horas; el valor predeterminado es 24 horas.    
Pulsa la barra espaciadora para configurar el formato de 12 horas.    
`Habilitar lectura de fecha en formato europeo`    
Esta es una casilla de verificación para elegir establecer el formato de fecha en EE. UU. o Europeo; el valor predeterminado es Europeo.    
Pulsa la barra espaciadora para configurar el formato EE. UU.    
Este cuadro de diálogo también contiene estas casillas de verificación:    
* Minimizar el programa al iniciar (está desmarcada de forma predeterminada)    
Si eliges minimizar el programa al iniciar, el programa se ocultará en la barra de tareas para no molestarte, deberías ver su ícono, ciertamente en los íconos ocultos, podrás interactuar con el menú contextual cuando quieras. pero el programa seguirá monitoreando cualquier recordatorio del día.    
Si quieres que el icono se vea siempre en la barra de tareas, puedes hacerlo, una vez oculto, configurandolo desde la configuración de Windows, personalizaciones, Barra de tareas, mostrar todas las aplicaciones y activando ReminderApp.    
* Ejecución automática cuando se inicia Windows (está desmarcada de forma predeterminada)    
Si eliges esta opción permitirá que el programa se inicie automáticamente cuando se inicie Windows.    
* Mostrar vista previa de recordatorios al inicio si el programa está minimizado (está marcada de forma predeterminada)    
Cuando el programa se minimiza en la bandeja del sistema al inicio, abre una vista previa de los recordatorios del día.    
* Buscar actualizaciones (seleccionada predeterminadamente)    
Si esta opción está habilitada, buscará actualizaciones del programa al inicio.    
Una vez completada la configuración, pulsa Intro o el botón "OK" para validar los cambios. Para cancelar los cambios, pulsa Escape o el botón "Cancelar".    
Continuando con el menú Ajustes:    
* Establecer la combinación de teclas de acceso rápido Ctrl+Shift+K    
Las combinaciones de teclas de acceso rápido para evitar que la notificación actual active una alarma y mostrar el recordatorio (incluso cuando no está en primer plano) están diseñadas para funcionar fuera de la interfaz gráfica de ReminderApp.    
Esto significa que en caso de conflicto con otras aplicaciones, es posible personalizarla individualmente.    
Si creas una combinación que ya está en uso en el programa, se te advertirá con un sonido de error y no será aceptada.    
Si tu nueva combinación es válida, aparecerá en la barra de título, luego puedes hacer clic en el botón "Usa esta combinación" y se usará hasta que decidas cambiarla nuevamente.    
* Establecer idioma Ctrl+Shift+L    
Cuando se pulsa Intro en este elemento, se abrirá un cuadro de diálogo en el que hay algunos idiomas, los cuales se habilitarán si la traducción está disponible en la carpeta local).     
Podrás elegir el idioma de la interfaz seleccionandolo entre los idiomas disponibles actualmente mostrados en este cuadro de diálogo.    
Aparece un cuadro de diálogo informándote que se ha cambiado el idioma y luego que se debe reiniciar el programa para que estos cambios surtan efecto.    

# Menú Ayuda submenú Alt+ a

En este quinto y último menú tendremos las siguientes opciones:    

* Información del programa... F1    
Cuando se pulsa Intro en este elemento, se abrirá un cuadro de diálogo donde se mostrará la información del programa en un documento editable de solo lectura en tu idioma respectivo, si está disponible.    
Utiliza las teclas NVDA+b o Insert+b del lector de pantalla  en la documentación para leer esta información nuevamente.    
Una vez terminado, pulsa  tab y luego haz clic en el botón OK o pulsa la tecla Intro o Escape para cerrar este cuadro de diálogo y luego regresar a la ventana principal del programa.    
* Manual del usuario... Shift+F1    
Cuando se pulsa Intro en este elemento, se abrirá una ventana que mostrará la ayuda del programa en un documento html editable de solo lectura en el navegador predeterminado en tu idioma respectivo, si está disponible, de lo contrario recibirás un mensaje de advertencia.    
Pulsa Alt+F4 para cerrar la documentación.    
* Tecla de acceso directo... F9    
Cuando se pulsa Intro en este elemento, se abrirá un cuadro de diálogo en el que los atajos de teclado  del programa se mostrarán en una lista editable de solo lectura; utiliza las teclas de flecha para moverte  por la lista.    
Pulsa tab y luego haz clic en el botón Cerrar o pulssa la tecla Escape o Intro para cerrar este cuadro de diálogo y luego regresar a la ventana principal del programa.    
* Buscar actualizaciones... Ctrl+Shift+U    
Cuando se pulsa Intro en este elemento, se te notificará si hay actualizaciones para el programa; de ser así, siga las instrucciones en pantalla.    

# 4.\ Información adicional para la ventana principal de la opción "Recordatorio para el día seleccionado:" <a name="toc4"></a>
Cuando cambia la fecha en el selector de la ventana principal, si la fecha seleccionada coincide con un recordatorio, sonará un sonido de sonar.    
Sin embargo, el foco puede cambiar a la lista si previamente se ha seleccionado un recordatorio.    
Para evitar este inconveniente, puedes deseleccionar el recordatorio antes de continuar, o ingresar la fecha inmediatamente después en el orden día, mes, año o mes, día, año, dependiendo de la configuración de idioma del sistema (y no de la del programa).    
En el selector puedes navegar usando las flechas horizontales.    
Para los usuarios de lectores de pantalla como NVDA, es importante tener en cuenta que este último no verbaliza  la posición actual en el selector. Recomendamos pulsar una flecha vertical: NVDA comunicará la fecha que establezcas y proporcionará actualizaciones tan pronto como escribas un día, mes o año completo.    
Sonar soluciona el problema al establecer la fecha inicial, en lugar de mover el foco a la lista de recordatorios cuando hay uno en esa fecha, escuchas el sonido que te avisa de esto y puedes jugar con tu fecha sin problema :)

# 5.\ ¿Cómo funciona la Libreta de direcciones? <a name="toc5"></a>
Ir a:    
` Menú Editar submenú Alt+ e`    
luego :    
`Libreta de direcciones... F4`    
Cuando se pulsa Intro en esta opción, se abre un cuadro de diálogo con el nombre:    
`Libreta de direcciones`    
Este cuadro de diálogo contendrá la lista de tus contactos si haz agregado uno; de lo contrario, esta lista estará vacía.    
Cuando abre el menú de contexto en este cuadro de diálogo pulsando la tecla aplicaciones situada junto a la tecla control derecho en la mayoría de los teclados. En un teclado sin una tecla aplicaciones, pulsa shift+F10 en su lugar.    
Tenga en cuenta que algunas opciones no están disponibles en la lista de contactos según el contexto. Puedes pulsar Intro en la opción que desees, así que aquí están las opciones:    

* Añadir contacto... Ctrl+N    
* Editar contacto... F2    
* Eliminar contacto... Del    
* Encontrar contacto... Ctrl+F3    
Se abrirá un cuadro de diálogo para las opciones del menú que se acaban de describir; siga las instrucciones en pantalla.    
* Encontrar siguiente F3    
* Encontrar anterior Shift+F3    
Ambas opciones se basan en el nombre del contacto que  se escribió en el cuadro de diálogo "Encontrar contacto", por lo que la búsqueda se realiza con la coincidencia siguiente o anterior del mismo nombre que se encuentra en la lista de la libreta de direcciones.    
* Enviar correo electrónico al contacto... Ctrl+e    
Se abrirá un cuadro de diálogo para esta opción, siga las instrucciones en pantalla.    

Tenga en cuenta que puede enviar un correo electrónico al contacto si el correo electrónico del contacto se ha ingresado en el campo de edición separado por un espacio al principio (y si es necesario al final), al editar el nombre del contacto, por ejemplo. De lo contrario, si no hay ningún correo electrónico en este cuadro de edición, esta opción no estará disponible para enviarlo.    

Si no has configurado un programa de correo electrónico predeterminado, el sistema mostrará automáticamente un cuadro de diálogo que te permitirá seleccionar la aplicación que se utilizará para enviar el correo electrónico.    

# 6.\ ¿Cómo abrir el programa desde la bandeja del sistema? <a name="toc6"></a>

* Accede a la bandeja del sistema pulsando Windows+b, flecha abajo hasta el icono de "Recordatorio" y abre el menú de contexto pulsando la tecla aplicaciones situada junto a la tecla control derecho en la mayoría de los teclados. En un teclado sin una tecla aplicaciones, pulsa shift+F10 en su lugar.    
* Haz clic con el botón derecho sobre el icono de "Recordatorio" situado en la bandeja del sistema de Windows.    

Cuando aparezca el menú de contexto, puedes utilizar las flechas para navegar por él y la tecla intro para activar uno de los elementos enumerados a continuación.    

* MostrarRecordatorio    
Al pulsar la tecla Intro en esta opción se mostrará el programa.    
* Detener la notificación actual    
Al pulsar la tecla Intro en esta opción, se detendrá la notificación actual.    
* Libreta de direcciones...    
Al pulsar la tecla Intro en esta opción se abre el cuadro de diálogo "Libreta de direcciones".    
* Salir de Recordatorio    
Al pulsar la tecla Intro en esta opción se saldrá del programa.    

---

¡Gracias por leer esta documentación!    

Te deseo un buen uso del programa ReminderApp (Recordatorio) 😉    
Me gustaría agradecer sinceramente a [Rémy Ruiz](mailto:remyruiz@gmail.com) por escribir esta documentación y traducción de ReminderApp al francés, inglés, italiano y español y por sus comentarios y sugerencias.    
