# ReminderApp (Rappel) - Manuel de l'utilisateur

Avec ReminderApp (Rappel), plus d'oubli !    
Rassurez-vous, ce programme est là pour vous rappeler tout ce qui est important grâce aux rappels telles que (ex : prendre ses médicaments, ne pas oublier un rendez-vous ou la visite de quelqu'un, avec la baby-sitter, l'aide ménagère, l'infirmière, etc.).    
Même des rappels d'un anniversaire !    
Nous avons tous vécu ce moment embarrassant au moins une fois dans notre vie : oublier l'anniversaire d'un proche ! Il faut dire qu'il n'est pas toujours évident de se souvenir des dates d'anniversaire de toutes les personnes que l'on a l'habitude de côtoyer (surtout lorsqu'on est issu d'une famille nombreuse ou qu'on fait partie d'une grande bande de copains).    
C'est vous qui entrez les dates d'anniversaire de toute la famille et le programme se charge de vous les rappeler tous les ans avec une alarme, y compris des rappels d'une  célébration !    
Ce programme contient aussi un carnet d'adresses et bien plus encore à découvrir!    

Pour en savoir plus et configurer ce programme Veuillez lire cette documentation dans son intégralité. Merci.    

Remarque : Dans ce document, une terminologie spécifique a été adoptée pour les utilisateurs qui utilisent des aides informatiques pour les personnes aveugles.

# Guide de l'utilisateur

* Auteur : [Adriano Barbieri](mailto:adrianobarb@yahoo.it)
* Dernière modification : Novembre 2024

## Table des matières

* [1.\ Introduction](#toc1)
* [2.\ Mise en place du programme](#toc2)
* [3.\ Les menus](#toc3)
* [4.\ Informations complémentaires pour la fenêtre principale pour l'option "Rappel pour le jour sélectionné :"](#toc4)
* [5.\ Comment fonctionne le Carnet d'adresses ?](#toc5)
* [6.\ Comment ouvrir le programme à partir de la  barre d'état système ?](#toc6)


---


# 1.\ Introduction <a name="toc1"></a>

Ce   programme  qui est une combinaison d'un agenda et d'un carnet d'adresses développer par moi-même, je l'ai appelé ReminderApp (nom en interne) mais en réalité la fenêtre du programme et dans la barre d'état système apparaissent avec le nom "Rappel".    

Le programme ReminderApp est portable et peut être configuré pour être réduit et exécuté automatiquement au démarrage de Windows.    

Ce programme est très intuitif et ne nécessite pas beaucoup d'explications, cependant je vais vous donner quelques lignes directrices à suivre.    

# 2.\ Mise en place du programme <a name="toc2"></a>
Si vous avez obtenu le fichier ReminderApp.zip, l'extraire par exemple dans le chemin :    
`C:\Program Files\ReminderApp`    

Vous pouvez également l'extraire à la racine du disque `C:\`, exemple :    

`C:\ReminderApp`    

ou vous pouvez le placer où vous le souhaitez.    

Ce dossier une fois extrait  il contient les éléments suivants :    

* Le dossier "Doc" qui contient les fichiers d'aide du programme pour la langue que vous utilisez actuellement (si disponible).    
* Le dossier "locale" qui contient les fichiers de traduction de l'interface linguistique disponible pour le programme.    
* Le dossier "Sounds" qui contient les fichiers sons d'alarme, vous pouvez les ajouter directement dans ce dossier tant qu'ils sont au format "wav", et sa durée est inférieure à 2 secondes, ReminderApp chargera automatiquement les noms et les triera lors de leur insertion dans l'option des paramètres "Définir les notifications", ce qui signifie que si vous ajoutez des alarmes, il se peut que le numéro d'alarme défini change et vous devrez le réinitialiser dans le menu Paramètres sous-Menu Alt+ p puis dans la boîte de dialogue "Définir les notifications" sous la liste déroulante  appelée : Utiliser l'alarme : suivi du nom de l'alarme.    
Aussi il y a un dossier "Samples" à l'intérieur du dossier  "Sounds", ces sons sont utilisés par le programme.    
* Le fichier "ReminderApp.exe" (fichier exécutable pour démarrer le programme à tout moment).    
* Le fichier ReminderApp.ico (Le format de fichier ICO est le format de fichier gérant les icônes sur le système d'exploitation Microsoft Windows mais ce format est aussi très utilisé pour les favicon. Cette icône est visible dans la barre des tâches dès que le programme est réduit et est supprimée à la fermeture de l'application).    

# Avertissement

Le fichier ReminderApp.zip, une fois extrait, contiendra son exécutable appelé ReminderApp.exe, qui sera déclaré faux positif par votre antivirus lors de son exécution pour la première fois !    

Cela se produit avec l'antivirus Windows Defender par exemple.    

Comment autoriser l’antivirus Windows Defender à exécuter le programme quand même ?    

Pour permettre au programme de s'exécuter quand même avec Windows Defender, il faut cliquer sur "Informations complémentaires". Un bouton "Exécuter quand même" apparaît alors, il suffit de cliquer dessus pour lancer l'exécution du programme sur Windows.    

Cela doit être fait chaque fois que le nouveau fichier exécutable ReminderApp.exe est installé dans le dossier ReminderApp.    

# 3.\ Les menus <a name="toc3"></a>
Dans la fenêtre principale du programme au démarrage nous retrouverons les cinq menus suivants avec leurs commandes respectives.    

# Fichier sous-Menu Alt+ f

Dans ce premier menu, nous aurons les options suivantes :    

# Sous-menu Contacts:
* Exporter les contacts du carnet d'adresses... Ctrl+Shift+e    
Appuyez sur Entrée, une boîte de dialogue apparaît comme nom :    
`Exporter des contacts`    
Sélectionnez l'emplacement et le nom d'export de votre liste,dans le champ d'édition :    
`Nom du fichier `    
Puis indiquant txt ou json dans le type de document.    
`Type :  Fichiers texte (*.txt)`    
Flèche  bas pour trouver :    
`Fichiers JSON (*.json)`    
Enregistrez finalement votre fichier en appuyant sur le bouton :    
`Enregistrer`    
Si tout s'est bien passé, le message suivant apparaîtra :    
`Avertissement ! Contacts exportés avec succès !`    
* Importer des contacts dans votre carnet d'adresses... Ctrl+Shift+i    
Appuyez sur Entrée, une boîte de dialogue apparaît comme nom :    
`Sélectionner un fichier à importer`    
`Nom du fichier `    
Puis indiquant txt ou json dans le type de document.    
`Types de fichiers : Fichiers JSON (*.json)`    
Flèche  bas pour trouver :    
Types de fichiers : Fichiers texte (*.txt)    
Sélectionnez le fichier txt ou json précédemment exporté, puis faites ouvrir  en appuyant sur le bouton :    
`Ouvrir`    
Si tout s'est bien passé, le message suivant apparaîtra :    
`Avertissement ! Importation terminée avec succès !`    
Appuyez sur le bouton `OK`, Une nouvelle boîte de dialogue apparaît avec le nom :    
`Choisir comment procéder`    
`En choisissant Oui, les contacts seront écrasés.`    
`En choisissant Non, ils seront uniquement ajoutés à ceux existants.`    
Appuyez soit sur le bouton Oui ou Non selon votre choix.    
POUR VOTRE INFORMATION    
`Les fichiers JSON dans le cas de ce programme sont structurés comme une liste de données, par exemple : ["...", "...", "..."] et sont plus pratiques à gérer pour le programme, tandis que les fichiers texte ils sont structurés avec un marqueur de nouvelle ligne, par exemple:    
line    
line    
line etc qui sont plus lisibles par un humain`.    

# Sous-menu Contacts:
* Exporter le dossier de configuration... Ctrl+E    
Appuyez sur Entrée, une fenêtre de dialogue s'affichera avec le nom :    
`Choisir le dossier de destination`    
Sélectionnez l'emplacement d'exportation du dossier ReminderApp_config dans le champ d'édition :    
Flèche vers le bas pour trouver :    
Sélectionner un dossier    
Si tout s'est bien passé, le message suivant apparaîtra :    
`Avertissement ! Configuration exportée avec succès !`    
* Importer le dossier de configuration... Ctrl+I    
Appuyez sur Entrée, une fenêtre de dialogue s'affichera avec le nom :    
`Choisir le dossier source`    
Sélectionnez l'emplacement du dossier ReminderApp_config dans le champ d'édition :    
Flèche vers le bas pour trouver :    
Sélectionner un dossier    
Si tout s'est bien passé, le message suivant apparaîtra :    
`Avertissement ! Configuration importée avec succès !`    
* Sortir Alt+f4    
Cette option ferme le programme jusqu'au prochain redémarrage via le fichier exécutable (ReminderApp.exe), sauf si vous l'avez configuré au démarrage de Windows.    

# Menu Édition sous-Menu Alt+ é

Dans ce deuxième menu, nous aurons les options suivantes :    

* Ajouter un rappel... Ctrl+n    
* Modifier le rappel... F2    
* Déplacer le rappel... Ctrl+F2    
* Supprimer les rappels... Del    
* Notes supplémentaires du rappel (sous-menu) avec 3 éléments :    
* Ajouter... Ctrl+Shift+1    
* Modifier Ctrl+Shift+2    
* Supprimer Ctrl+Shift+3    
Si vous ajoutez une note à un rappel, elle sera sauvegardée dans le dossier ReminderApp_config /ReminderApp_notes.    
Les notes ont un numéro unique dans le nom du fichier, par exemple : "Notes_xxxx.txt", le programme est donc capable de les retrouver et de les gérer.    
Remarque : Dans la boîte de dialogue, lors de l'ajout d'une Célébration ou Anniversaire, vous pouvez également sélectionner une mélodie et la lire/l'arrêter via une zone de liste déroulante et un bouton.    
Les mélodies sont stockées dans le dossier Sounds, Samples, Melodies et sont au format .wav.    
Vous pouvez en ajouter d’autres à condition qu’ils soient du même format et de courte durée.    
S'il y a plusieurs  célébrations/anniversaires le même jour, ceux-ci seront regroupés dans une seule notification, donc la première mélodie de la liste sera utilisée.    
Poursuivant avec le menu Édition :    
* Supprimer les rendez-vous passés... Ctrl+Shift+a    
* Supprimer les médicaments passés... Ctrl+Shift+m    
* Carnet d'adresses... F4    
Une boîte de dialogue s'ouvrira pour les options que nous venons de décrire, suivez les instructions à l'écran.    
* Définir sur la date actuelle Ctrl+Shift+h    
Cela réinitialisera le sélecteur de date à la date actuelle.    
* Arrêter la notification en cours Ctrl+Shift+F1    

# Menu Affichage sous-Menu Alt+ a

Dans ce troisième menu, nous aurons les options suivantes :    

* Voir les anniversaires F5    
* Voir les rendez-vous F6    
* Voir les rendez-vous récurrents Shift+F6    
* Voir répétition du rappel Ctrl+F6    
* Voir les célébrations F7    
* Voir les médicaments F8    
* Voir les médicaments récurrents Shift+F8    
Appuyez sur Entrée sur l'option souhaitée pour afficher celui-ci dans une liste.    
Pressez la touche applications ou maj+f10 pour afficher les options disponibles.    
Appuyez sur tab puis cliquez sur le bouton Fermer ou appuyez sur la touche Échap ou Entrée pour fermer cette boîte de dialogue puis revenir à la fenêtre principale du programme.    
Note :    
Lorsque vous créez/modifiez un rappel, vous remarquerez également 2 types récurrents : (Rendez-vous récurrent et Médicament récurrent)    
Ces deux types de rappels peuvent être configurés avec récurrence : (Quotidien, Hebdomadaire, Annuel), selon la semaine pour Hebdomadaire, le choix du jour et le choix du mois pour Annuel seront activés.    
Vous pouvez régler 5 à 60 minutes, vous serez averti à temps et vous aurez la possibilité, je ne sais pas, de vous changer, de vous préparer, et lorsque l'avertissement expirera, la véritable alarme retentira.    
Les rappels récurrents sont intelligents : ils sont déplacés vers la prochaine date équivalente à leur expiration. Par exemple, un rappel quotidien récurrent, vous le retrouverez toujours également le lendemain, et ainsi de suite.    
Je n'ai pas prévu la possibilité de supprimer les rappels récurrents (pour des raisons évidentes), mais vous pouvez les visualiser via le menu "Affichage".    
Si vous souhaitez en supprimer un, il suffit d'activer la première colonne "Date" dans les listes, hors rendez-vous et médicaments.    
Sélectionnez ensuite le type de rappel récurrent que vous souhaitez supprimer dans le menu "Affichage" et notez sa date d'entrée, visible dans la première colonne de gauche.    
Enfin, définissez cette date dans le sélecteur principal pour pouvoir la voir et procéder à la suppression.    
Poursuivant avec le menu Affichage :    
* Afficher la première colonne "Date" dans les listes affichées (hors rendez-vous et médicaments) (non coché par défaut)    
Voir ces dates est utile pour trouver facilement des rappels pour les modifier ou les supprimer en définissant la date à partir du sélecteur principal.    

# Menu Paramètres sous-Menu Alt+ p

Dans ce quatrième menu, nous aurons les options suivantes :    

* Définir les notifications Ctrl+Shift+n    
Appuyez sur entrée, une boîte de dialogue apparaît,  se déplacer avec "Tabulation" et "Majuscule+Tabulation" pour se déplacer entre les contrôles, les flèches  haut et bas pour changer la valeur du paramètre.    
`Nombre de répétitions : 3`    
`Intervalle entre les répétitions (secondes) : 8`    
`Utiliser l'alarme : Alarm 01`    
`Activer la lecture des heures au format 24 heures`    
Il s'agit d'une case à cocher permettant de choisir de définir le format 24 heures ou 12 heures, la valeur par défaut est 24 heures.    
Appuyez sur la barre d'espace pour définir le format 12 heures.    
`Activer la lecture de la date au format européen`    
Il s'agit d'une case à cocher permettant de choisir de définir le format de date sur Américain ou Européen, la valeur par défaut est Européen.    
Appuyez sur la barre d'espace pour définir le format Américain.    
Cette boîte de dialogue contient également ces cases à cocher :    
* Réduire le programme au démarrage (non coché par défaut)    
Si vous choisissez de minimiser le programme au démarrage, le programme se cachera dans la barre des tâches pour ne pas vous déranger, vous devriez voir son icône, certainement dans les icônes cachées, vous pourrez interagir avec le menu contextuel quand vous le souhaitez. mais le programme continuera à surveiller les rappels de la journée.    
Si vous souhaitez que l'icône soit toujours visible dans la barre des tâches, vous pouvez le faire, une fois masquée, en  configurant à partir des paramètres Windows, personnalisation, barre des tâches, en affichant toutes les applications et en activant ReminderApp.    
* Exécution automatique au démarrage de Windows (non coché par défaut)    
Si vous choisissez cette option permettra au programme de démarrer automatiquement au démarrage de Windows.    
* Afficher l'aperçu des rappels au démarrage si le programme est réduit (coché par défaut)    
Lorsque le programme se réduit dans la barre d'état système au démarrage, il ouvre un aperçu des rappels de la journée.    
* Rechercher des mises à jour (sélectionné par défaut)    
Si cette option est activée, recherchera des mises à jour du programme au démarrage.    
Une fois la configuration terminée, appuyez sur Entrée ou sur le bouton "OK" pour valider les modifications. Pour annuler les modifications, appuyez sur Échap ou sur le bouton "Annuler".    
Poursuivant avec le menu Paramètres :    
* Définir la combinaison de touches de raccourci Ctrl+Shift+K    
Les combinaisons de touches de raccourci permettant d'empêcher la notification actuelle de déclencher une alarme et d'afficher le rappel (même lorsqu'il n'est pas au premier plan) sont conçues pour fonctionner en dehors de l'interface graphique de ReminderApp.    
Cela signifie qu'en cas de conflits avec d'autres applications, vous pourrez les personnaliser individuellement.    
Si vous créez une combinaison déjà utilisée dans le programme, vous serez averti par un son d'erreur et elle ne sera pas acceptée.    
Si votre nouvelle combinaison est valide, elle apparaîtra dans la barre de titre, vous pourrez alors cliquer sur le bouton "Utiliser cette combinaison" et elle sera utilisée jusqu'à ce que vous décidiez de la modifier à nouveau.    
* Définir la langue Ctrl+Shift+L    
Lorsque vous appuyez sur Entrée sur cet élément, une boîte de dialogue s'ouvrira dans laquelle il y a certaines langues, qui seront activées si la traduction est disponible dans le dossier local).    
Vous pouvez choisir la langue de l'interface en sélectionnant parmi les langues actuellement disponibles affichées dans cette boîte de dialogue.    
Une boîte de dialogue apparaît vous informant que la langue a été modifiée puis que le programme doit être redémarré pour que ces changements prennent effet.    

# Menu Aide sous-Menu Alt+ a

Dans ce cinquième et dernier menu, nous aurons les options suivantes :    
* Informations sur le programme... F1    
Lorsque vous appuyez sur Entrée sur cet élément, une boîte de dialogue s'ouvrira dans laquelle les informations sur le programme seront affichées dans un document d'édition en lecture seule dans votre langue respective si disponible.    
Utilisez les touches NVDA+b ou Insert+b du lecteur d'écran dans la documentation pour relire ces informations.    
Une fois terminé, appuyez sur tab puis cliquez sur le bouton Ok ou appuyez sur la touche Entrée ou Échap pour fermer cette boîte de dialogue puis revenir à la fenêtre principale du programme.    
* Manuel d'utilisation... Shift+F1    
Lorsque vous appuyez sur Entrée sur cet élément, une fenêtre s'ouvrira affichant l'aide du programme dans un document  html d'édition en lecture seule dans le navigateur par défaut dans votre langue respective si disponible, sinon vous recevrez un message d'avertissement.    
Appuyez sur Alt+F4 pour fermer celui-ci.    
* Touche de raccourci... F9    
Lorsque vous appuyez sur Entrée sur cet élément, une boîte de dialogue s'ouvrira dans laquelle les raccourcis clavier du programme seront affichées dans une liste d'édition en lecture seule, utilisez les touches fléchées pour vous déplacer dans la liste.    
Appuyez sur tab puis cliquez sur le bouton Fermer ou appuyez sur la touche Échap ou Entrée pour fermer cette boîte de dialogue puis revenir à la fenêtre principale du programme.    
* Rechercher des mises à jour... Ctrl+Shift+U    
Lorsque vous appuyez sur Entrée sur cet élément, vous serez averti s'il y a des mises à jour pour le programme, si c'est le cas, suivez les instructions à l'écran.    

# 4.\ Informations complémentaires pour la fenêtre principale pour l'option "Rappel pour le jour sélectionné :" <a name="toc4"></a>
Lorsque vous modifiez la date dans le sélecteur de fenêtre principale, si la date sélectionnée correspond à un rappel, un son de sonar retentit.    
Cependant, le focus peut être mis sur la liste si un rappel a déjà été sélectionné.    
Pour éviter ce désagrément, vous pouvez désélectionner le rappel avant de continuer, ou saisir la date  immédiatement après dans  l'ordre jour, mois, année ou mois, jour, année, selon les paramètres de langue du système (et non ceux du programme).    
Dans le sélecteur, vous pouvez naviguer à l'aide des flèches horizontales.    
Pour les utilisateurs de lecteurs d'écran comme NVDA, il est important de noter que ce dernier ne verbalise pas la position actuelle dans le sélecteur. Nous vous recommandons d'appuyer sur une flèche verticale : NVDA communiquera la date que vous avez définie et fournira des mises à jour dès que vous saisirez un jour complet, un mois ou une année.    
Sonar résout le problème de réglage de la date initiale, au lieu de déplacer le focus sur la liste des rappels lorsqu'il y en a un à cette date, vous entendez le son qui vous en avertit et vous pouvez jouer avec votre date sans problème :)    

# 5. Comment fonctionne le Carnet d'adresses ?<a name="toc5"></a> 
Aller à :    
`Menu Édition sous-Menu Alt+ é`    
puis :    
`Carnet d'adresses... F4`    
Lorsque vous appuyez  sur Entrée sur cette option, Une boîte de dialogue s'ouvre avec le nom :    
`Carnet d'adresses`    
Cette boîte de dialogue contiendra la liste de vos contacts si vous en avez ajouté un, sinon cette liste est vide.    
Lorsque vous ouvrez le menu contextuel dans cette boîte de dialogue en appuyant sur la touche applications située à côté de la touche de contrôle droite sur la plupart des claviers. Sur un clavier sans touche applications, appuyez sur maj+f10 à la place.    
Veuillez noter que certaines options ne sont pas disponibles dans la liste de contacts selon le contexte. Vous pouvez appuyer sur Entrée sur l'option souhaitée, voici donc les options :    

* Ajouter un contact... Ctrl+N    
* Modifier le contact... F2    
* Supprimer le contact... Del    
* Trouver un contact... Ctrl+F3    
Une boîte de dialogue s'ouvrira pour les options de menu que nous venons de décrire ; Suivez les instructions à l'écran.    
* Trouver le suivant F3    
* Trouver le précédent Shift+F3    
Ces deux options est basé sur le nom du contact que vous avez tapé dans la boîte de dialogue "Trouver un contact", donc, la recherche est effectuer  avec  la correspondance du même nom suivant ou précédent   se trouvant dans la liste du carnet d'adresses.    
* Envoyer un e-mail au contact... Ctrl+e    
Une boîte de dialogue s'ouvrira pour cette option, suivez les instructions à l'écran.    

Attention, vous pouvez envoyer un email au contact si l'email du contact a été renseigné dans le champ d'édition séparé par un espace au début (et si nécessaire à la fin), lors de la modification du nom du contact par exemple. Sinon, s'il n'y a pas d'e-mail dans cette zone d'édition, cette option ne sera pas disponible pour l'envoyer.    

Si vous n'avez pas défini de programme de messagerie par défaut, le système affichera automatiquement une boîte de dialogue vous permettant de sélectionner l'application à utiliser pour envoyer l'e-mail.    

# 6.\ Comment ouvrir le programme à partir de la  barre d'état système ? <a name="toc6"></a>

* Accédez à la barre d'état système en appuyant sur Windows+b, flècheBas jusqu'à l'icône "Rappel", et ouvrez le menu contextuel en appuyant sur la touche applications située à côté de la touche de contrôle droite sur la plupart des claviers. Sur un clavier sans touche applications, appuyez sur maj+f10 à la place.    
* Faites un clic droit sur l'icône "Rappel" située dans la barre d'état système de Windows.    

Lorsque le menu contextuel apparaît, vous pouvez utiliser les touches fléchées pour naviguer dans le menu et la touche entrée pour activer un des éléments listés ci-dessous.    

* AfficherRappel    
À l'appui de la touche Entrée sur cette option le programme sera affiché.    
* Arrêter la notification en cours    
À l'appui de la touche Entrée sur cette option La notification en cours sera arrêtée.    
* Carnet d'adresses...    
À l'appui de la touche Entrée sur cette option la boîte de dialogue "Carnet d'adresses" s'ouvre.    
* Sortir de Rappel    
À l'appui de la touche Entrée sur cette option quittera le programme.    

---

Merci d'avoir lu cette documentation !    

Je vous souhaite une bonne utilisation du programme ReminderApp (Rappel) 😉    
Je tiens à remercier sincèrement [Rémy Ruiz](mailto:remyruiz@gmail.com) pour la rédaction de cette documentation et la traduction de ReminderApp en français, anglais, italien et espagnol et pour ses retours et suggestions.    
