# ReminderApp (Lembrete) - Manual do utilizador

Com o ReminderApp (Lembrete), chega de esquecer!    
Fique tranquilo, este programa existe para o lembrar de tudo o que é importante graças a lembretes como (ex.: tomar o remédio, não esquecer um compromisso ou visita de alguém, como a babysiter, empregada doméstica, enfermeira, etc. ).    
Até lembretes de aniversário!    
Todos nós já passamos por esse momento constrangedor pelo menos uma vez na vida: esquecer o aniversário de um ente querido! É preciso dizer que nem sempre é fácil lembrar as datas de aniversário de todas as pessoas com quem está acostumado a conviver (principalmente quando vem de uma família numerosa ou faz parte de um grande grupo de amigos).    
Registe as datas de aniversário de toda a família e o programa irá lembrá-las todos os anos com um alarme, incluindo lembretes de aniversário!    
Este programa também contém um catálogo de endereços e muito mais para descobrir!    

Para saber mais e configurar este programa, leia esta documentação na íntegra. Obrigado.    

# Guia do utilizador

* Autor: [Adriano Barbieri](mailto:adrianobarb@yahoo.it)
* Última modificação: Julho de 2025

## Índice

* [1.\Introdução](#toc1)
* [2.\ Configurar o programa](#toc2)
* [3.\ Os menus](#toc3)
* [4.\ Informações adicionais para a janela principal da opção "Lembrete do dia selecionado:"](#toc4)
* [5.\ Como funciona o catálogo de endereços?](#toc5)
* [6.\ Como abrir o programa pela barra do sistema?](#toc6)


---


# 1.\ Introdução <a name="toc1"></a>
Este programa, que é uma combinação de uma agenda e uma agenda de endereços desenvolvida por mim, chamei-o de ReminderApp (nome interno) mas na realidade a janela do programa e no sistema da barra de status aparece com o nome “Lembrete”.    

O programa ReminderApp é portátil e pode ser configurado para minimizar e executar automaticamente, quando o Windows for iniciado.    

Este programa é muito intuitivo e não requer grandes explicações, porém darei algumas orientações a serem seguidas.    

# 2.\ Configurar o programa <a name="toc2"></a>
Se obteve o ficheiro ReminderApp.zip, extraia-o, por exemplo, no caminho:    
`C:\ficheiros de programas\ReminderApp`    

Também pode extraí-lo para a raiz do disco `C:\`, exemplo:    

`C:\ReminderApp`    

ou pode colocá-lo onde quiser.    

Uma vez extraído, este ficheiro contém os seguintes elementos:    

* A pasta "Doc" que contém os ficheiros de documentação para o idioma atualmente em uso (se estiver disponível).    
* A pasta "locale" que contém os ficheiros de tradução da interface de idioma disponível para o programa.    
* A pasta "Sons" que contém os ficheiros de sons de alarme, Pode adicioná-los diretamente a esta pasta, desde que estejam no formato "wav" e a sua duração seja inferior a 2 segundos, o ReminderApp irá carregar automaticamente os nomes e classificá-los inserindo-os na opção de configurações "Definir notificações", o que significa que se adicionar alarmes,o número de alarmes que definiu pode mudar e terá que redefini-lo no submenu do menu Configurações Alt+s e depois na caixa de diálogo "Definir notificações" na lista suspensa chamada: Usar alarme: seguido do nome do alarme .    
Existe também uma pasta "Samples" dentro da pasta "Sounds", esses sons são os utilizados pelo programa.    
* O ficheiro "ReminderApp.exe" (ficheiro executável para iniciar o programa a qualquer momento).    
* O ficheiro ReminderApp.ico (o formato de ficheiro ICO é gerenciado pelo sistema operacional Microsoft Windows, este formato também é amplamente utilizado para favicons. Este ícone fica visível na barra de tarefas assim que o programa é minimizado e é removido quando o programa é aplicação fechada).    

# Aviso

O ficheiro ReminderApp.zip, uma vez extraído, conterá o seu executável chamado ReminderApp.exe, que será declarado falso positivo pelo seu antivírus ao executá-lo pela primeira vez!    

Isto acontece com o antivírus Windows Defender, por exemplo.    

Como faço para permitir que o Windows Defender Antivirus execute o programa mesmo assim?    

Para permitir que o programa funcione com o Windows Defender, deve clicar em “Informações adicionais”. Um botão "Executar mesmo assim" aparecerá, basta clicar nele para iniciar a execução do programa no Windows.    

Isto precisa de ser feito sempre que o novo ficheiro executável ReminderApp.exe for instalado na pasta ReminderApp.    

# 3.\ Os menus <a name="toc3"></a>
Na janela principal do programa de inicialização, encontraremos os seguintes cinco menus, com os seus respectivos comandos.    

# Menu ficheiro Submenu Alt+ f

Neste primeiro menu, teremos as seguintes opções:    

# Submenu de Contatos:
* Exportar contactos do catálogo de endereços... Ctrl+Shift+E    
Pressione Enter, uma caixa de diálogo aparece como nome:    
`Exportar contactos`    
Selecione o local e o nome de exportação da sua lista, no campo de edição:    
`Nome do ficheiro`    
Em seguida, indique txt ou json no tipo de documento.    
`Tipo : ficheiros de texto (*.txt)`    
Seta para baixo para encontrar:    
`ficheiros JSON (*.json)`    
Por fim, guarde o seu ficheiro pressionando o botão:    
`Guardar`    
Se tudo correr bem, aparecerá a seguinte mensagem:    
`Nota! contactos exportados com sucesso!`    
* Importe contactos para sua agenda de endereços... Ctrl+Shift+I    
Pressione Enter, uma caixa de diálogo aparece como nome:    
`Selecione um ficheiro para importar`    
`Nome do ficheiro`    
Em seguida, indique txt ou json no tipo de documento.    
`Tipos de ficheiro: ficheiros JSON (*.json)`    
Seta para baixo para encontrar:    
Tipos de ficheiro: ficheiros de texto (*.txt)    
Selecione o ficheiro txt ou json exportado anteriormente e abra-o pressionando o botão:    
`Abrir`    
Se tudo correr bem, aparecerá a seguinte mensagem:    
`Nota! Importação concluída com sucesso!`    
Pressione o botão `OK`, uma nova caixa de diálogo aparecerá com o nome:    
`Escolha como proceder`    
`Ao escolher Sim, os contactos serão substituídos.`    
`Ao escolher Não, eles serão adicionados apenas aos existentes.`    
Pressione o botão Sim ou Não dependendo de sua escolha.
PARA A SUA INFORMAÇÃO    
`Os ficheiros JSON no caso deste programa são estruturados como uma lista de dados, por exemplo: ["...", "...", "..."] e são mais convenientes para o programa gerir, enquanto ficheiros de texto, eles são estruturados com um novo marcador de linha, por exemplo:    
line    
line    
line, etc, que são mais legíveis por humanos`.    

# Submenu de Configuração:
* Exportar a pasta de configuração... Ctrl+E    
Pressione Enter, aparecerá uma janela de diálogo com o nome:    
`Escolher pasta de destino`    
Selecione a localização para exportar a pasta ReminderApp_config no campo de edição:    
Seta para baixo para encontrar:    
Selecionar pasta    
Se tudo correu bem, a seguinte mensagem aparecerá:    
`Aviso! Configuração exportada com sucesso!`    
* Importar a pasta de configuração... Ctrl+I    
Pressione Enter, aparecerá uma janela de diálogo com o nome:    
`Escolher pasta de origem`    
Selecione a localização da pasta ReminderApp_config no campo de edição:    
Seta para baixo para encontrar:    
Selecionar pasta    
Se tudo correu bem, a seguinte mensagem aparecerá:    
`Aviso! Configuração importada com sucesso!`    
* Sair Alt+f4    
Esta opção fecha o programa, até a próxima reinicialização, através do ficheiro executável (ReminderApp.exe), a menos que o tenha configurado na inicialização do Windows.    

# Editar submenu do menu Alt+ e

Neste segundo menu, teremos as seguintes opções:

* Criar lista de lembretes com data de vencimento... Ctrl+L    
Esta função permite gerar uma lista de lembretes, cada um associado a um compromisso do tipo Compromisso ou Medicação.    
Para cada item, é possível definir uma data de aviso específica.    
A lista inteira pode ser configurada para se repetir até uma data limite, aplicando a repetição a todos os lembretes incluídos.    
Ao final, pressione "Salvar" para confirmar ou "Cancelar" para sair sem alterações.    
Por meio do menu de contexto da lista (inicialmente vazia), é possível gerenciar os itens individualmente: adicioná-los, modificá-los ou excluí-los.    
* Adicionar lembrete... Ctrl+N    
* Editar lembrete... F2    
* Mover lembrete... Ctrl+F2    
* Excluir lembrete... Del    
* Lembretes adicionais (submenu) com 3 itens:    
* Adicionar... Ctrl+Shift+1    
* Editar Ctrl+Shift+2    
* Excluir Ctrl+Shift+3    
Se adicionar uma nota a um lembrete, ela será guardada na pasta ReminderApp_config /ReminderApp_notes.    
As notas têm um número exclusivo no nome do ficheiro, por ex. "Notes_xxxx.txt", o programa é, portanto, capaz de localizá-las e geri-las.    
Nota: Na caixa de diálogo, ao adicionar um Aniversário ou Aniversário, também pode selecionar uma música e reproduzi-la/interrompê-la por meio de uma caixa de combinação e de um botão.    
As melodias são armazenadas na pasta Sounds, Samples, Melodies e estão no formato .wav.    
Pode adicionar mais, desde que sejam do mesmo formato e de curta duração.    
Caso haja vários aniversários/aniversários no mesmo dia, estes serão agrupados em uma única notificação, portanto será utilizada a primeira melodia da lista.    
Continuando com o menu Editar:    
* Excluir compromissos anteriores... Ctrl+Shift+A    
* Eliminar medicamentos passados... Ctrl+Shift+M    
* Catálogo de endereços... F4    
Uma caixa de diálogo será aberta para as opções descritas, siga as instruções no ecrã.    
* Definir a data atual Ctrl+Shift+H    
Isto redefinirá o seletor de data para a data atual.    
* Parar a notificação atual Ctrl+Shift+F1    

# Ver submenu do menu Alt+ v

Neste terceiro menu teremos as seguintes opções:    

* Ver aniversários F5    
*Ver agendamentos F6    
* Ver compromissos periódicos Shift+F6    
* Ver repetir lembrete Ctrl+F6    
*Ver aniversários F7    
*Ver medicamentos F8    
* Ver medicamentos periódicos Shift+F8    
* Mostrar a primeira coluna “Data” das listas, excluindo consultas e medicamentos.

Observação:    
Ao criar/editar um lembrete, também notará 2 tipos periódicos: (Consulta periódico e Medicamento periódico)    
Estes dois tipos de lembretes podem ser configurados com periodicidade: (Diário, Semanal, Anual), dependendo da semana para Semanal, a escolha do dia e a escolha do mês serão ativadas para Anual.    
Pode definir de 5 a 60 minutos, será avisado a tempo e terá a oportunidade de, não sei, mudar, se preparar, e quando o aviso expirar o alarme real disparará.    
Lembretes periódicos são inteligentes, pois passam para a próxima data equivalente quando expiram. Por exemplo, um lembrete diário periódico, sempre o encontrará no dia seguinte também e assim por diante.    
Não adicionei a opção de excluir lembretes periódicos (por motivos óbvios), mas pode vê-los no menu ver. Se quiser excluir um, basta definir a data que vê ativando-o em Ver, Mostrar a primeira coluna "Data" nas listas exibidas, (Excluindo compromissos e medicamentos) Em seguida, visualize o tipo de lembrete periódico que deseja excluir através do menu item de mesmo nome no menu "Visualizar" e observe sua data de entrada agora visível na primeira coluna à esquerda. Finalmente,defina esta data no seletor principal para poder vê-la e excluí-la.    

Pressione Enter, na opção desejada, para vê-la numa lista.    
Pressione a tecla de aplicativos ou shift+f10 para mostrar as opções disponíveis.    
Pressione Tab e clique no botão Fechar ou pressione a tecla Escape ou Enter para fechar esta caixa de diálogo e retornar à janela principal do programa.    

# Menu Configurações Submenu Alt+ s

Neste quarto menu teremos as seguintes opções:    

* Definir notificações Ctrl+Shift+N    
Pressione enter, uma caixa de diálogo aparece, mova com "Tab" e "Shift+Tab" para mover entre os controlos, setas para cima e para baixo para alterar o valor do parâmetro.    
`Número de repetições: 3`    
`Intervalo entre repetições (segundos): 8`    
`Usar alarme: Alarme 01`    
`Permite a leitura de horas no formato de 24 horas`    
Esta é uma caixa de seleção para escolher se deseja definir o formato para 24 horas ou 12 horas, o padrão é 24 horas.    
Pressione a barra de espaço para definir o formato de 12 horas.    
`Ativar leitura de data em formato europeu`    
Esta é uma caixa de seleção para definir o formato da data como EUA ou Europeu, o padrão é Europeu.    
Pressione a barra de espaço para definir o formato dos EUA.    
Esta caixa de diálogo contém as caixas de seleção seguintes:
* Minimizar o programa na inicialização (desmarcado por padrão)    
Se optar por minimizar o programa na inicialização, o programa irá esconder-se, na barra de tarefas, para não o incomodar, deverá ver o seu ícone, certamente nos ícones ocultos, poderá interagir com o menu de contexto sempre que quiser. mas o programa continuará a monitorizar quaisquer lembretes do dia.    
Se quiser que o ícone seja sempre visto na barra de tarefas, pode fazê-lo, uma vez oculto, configurando-o nas configurações do Windows, personalizações, barra de tarefas, mostrar todos os aplicativos e ativar o ReminderApp.    
* Autorun quando o Windows inicia (desmarcado por padrão)    
A escolha desta opção permitirá que o programa seja iniciado automaticamente quando o Windows for iniciado.    
* Mostrar visualização do lembrete na inicialização se o programa estiver minimizado (marcado por padrão)    
Quando o programa é minimizado na bandeja do sistema na inicialização, ele abre uma prévia dos lembretes do dia.    
* Verificar se há atualizações (selecionado por padrão)    
Se esta opção estiver habilitada, verifica se há atualizações do programa, na inicialização.
Assim que a configuração estiver concluída, pressione Enter ou o botão “OK” para validar as alterações. Para cancelar as alterações pressione Escape ou o botão "Cancelar".    
Continuando com o menu Configurações:
* Defina a combinação de teclas de atalho Ctrl+Shift+K    
As combinações de teclas de atalho para evitar que a notificação atual acione um alarme e para mostrar o lembrete (mesmo quando não estiver em primeiro plano) foram projetadas para funcionar fora da GUI do ReminderApp.    
Isto significa que, em caso de conflitos com outros aplicativos, poderá personalizá-los individualmente.    
Se criar uma combinação que já esteja em uso no programa será avisado por um som de erro e ela não será aceite.    
Se a sua nova combinação for válida, ela aparecerá na barra de título, poderá clicar no botão "Usar esta combinação" e ela será usada até que decida alterá-la novamente.    
* Definir idioma Ctrl+Shift+L    
Ao pressionar Enter neste item, será aberta uma caixa de diálogo onde existem alguns idiomas, que serão habilitados se a tradução estiver disponível na pasta local).    
pode escolher o idioma da interface selecionando entre os idiomas atualmente disponíveis mostrados nesta caixa de diálogo.    
Uma caixa de diálogo aparece informando que o idioma foi alterado e que o programa deve ser reiniciado para que essas alterações tenham efeito.

# Menu Ajuda Submenu Alt+ h

Neste quinto e último menu teremos as seguintes opções:    

* Informações do programa... F1    
Ao pressionar Enter neste item, uma caixa de diálogo será aberta onde as informações do programa serão mostradas, num documento de edição somente leitura no seu respectivo idioma, se disponível.    
Use as teclas de seta para navegar pelo texto.    
Uma vez feito isto, pressione Tab e clique no botão OK ou pressione a tecla Enter ou Escape para fechar esta caixa de diálogo e retornar à janela principal do programa.    
* Manual do utilizador... Shift+F1    
Ao pressionar Enter neste item, uma janela será aberta, mostrando a ajuda do programa num documento html de edição somente leitura no navegador padrão em seu respectivo idioma, se disponível, caso contrário receberá uma mensagem de aviso.    
Pressione Alt+F4 para fechá-lo.    
* Atalhos principais... F9    
Ao pressionar Enter neste item, uma caixa de diálogo será aberta, na qual os atalhos de teclado do programa serão mostrados em uma lista de edição somente leitura, use as teclas de seta para percorrer a lista.    
Pressione Tab e clique no botão Fechar ou pressione a tecla Escape ou Enter para fechar esta caixa de diálogo e retornar à janela principal do programa.    
* Verificar se há atualizaçõesCtrl+Shift+U    
Ao pressionar Enter neste item, será avisado se houver atualizações para o programa, em caso afirmativo siga as instruções no ecrã.

# 4.\ Informações adicionais para a janela principal da opção "Lembrete para o dia selecionado:" <a name="toc4"></a>
Quando altera a data, no seletor da janela principal, se a data selecionada corresponder a um lembrete, um som de sonar soará.    
No entanto, o foco poderá mudar para a lista se um lembrete tiver sido selecionado anteriormente.    
Para evitar esse inconveniente, pode desmarcar o lembrete antes de prosseguir, ou inserir a data diretamente após o pedido dia, mês, ano ou mês, dia, ano, dependendo das configurações de idioma do sistema (e não do programa).    
No seletor, pode navegar, usando as setas horizontais.    
Para utilizadores de leitores de ecrã como o NVDA, é importante ressaltar que este último não fala a posição atual no seletor. Recomendamos pressionar uma seta vertical: o NVDA comunicará a data que definiu e fornecerá atualizações assim que digitar um dia, mês ou ano completo.    
O Sonar resolve o problema de definir a data inicial, ao invés de passar o foco para a lista de lembretes, quando houver algum naquela data, ouve o som que avisa e pode jogar com seu par sem problemas :)    

# 5.\ Como funciona o Catálogo de endereços? <a name="toc5"></a>
Acesso a:    
`Editar submenu do menu Alt + e`    
então:    
`Livro de endereços... F4`    
Ao pressionar Enter nesta opção, uma caixa de diálogo é aberta com o nome:    
`Livro de endereços`    
Esta caixa de diálogo conterá a lista dos seus contactos, caso tenha adicionado um, caso contrário, esta lista estará vazia.    
Quando abre o menu de contexto, nesta caixa de diálogo, pressionando a tecla de aplicativos localizada próxima à tecla de controlo direito na maioria dos teclados. Em um teclado sem tecla de aplicativos, pressione shift+f10.    
Observe que algumas opções não estão disponíveis na lista de contactos dependendo do contexto. Pode pressionar Enter na opção desejada, então aqui estão as opções:    

* Adicionar contacto... Ctrl+N    
* Editar contacto... F2    
* Excluir contacto... Del    
* Encontrar contacto... Ctrl+F3    
Uma caixa de diálogo será aberta para as opções de menu descritas, siga as instruções no ecrã.    
* Encontrar o próximo F3    
* Encontrar anterior Shift + F3     
Ambas as opções são baseadas no nome do contacto digitado na caixa de diálogo "Localizar contacto", portanto a pesquisa é realizada com a correspondência seguinte ou anterior do mesmo nome encontrada na lista do catálogo de endereços.    
* Enviar e-mail para contacto... Ctrl+E    
Uma caixa de diálogo será aberta para esta opção, siga as instruções no ecrã.    

Observe que pode enviar um e-mail para o contacto se o e-mail do contacto tiver sido inserido no campo de edição separado por um espaço no início (e se necessário no final), ao editar o nome do contacto, por exemplo. Caso contrário, se não houver e-mail nesta caixa de edição, esta opção não estará disponível para envio.    

Se não tiver definido um programa de e-mail padrão, o sistema mostrará automaticamente uma caixa de diálogo, permitindo que selecione o aplicativo a ser usado para enviar o e-mail.    

# 6.\ Como abrir o programa na barra do sistema? <a name="toc6"></a>

* Aceda à barra do sistema pressionando Windows+b, seta para baixo até o ícone "Lembrete" e abra o menu de contexto pressionando a tecla de aplicativos localizada ao lado da tecla de controlo direito na maioria dos teclados. Num teclado sem tecla de aplicativos, pressione shift+f10.    
* Clique com o botão direito no ícone "Lembrete" localizado na barra do sistema do Windows.    

Quando o menu de contexto aparecer, pode usar as teclas de seta para navegar no menu e a tecla Enter para ativar qualquer um dos itens listados abaixo.    

* Mostrar lembrete    
Pressionar a tecla Enter nesta opção mostrará o programa.    
* Parar a notificação atual    
Pressionando a tecla Enter nesta opção, a notificação atual será interrompida.    
* Catálogo de endereços...    
Pressionar a tecla Enter nesta opção abre a caixa de diálogo "Catálogo de endereços".    
* Sair do lembrete    
Pressionar a tecla Enter nesta opção sairá do programa.    

---

Obrigado por ler esta documentação!    

Desejo-lhe um bom uso do programa ReminderApp (Reminder) 😉    
Gostaria de agradecer sinceramente a [Rémy Ruiz](mailto:remyruiz@gmail.com) por escrever esta documentação e tradução do ReminderApp para francês, inglês, italiano e espanhol e por seus comentários e sugestões.    
Gostaria de agradecer sinceramente a [Ângelo Abrantes](mailto:ampa4374@gmail.com) por escrever esta documentação e traduzir o ReminderApp para Portuguese_Portuguese.
