# ReminderApp (Reminder) - User manual

مع ReminderApp (المذكِّر)، لا نسيان بعد اليوم.
كُنْ مطمئنًا، هذا البرنامج موجود لتذكيرك بكل ما هو مهم، مما تحتاج لتذكُّره (مثل: تناول الدواء، موعدًا أو زيارة شخص ما، مع مربية الأطفال، موعدا يخص طفلك، أو مع المساعدة المنزلية، أو الممرضة، إلخ).
كذلك، تذكيرُك بأيام ذكرى الميلاد.
لقد مررنا جميعًا بهذه اللحظة المحرجة مرة واحدة على الأقل في حياتنا: نسيان عيد ميلاد أحد أحبائنا! يجب القول أنه ليس من السهل دائمًا تذكر تواريخ ميلاد جميع الأشخاص الذين اعتدت على معرفتهم (خاصة عندما تكون من عائلة كبيرة أو تكون جزءًا من مجموعة كبيرة من الأصدقاء).
يمكنك إدخال تواريخ ميلاد جميع أفراد العائلة وسيذكّرُك البرنامج بها كل عام مع منبه، بما في ذلك التذكير بذكرى سنوية!
يحتوي هذا البرنامج أيضًا على سجلٍّ للعناوين، إضافةً للكثير الذي يمكن اكتشافه!
لمعرفة المزيد حول هذا البرنامج وكيفية ضبطه؛ يُرجى قراءة هذا الدليل كاملاً. وشكرًا.
ملاحظة: اُستخدمَتْ ضمن هذا الدليل مصطلحاتٌ خاصة متعارف عليها لدى مستخدمي التقنيات المساعدة للمكفوفين.
# دليل المستخدم
* المطوِّر: [Adriano Barbieri](mailto:adrianobarb@yahoo.it)
* يوليو  تعديل: 2025

## جدول المحتويات

* [1.\ مقدمة](#toc1)
* [2.\ ضبطُ البرنامج](#toc2)
* [3.\ القوائم](#toc3)
* [4.\ مزيدٌ من المعلومات حول النافذة الرئيسية لخيار "التذكيرات المتاحة في اليوم المختار".:"](#toc4)
* [5.\ كيف يعمل سجلُّ العناوين?](#toc5)
* [6.\ كيف تفتح البرنامج من صينية النظام؟](#toc6)


---
# 1.\ مقدمة <a name="toc1"></a>
هذا البرنامج عبارة عن مزيج من جدول الأعمال ودفتر العناوين الذي طورته بنفسي، وأطلقت عليه اسم ReminderApp (الاسم الداخلي) ولكن في الواقع تظهر نافذة البرنامج وفي نظام شريط الحالة باسم "المذكِّر".
برنامج ReminderApp برنامج محمول، ويمكن ضبطُهه بتصغيره وتشغيله تلقائيًا مع بدء تشغيل Windows.

هذا البرنامج منطقي في عمله للغاية ولا يتطلب الكثير من الشرح، ومع ذلك سأقدم لك بعض الإرشادات التي يجب اتباعها.

# 2.\ ضبطُ البرنامج <a name="toc2"></a>
إذا حصلت على ملف ReminderApp.zip فاستخرجه مثلاً في المسار:
`C:\Program Files\ReminderApp`    
يمكنك أيضًا استخراجه إلى جذر القرص الرئيسي `C:\`، على سبيل المثال:

`C:\ReminderApp`    


أو يمكنك وضعه حيثما شئت.

بعد الاستخراج، سيحتوي على العناصر الآتية:
* المجلد "Doc" الذي يحتوي على ملفات دليل البرنامج للغات المتوفرة واللغة المستخدمة حاليًا (إن كان متوفرا).
* مجلد "locale" الذي يحتوي على ملفات الترجمة الخاصة بواجهة اللغات المتوفرة للبرنامج.
* مجلد "Sounds" الذي يحتوي على ملفات أصوات التنبيه، يمكنك إضافة ما تريد من الأصوات مباشرة إلى هذا المجلد، ما دامت بصيغة "wav"، ومدتها أقل من ثانيتين، سيجلب تطبيق ReminderApp الأسماء ويفرزها تلقائيًا ضمن خيار إعدادات "ضبط المنبِّه"، مما يعني أنك إذا أضفت أصوات تنبيهات، سيتغير عدد أصوات المنبه، وسيتعين عليك إعادة تعيينها من قائمة الإعدادات الفرعية ثم مربع الحوار "ضبط المنبه" تحت عبر خيار يُعرض كقائمة منسدلة تسمى: اختَرْ منبِّهاً لاستخدامه: متبوعًا باسم المنبه.
يوجد أيضًا مجلد "Samples" داخل مجلد "Sounds"، يحتوي على ملفات الأصوات التي يستخدمها البرنامج.
* ملف "ReminderApp.exe" (ملف تنفيذي لبدء تشغيل البرنامج في أي وقت).
* ملف ReminderApp.ico (يُدار تنسيق ملف ICO بواسطة نظام التشغيل Microsoft Windows، ويستخدم هذا التنسيق أيضًا على نطاق واسع للأيقونات المفضلة. يكون هذا الرمز مرئيًا في شريط المهام بمجرد تصغير البرنامج ويُزال عند إغلاق البرنامج).

# تحذير
سيحتوي ملف ReminderApp.zip، بمجرد استخراجه، على ملفه التنفيذي ReminderApp.exe، والذي سيُعلَن عنه خطأً كملف ضار من قِبَل برنامج مكافحة الفيروسات الخاص بك عند تشغيله لأول مرة!
يحدث هذا مع برنامج مكافحة الفيروسات Windows Defender على سبيل المثال.
كيف أسمح لبرنامج Windows Defender Antivirus بتشغيل البرنامج على أية حال؟
للسماح للبرنامج بمواصلة العمل مع Windows Defender، يجب عليك النقر فوق "مزيد من المعلومات". حيث يظهر بعد ذلك زر "تشغيل على أية حال"، ما عليك سوى النقر عليه لبدء تشغيل البرنامج على نظام Windows.

ستحتاج لعمل هذا فقط عند استخراج مجلد البرنامج وتوليد الملف التنفيذي لأول مرة.


# 3.\ القوائم <a name="toc3"></a>
عند بدء تشغيل البرنامج، سنجد في نافذته الرئيسية القوائم الخمس الآتيية مع الأوامر الخاصة بها.

# قائمةُ ملف الفرعية Alt+م م

في هذه القائمة، -التي هي أول القوائم- سنجد الخيارات الآتية:
# جهات الاتصال فرعي
* تصدير سجلّ عناوين جهات الاتصال...	Ctrl+Shift+E
اضغط على مفتاح الدخول Enter، وسيظهر مربع حوار باسم:
`تصدير جهات الاتصال`
اختَرِ الموقع واسم ملف لتصدير قائمتك، في حقل التحرير:
`اسم الملف`    
ثم اختَرْ txt أو json من صندوق خيارات نوع المستند.
`النوع: ملفات نصية (*.txt)`
استخدمِ السهم لأسفل للعثور على:
`ملفات JSON (*.json)`
ثم احفظِ الملف بالضغط على:
`حفظ`    
إذا تمت العملية بنجاح؛ ستظهر الرسالة الآتية:
`ملاحظة! اكتمل تصدير جهات الاتصال بنجاح!`
استيراد جهات الاتصال لسجلّ عناوينك...	Ctrl+Shift+I

عند الضغط على مفتاح الدخول Enter، سيظهر مربع حوار باسم:
``اختَرْ ملفًا لاستيراده``
`اسم الملف`    
ثم اختَرْ txt أو json من خانة نوع المستند.
"أنواع الملفات: ملفات JSON (*.json)".
استخدمِ السهم السفلي للعثور على:
أنواع الملفات: ملفات نصية (*.txt)
حدد ملف txt أو json الذي صُدِّر مسبقًا، ثم افتحه بالضغط على الزر:
`فتح`    
إذا مضى الأمر بنجاح؛ ستظهر الرسالة الآتية:
`ملاحظة! اكتمل الاستيراد بنجاح!`
اضغط على زر `موافق`، وسيظهر مربع حوار جديد بالاسم:
`اختَرْ كيفية المواصلة`
`باختيار نعم، ستُستبدَل جهات الاتصال الموجودة.`
`باختيار لا، ستُضافُ العناصر الجديدة فقط، مع الاحتفاظ بالعناصر الموجودة`
اختَرْ ما تفضّلُه.
لتكون على علم
`ملفات JSON في هذا البرنامج مُعَدّةٌ كقائمة بيانات، كالشكل التالي: ["..."، "..."، "..."] وإدارتها في هذه الحال أسهل، بينما الملفات النصية التي يُفصَل بين عناصرها باستخدام علامة السطر الجديد، على سبيل المثال "سطر\nسطر\n" أيسر قراءة من قبل المستخدم`.
# إعدادات فرعي:
* تصدير مجلد التكوين... Ctrl+E    
اضغط على إدخال، ستظهر نافذة حوار بعنوان:    
`اختر مجلد الوجهة`    
حدد موقع تصدير مجلد ReminderApp_config في حقل التعديل:    
السهم للأسفل للعثور على:    
اختر المجلد    
إذا تم كل شيء بنجاح، سيظهر الرسالة التالية:    
`تحذير! تم تصدير التكوين بنجاح!`    

* استيراد مجلد التكوين... Ctrl+I    
اضغط على إدخال، ستظهر نافذة حوار بعنوان:    
`اختر مجلد المصدر`    
حدد موقع مجلد ReminderApp_config في حقل التعديل:    
السهم للأسفل للعثور على:    
اختر المجلد    
إذا تم كل شيء بنجاح، سيظهر الرسالة التالية:    
`تحذير! تم استيراد التكوين بنجاح!`

* خروج  Alt+f4    
هذا الخيار يغلق البرنامج تماما، إلى أن تُعيد تشغيله عبر ملفه التنفيذي (ReminderApp.exe)، أو عند عند إعادة تشغيل الجهاز إن كنتَ ضبطتَه بحيث يعمل تلقائيا عند تسجيل الدخول لويندوز.

# قائمة تحرير الفرعية Alt+ت ت

في هذه القائمة الثانية ستكون لدينا الخيارات التالية:

* إنشاء قائمة تذكير بتاريخ انتهاء... Ctrl+L    
تتيح هذه الوظيفة إنشاء قائمة من التذكيرات، كل منها مرتبط بموعد من نوع "موعد" أو "دواء".    
لكل عنصر، يمكن تحديد تاريخ تنبيه مخصص.    
يمكن إعداد القائمة بأكملها لتتكرر حتى تاريخ نهائي، مع تطبيق التكرار على جميع التذكيرات المدرجة.    
عند الانتهاء، اضغط على "حفظ" للتأكيد أو "إلغاء" للخروج دون إجراء تغييرات.    
من خلال القائمة السياقية للقائمة (التي تكون فارغة في البداية)، يمكن إدارة العناصر الفردية: إضافتها، تعديلها أو حذفها.    
* إضافة تذكير...	Ctrl+N
* تعديلُ التذكير...	F2
* نقلُ التذكير...	Ctrl+F2
* حذفُ التذكير...	Del
* ملاحظاتٌ إضافية حول التذكير
إذا أضفتَ ملاحظة إلى تذكير، فستُحفَظ في مجلد ReminderApp_config /ReminderApp_notes.
ستنفرد كل ملاحظة برقم يخصها ضمن اسم الملف، مثل: "Notes_xxxx.txt"، حتى يكون البرنامج قادراً على العثور عليها وإدارتها.
ملاحظة: في مربع الحوار، عند إضافة ذكرى سنوية أو يوم ميلاد، يمكنك أيضًا تحديد نغمة عبر صندوق خيارات ضبط النغمة، ويمكنك تشغيلها أو وَقْفُها عبر زر تشغيل/وَقْف.
النغمات محفوظةٌ ضمن المسار Sounds\Samples\Melodies، بصيغة .WAV.
يمكنك إضافة مزيد من الأصوات، ما دامت قصيرة المدة وبذات الصيغة.
إذا كان هناك العديد من المناسبات السنوية/أعياد الميلاد في نفس اليوم، فستُجمَعُ في واحد، وسيُستخدم اللحن الأول في القائمة.
المتابعة مع قائمة التحرير:
* حذفُ المواعيد الماضية...	Ctrl+Shift+A
* حذف مواعيد الأدوية السابقةة...	Ctrl+Shift+M
* سجلّ العناوين...	F4
يفتح مربع حوار يحتوي على الخيارات سالفة الذكر، اتّبعِ التعليمات الظاهرة على الشاشة.
* ضبطُ التاريخ الحالي	Ctrl+Shift+H
سيُعيد تعيين منتقي التاريخ إلى اتاريخ الحالي.
* وَقْفُ التنبيه الحالي	Ctrl+Shift+F1

# قائمةُ عرض الفرعية Alt+ع ع
في هذه القائمة، توجد الخيارات الآتية:

* اطّلِعْ على أيام الميلاد	F5
* اطَّلِعْ على المواعيد	F6
* اطَّلِعْ على المواعيد المتكررة	Shift+F6
* اطَّلِعْ على التذكيرات المتكررة	Ctrl+F6
* اطَّلِعْ على الذكريات السنوية	F7
* اطَّلِعْ على مواعيد الأدوية	F8
* اطَّلِعْ على الأدوية المتكررة	Shift+F8
اضغَطْ مفتاح الدخول Enter على الخيار المطلوب، لعرضه كقائمة.
اضغَطْ مفتاح التطبيقات أو shift+f10 لعرض الخيارات المتوفرة.
اضغَطْ مفتاح الانتقال Tab ثم اضغط على زر الإغلاق، أو مفتاح الهروب أو مفتاح الدخول للخروج من مربع الحوار.
عند إنشاء أو تعديل تذكير، ستلاحظ أيضًا وجود نوعين من المواعيد المتكررة: (الموعد المتكرر والدواء المتكرر).
يمكن ضبط هذين النوعين من التذكيرات وِفقا لخيارات التكرار: (يومي، أسبوعي، سنوي)، عند اختيار "أسبوعي" سيُفعَّل اختيار اليوم، وعند اختيار "سنوي" سيُفعَّل خيار "الشهر".
يمكنك اختيار المدة بين 5 إلى 60 دقيقة، وستُنبَّه في الوقت المحدد، وسيكون لديك الفرصة للاختيار بين عدم العلم، والتغيير والاستعداد، وعند انتهاء الوقت الفعلي للتنبيه، سيتوقف المنبه.
تعد التذكيرات المتكررة أمرًا ذكيًا، فهي تنتقل إلى التاريخ المعادل التالي عند انتهاء صلاحيتها. على سبيل المثال، تذكير يومي متكرر، ستجده دائمًا في اليوم التالي أيضًا، وهكذا.
لم أضع خيارا لحذف التذكيرات المتكررة، غير أنه يمكنك عرضها من قائمة عرض.
إذا رغبتَ في حذف أحدها، ما عليك سوى تنشيط خيار إظهار عمود "التاريخ" أولاً في القوائم المعروضة (باستثناء قوائم التذكير بالمواعيد والأدوية) من قائمة "عرض".
بعد ذلك، اختَرْ نوع التذكير المتكرر الذي تود حذفه من قائمة "عرض"، وستلاحظ وجود تاؤسخه ضمن العمود الأول في القائمة المعروضة.
ثم اضبط منتقي التاريخ الرئيسي على هذا التاريخ، بحيث يمكنك رؤية ذلك الموعد وحذفه.
المتابعة مع قائمة "عرض":
* إظهار عمود "التاريخ" أولاً في القوائم المعروضة (باستثناء قوائم التذكير بالمواعيد والأدوية)
تُعَدُّ رؤية هذه التواريخ مفيدة للعثور بسهولة على التذكيرات؛ لتغييرها أو حذفها عن طريق تحديد التاريخ من منتقي التاريخ الرئيسي.

# قائمة إعدادات الفرعية Alt+إ إ
في هذه القائمة، توجد الخيارات الآتية:

* ضبطُ المنبِّه	Ctrl+Shift+N
اضغَطْ مفتاح الدخول، وسيظهر مربّع حوار، يمكنك الانتقال بين عناصره بالضغط على مفتاح الانتقال "Tab" أو "Shift+Tab"، واستخدام السهمين العلوي أو السفلي لتغيير قيمة العنصر.
`عدد مرات تكرار النغمة: 3`
`الفاصل الزمني بين مرات تكرار النغمة (ثوانٍ): 8`
`اختَرْ منبِّهاً لاستخدامه: Alarm001`
`تفعيل تنسيق 24 ساعة لعرض الساعات`
هذا مربّع تحديد يخيّرك بين ضبط تنسيق الوقت لتنسيق 24 ساعة أو 12 ساعة، الخيار الافتراضي 24 ساعة.
اضغَطْ مفتاح المسافة للتبديل لتنسيق 12 ساعة.
`تفعيل التنسيق الأوروبي للتاريخ`
هذا مربّع تحديد، يخيرك بين ضبط تنسيق التاريخ للنمط الأوروبي أو الأمريكي. الخيار الافتراضي هو التنسيق الأوروبي.
اضغَطْ مفتاح المسافة للتبديل إلى التنسيق الأمريكي.
يحتوي مربع الحوار هذا أيضاً على مربعات التحديد الآتية:
* تصغير البرنامج عند بدء التشغيل
إذا فعّلتَ هذا الخيار؛ ستختفي شاشة البرنامج عند تشغيله، بينما تبقى أيقونته موجودة على شريط المهام، بحيث يمكنك التفاعل معه عبر قائمة السياق المتصلة بها، وسيواصل البرنامج عرض تذكيرات اليوم.
إذا أردتَ أن يظهر الرمز دائمًا في شريط المهام، فيمكنك ذلك، عبر إعدادات Windows، بالذهاب لتصنيف "إضافاء طابع شخصي"، ومنه اختَرْ "شريط المهام"، ثم "عرض جميع الأيقونات في منطقة الإعلام"، وتنشيط ReminderApp.

* التشغيل التلقائي بعد تسجيل الدخول إلى Windows (معطَّلٌ افتراضيا)
تفعيل هذا الخيار يؤدي لبدء عمل البرنامج تلقائيا فَور بدء عمل Windows.
* إظهار التذكير عند بدء التشغيل إذا كان البرنامج مصغَّراً (مُفعَّلٌ افتراضيا)
إذا كان البرنامج مصغَّراً عند بدء التشغيل؛ سيُظهر نافذة للتذكير بمواعيد اليوم.
* التحقُّق من وجود نحديثات (مفعَّلٌ افتراضيا)
عند تفعيل هذا الخيار؛ سيتحقق البرنامج آليا من وجود تحديثات له عند بدء تشغيله.
إذا انتهيت من ضبط الإعدادات، اضغط على مفتاح الدخول Enter أو "موافق" لتطبيق التغييرات. لإلغاء التغييرات اضغط على مفتاح الهروب Escape أو إلغاء "Cancel".
المتابعة مع قائمة إعدادات:
* ضبط مجموعة مفاتيح الاختصار الساخنة	Ctrl+Shift+K
ضُبطت مجموعة المفاتيح الساخة المخصصة لوَقْف التنبيهات الحالية عن العمل، وعرض التذكيرات، (وإن لم يكُنْ في الخلفية) لتعمل خارج وواجهة التطبيق الرسومية.
وهذا يتطلب في حال تعارضها مع تطبيقات أخرى، إمكانية تخصيصها بنفسك لتجاوز ذلك التعارض.
إذا اخترتَ مجموعة مفاتيح مستخدمة بالفعل في البرنامج؛ سيُشير البرنامج لذلك بإصدار نغمة، ولن تُقبل كمفتاح اختصار.
إذا كانت مجموعة المفاتيح المدخلة متاحة للاستخدام، سيظهر ذلك ضمن شريط العنوان، وسيمكنك الضغط على زر "اعتمِدْ هذه المفاتيح" وستُعتمد كمفتاح اختصار إلى أن تغيّره مرة أخرى.
* ضبطُ اللغة	Ctrl+Shift+L
عند ضغط مفتاح الدخول على هذا العنصر، سيفتح مربَّع حوار، يضم عددا من اللغات، التي توجد لها ملفات ترجمة خاصة بها ضمن مجلد "Locale".
يمكنك اختيار لغة الواجهة من بين اللغات المتوفرة هنا.
سيظهر مربع حوار بعد اختيار اللغة يينبهك لوجوب إعادة تشغيل البرنامج لتسري التغييرات وِفقا للغة المختارة.

# قائمة مساعدة

تحتوي هذه القائمة على الخيارات الآتية:

* معلومات البرنامج...	F1
عند ضغط مفتاح الدخول على هذا الخيار، سيفتح مربع حوار، يعرض معلومات عن البرنامج، كمستند لقراءة فقط، بلغة الواجهة المختارة.
استخدم المفاتيح NVDA+b أو Insert+B وِفقا لما هو معتمد في قارئ الشاشة لديك لقراءة هذه المعلومات مرة أخرى.
بمجرد الانتهاء، اضغط على مفتاح الانتقال Tab ثم انقر فوق الزر موافق (OK) أو اضغط على مفتاح الدخول Enter أو الهروب Escape لإغلاق مربع الحوار والعودة لنافذة البرنامج الرئيسية.
* دليل المستخدم...	Shift+F1
عند ضغط مفتاح الدخول على هذا العنصر، سيفتح دليل المستخدم الخاص بالبرنامج كملف قابل للقراءة بصيغة HTML، في متصفح الإنترنت الافتراضي، باللغة المختارة لواجهة المستخدم، إذا لم يكن متوفرا باللغة المختارة، سيظهر تنبيهك لإخبارك بهذا.
اضغَطْ Alt+F4 لإغلاقه.
* مفاتيح الاختصار...	F9
عند تفعيل هذا العنصر، ستظهر قائمةٌ بمفاتيح الاختصار المتوفرة، ضمن حقل تحرير للقراءة فقط. استخدِمْ مفاتيح الأسهم لتصفُّح القائمة.
اضغَطْ مفتاح الانتقال Tab للانتقال لزر "موافق" واضغَطْ عليه، أو اضغَطْ مفتاح الهروب أو الدخول لإغلاقها والعودة للنافذة الرئيسية.
* التحقُّق من وجود تحديثات... Ctrl+Shift+U    
عند تفعيل هذا العنصر بمفتاح الدخول؛ سيعلمك البرنامج إن كانت هناك تحديثات متوفرة له، إن وُجدت؛اتّبعِ التعليمات التي ستظهر لك على الشاشة.

# 4.\ مزيدٌ من المعلومات حول النافذة الرئيسية لخيار "التذكيرات المتاحة في اليوم المختار:" <a name="toc4"></a>
عندما تغيِّر التاريخ عبر منتقي التاريخ الموجود ضمن الشاشة الرئيسية؛ إن وُجِدَ تذكير مرتبطٌ بالتاريخ المحدد الذي مررتَ به؛ سيصدر صوتٌ يُشير لهذا.
قد ينتقل التركيز إلى القائمة كان التذكير محددا.
لتجنُّب هذا الإزعاج، يمكنك إلغاء تحديد التذكير قبل المتابعة، أو إدخال التاريخ مباشرة بعد اليوم المطلوب، أو الشهر، أو السنة، أو الشهر، أو اليوم، أو السنة، اعتمادًا على إعدادات لغة النظام (وليس إعدادات البرنامج).
ضمن منتقي التاريخ، يمكنك استخدام أسهم الحركة الأُفقية (الأيمن والأيسر) للتبديل بين حقول اليوم والشهر والسنة.
لمستخدمي قارئات الشاشة مثل NVDA، من المهم ملاحظة أنه لا يقرأ الحقل الحالي المركَّز عليه في منتقي التاريخ. نوصي بالضغط على السهم رأسيا (العلوي أو السفلي): سيبلغك NVDA بالتاريخ الذي حددته وسيزودك بالتحديثات بمجرد كتابة اليوم أو الشهر أو السنة.
سيسهّل عليك كثيراصدور الصوت الذي يشعرك بارتباط التاريخ بتذكير، بحيث يكفيك عناء الانتقال لقائمة التذكيرات مع كل تاريخ، لتفقُّد وجود تذكيرات مرتبطة به، وستنتقل للقائمة فقط في حال نبهك الصوت لوجود تذكيرات متعلقة بالتاريخ الذي مررتَ عليه.

# 5.\ كيف يعمل سجلُّ العناوين? <a name="toc5"></a>
افتَحْْ
`قائمة تحرير الفرعية Alt+ ت`    
ثم:
`سجلّ العناوين...	F4`
عند تفعيل هذا الخيار؛ سيفتح مربع حوار باسم:
`سجلُّ العناوين`
سيضمُّ قائمةً بكافة جهات الاتصال، إن كنتَ قد أضفتَها سابقا، وإلا ستكون القائمة فارغة.
يمكن فتح قائمة السياق في مربع الحوار هذا بالضغط على مفتاح التطبيقات الموجود بجوار مفتاح التحكم الأيمن في معظم لوحات المفاتيح. على لوحة المفاتيح التي لا تحتوي على مفتاح التطبيقات، اضغط على Shift+f10 بدلاً من ذلك.
يرجى ملاحظة أن بعض الخيارات غير متوفرة في قائمة جهات الاتصال وِفقا للسياق. يمكنك ضغط مفتاح الدخول Enter على الخيار الذي تريده لتفعيله. الخيارات كالآتي:

* إضافةُ جهة اتصال... Ctrl+N
* تعديل جهة اتصال... F2
* حذف جهة اتصال... Del
* البحث عن جهة اتصال... Ctrl+F3
يفتح مربع حوار يخص هذا الخيار، اتّبعِ التعليمات على الشاشة.
* البحث عن نتيجة لاحقة F3
* البحث عن نتيجة سابقة Shift+F3
يعتمد كلا الخيارين على اسم جهة الاتصال الذي كتبته في مربع الحوار "البحث عن جهة اتصال"، بحيث يجري البحث عن النتيجة المطابقة اللاحقة أو السابقة لنفس الاسم إذا وُجد في قائمة سجل العناوين.
* إرسال بريد إلكتروني إلى جهة الاتصال... Ctrl+E
سيفتح مربع حوار يخص هذا الخيار، اتّبعِ التعليمات على الشاشة.

يُرجى التنبُّه إلى أنه يمكنك إرسال بريد إلكتروني لجهة الاتصال  المختارة، إذا كنتَ قد أدخلتَ مسافة قبل عنوان البريد الإلكتروني وبعده (إن لزم الأمر) في حقل تحرير الاسم.

إذا لم تكُن قد عيّّنتَ برنامجا افتراضيا لإرسال البريد الإلكتروني؛ سيعرض نظام التشغيل لك تلقائيا مربع حوار لاختيار برنامج البريد الذي تود الإرسال عبره.

# 6.\ كيف تفتح البرنامج من صينية النظام? <a name="toc6"></a>

* توجَّهْ لصينية النظام بالضغط على Windows+b، ثم اضغَط السهم لأسفل للوصول إلى أيقونة "المذكِّر"، وافتح قائمة السياق بالضغط على مفتاح التطبيقات الموجود بجوار مفتاح التحكم الأيمن في معظم لوحات المفاتيح. على لوحة المفاتيح التي لا تحتوي على مفتاح التطبيقات، اضغط على Shift+f10 بدلاً من ذلك.
* أو انقر بزر الفأرة الأيمن على أيقونة البرنامج الموجودة في صينية النظام.

عندما تنبثق قائمة السياق، يمكنك استخدام الأسهم للتنقل عبر عناصرها الآتية، ومفتاح الدخول لتنشيط العنصر المطلوب.

* عرضُ المذكِّر
الضغط على هذا الخيار سيفتح نافذة البرنامج.
* وَقْفُ التنبيه الحالي
الضغط على هذا الخيار سيوقف التنبيه الحالي.
* سجلّ العناوين
يفتح مربع الحوار الخاص بسجلّ العناوين.
* الخروج من المذكِّر
هذا الخيار يُغلق البرنامج تماما.

---

شكرا على قراءتك لهذا الدلي.
أتمنى لك الاستفادة الجيدة من برنامج ReminderApp (المذكِّر) 😉
أود أن أشكر بشدة [Rémy Ruiz] (mailto:remyruiz@gmail.com) على كتابة هذا الدليل وترجمة ReminderApp إلى الفرنسية والإنجليزية والإيطالية والإسبانية وعلى تعليقاته واقتراحاته.
كما أود أن أشكر [هتون فلمبان] (mailto:h.felemban@hotmail.com) على ترجمة البرنامج وهذا الدليل إلى اللغة العربية.
