# Reminder App (Erinnerungen) - Benutzerhandbuch

Mit der ReminderApp (Erinnerungen) ist Schluss mit Vergessen!    
Seien Sie versichert, dass dieses Programm Sie an alles Wichtige erinnern wird, dank der Erinnerungsfunktion (z.B.: nehmen Sie Ihre Medikamente ein, vergessen Sie keinen Termin oder Besuch, mit dem Babysitter, der Haushaltshilfe, der Krankenschwester, usw.).    
Sogar Geburtstagserinnerungen!    
Wir alle haben diesen peinlichen Moment mindestens einmal im Leben erlebt, den Geburtstag eines geliebten Menschen zu vergessen! Zugegebenermaßen ist es nicht immer einfach, sich die Geburtstage all der Menschen zu merken, die man zu treffen gewohnt ist (vor allem, wenn man aus einer großen Familie stammt oder Teil einer großen Gruppe von Freunden ist).    
Tragen Sie die Geburtstage der ganzen Familie ein, und das Programm erinnert Sie jedes Jahr mit einem Alarm, einschließlich einer Erinnerung!    
Dieses Programm enthält auch ein Adressbuch für Kontakte und vieles mehr, was es zu entdecken gibt!

Für weitere Informationen und zur Konfiguration dieses Programms lesen Sie bitte diese Dokumentation vollständig durch. DANKE!

Hinweis: In diesem Dokument wird eine spezielle Terminologie für Benutzer verwendet, die IT-Hilfsmittel für blinde Menschen nutzen.    

# Benutzerhandbuch

* Autor: [Adriano Barbieri](mailto:adrianobarb@yahoo.it)
* Letzte Änderung: Juli 2025

## Inhaltsverzeichnis

* [1.\ Einleitung](#toc1)
* [2.\ Einrichten des Programms](#toc2)
* [3.\ die Menüs](#toc3)
* [4.\ Zusätzliche Informationen für das Hauptfenster "Erinnerung(en) für den ausgewählten Tag:"](#toc4)
* [5.\ Wie funktioniert das Adressbuch?](#toc5)
* [6.\ Wie öffnet man das Programm über die Taskleiste?](#toc6)


---


# 1.\ Einleitung <a name="toc1"></a>
Dieses Programm, das eine Kombination aus Kalender und Adressbuch ist, wurde ReminderApp genannt (interner Name), aber in Wirklichkeit erscheinen das Programmfenster und das Taskleistensymbol unter dem Namen 'Erinnerungen'.    

Die ReminderApp ist portabel und kann so konfiguriert werden, dass sie zu einem Symbol minimiert und automatisch beim Start von Windows ausgeführt wird.    

Dieses Programm ist sehr intuitiv und bedarf keiner großen Erklärung, aber hier werden Ihnen dennoch einige Hinweise an die Hand gegeben, die Sie beachten sollten.    

# 2.\ Einrichten des Programms <a name="toc2"></a>
Wenn Sie die Datei ReminderApp.zip haben, entpacken Sie sie z. B. in den Pfad:    
C:\Programme\ReminderApp    

Sie können die Datei auch in das Stammverzeichnis des Laufwerks "C:\" extrahieren, zum Beispiel:    

C:\ReminderApp    

oder Sie können sie auch an jedem anderen Ort Ihrer Wahl speichern.    

Nach der Extraktion enthält diese Datei die folgenden Elemente:    

* Der Ordner "Doc" mit den Hilfedateien des Programms in allen unterstützten Sprachen.    
* Der Ordner "locale" enthält die für das Programm verfügbaren Übersetzungsdateien für die Oberfläche.    
* Der "Sounds"-Ordner, der die Alarm-Sounddateien enthält. Sie können Ihre eigenen Alarme direkt zu diesem Ordner hinzufügen, solange sie im "wav"-Format sind und ihre Dauer weniger als 2 Sekunden beträgt. ReminderApp lädt die neuen Dateien automatisch und sortiert sie, wenn Sie sie in der Konfigurationsoption "Benachrichtigungen konfigurieren", zu finden im Menü Einstellungen (alt + e), auswählen, was bedeutet, dass sich die eingestellte Anzahl von Alarmen ändern kann, wenn Sie Alarme hinzufügen. Im oben benannten Dialogfeld sind die Alarme im Kombinationsfeld "Alarm:" aufgeführt.
Innerhalb des Ordners "Sounds" gibt es auch einen Ordner "Samples", der vom Programm verwendet wird.    
* Die Datei 'ReminderApp.exe' (ausführbare Datei, um das Programm jederzeit zu starten).    
* Die Datei ReminderApp.ico (das ICO-Dateiformat wird vom Betriebssystem Microsoft Windows verwaltet, dieses Format wird auch häufig für Favicons verwendet. Dieses Symbol ist in der Taskleiste sichtbar, sobald das Programm minimiert wird, und wird entfernt, wenn die Anwendung geschlossen wird).    

# Warnung

Die Datei ReminderApp.zip enthält nach dem Entpacken eine eigene ausführbare Datei namens ReminderApp.exe, die Ihr Antivirenprogramm beim ersten Start als falsch-positiv einstufen wird!    

Dies geschieht zum Beispiel mit dem Antivirusprogramm Windows Defender.    

Wie kann ich die Ausführung durch Windows Defender Antivirus trotzdem zulassen?    

Damit das Programm auch mit Windows Defender ausgeführt werden kann, müssen Sie auf "Weitere Informationen" klicken. Dann erscheint die Schaltfläche "Trotzdem ausführen". Klicken Sie einfach darauf, um das Programm in Windows auszuführen.    

Dies muss jedes Mal geschehen, wenn die ausführbare Datei ReminderApp.exe neu installiert wird.    

# 3.\ Die Menüs <a name="toc3"></a>
Wenn das Programm gestartet ist, befinden sich in dessen hauptfenster die folgenden fünf Menüs mit den entsprechenden Kurztasten.    

# Untermenü Datei Alt+d

In diesem ersten Menü haben wir die folgenden Optionen:    
# Kontakte Untermenü:
* Kontakte aus dem Adressbuch exportieren... CTRL+Shift+E    
Beim Auswählen dieser Option mit der eingabetaste wird ein Dialogfeld mit dem Namen:    
Kontakte exportieren    
angezeigt.    
Geben Sie den Speicherort und den Namen Ihrer exportierten Liste im Eingabefeld:    
`Dateiname`    
an.    
Dann geben Sie txt oder json als Dateityp an.    
`Dateityp: Textdatei (*.txt)`    
Pfeil nach unten:    
`JSON-Datei (*.json)`    
Zum Schluss speichern Sie Ihre Datei, indem Sie auf die Schaltfläche:    
`Speichern`    
klicken.    
Wenn alles gut gegangen ist, erscheint die folgende Meldung:    
`Hinweis! Kontakte erfolgreich exportiert!`    
* Kontakte ins Adressbuch importieren... Ctrl+Shift+I    
Beim Auswählen dieser Option mit der Eingabetaste wird ein Dialogfeld mit dem Namen:    
`Datei zum Importieren whälen`    
angezeigt.    
Wie beim Exportieren erst der  Dateiname,    
Dann geben Sie txt oder json als Dateityp an.    
`Dateityp: JSON-Dateien (*.json)`    
Pfeil nach unten:    
`Textdateien (*.txt)`    
Wählen Sie die zuvor exportierte txt- oder json-Datei aus und öffnen Sie sie, indem Sie auf die Schaltfläche:    
`Öffnen`    
klicken.    
Wenn alles gut gegangen ist, erscheint die folgende Meldung:    
`Hinweis! Import erfolgreich abgeschlossen!`    
Drücken Sie die Schaltfläche "OK". Es wird ein neues Dialogfeld mit dem Namen:    
`Methode zum Fortfahren wählen`    
angezeigt.    
`Falls ja, werden die Kontakkte überschrieben.`    
`Falls nein, werden sie lediglich zu bestehenden Kontakten hinzugefügt.`    
Drücken Sie je nach Ihrer Wahl den Schalter Ja oder Nein.    
ZU IHRER INFORMATION    
JSON-Dateien sind im Falle dieses Programms als eine Liste von Daten strukturiert, z. B.: ["...", "...", "..."], und sind für das Programm einfacher zu handhaben, während Textdateien mit einem Zeilenumbruch strukturiert sind, z. B.: "Zeile\nZeile\nZeile" usw., die für den Menschen besser lesbar sind.    
# Konfiguration Untermenü:
* Exportiere den Konfigurationsordner... Ctrl+E    
Drücken Sie die Eingabetaste, es wird ein Dialogfenster mit dem Titel angezeigt:    
`Zielordner wählen`    
Wählen Sie den Speicherort für den Export des Ordners ReminderApp_config im Bearbeitungsfeld:    
Pfeiltaste nach unten, um zu finden:    
Ordner auswählen    
Wenn alles gut gelaufen ist, wird folgende Nachricht angezeigt:    
`Warnung! Konfiguration erfolgreich exportiert!`    
* Importiere den Konfigurationsordner... Ctrl+I    
Drücken Sie die Eingabetaste, es wird ein Dialogfenster mit dem Titel angezeigt:    
`Quellordner wählen`    
Wählen Sie den Speicherort des Ordners ReminderApp_config im Bearbeitungsfeld:    
Pfeiltaste nach unten, um zu finden:    
Ordner auswählen    
Wenn alles gut gelaufen ist, wird folgende Nachricht angezeigt:    
`Warnung! Konfiguration erfolgreich importiert!`    
* Beenden Alt+f4    
Diese Option schließt das Programm bis zum nächsten Neustart über die ausführbare Datei (ReminderApp.exe), es sei denn, Sie lassen das Programm mit Windows automatisch starten.    

# Untermenü Bearbeiten Alt+b

In diesem zweiten Menü haben wir folgende Optionen:

* Erinnerungsliste mit Ablaufdatum erstellen... Ctrl+L    
Diese Funktion ermöglicht es, eine Liste von Erinnerungen zu erstellen, von denen jede mit einem Termin des Typs „Termin“ oder „Medikament“ verknüpft ist.    
Für jeden Eintrag kann ein spezifisches Erinnerungsdatum festgelegt werden.    
Die gesamte Liste kann so konfiguriert werden, dass sie sich bis zu einem Enddatum wiederholt, wobei die Wiederholung auf alle enthaltenen Erinnerungen angewendet wird.    
Am Ende „Speichern“ drücken, um zu bestätigen, oder „Abbrechen“, um ohne Änderungen zu beenden.    
Über das Kontextmenü der Liste (anfangs leer) können einzelne Elemente verwaltet werden: hinzufügen, bearbeiten oder löschen.    
* Erinnerung hinzufügen... Ctrl+N    
* Erinnerung bearbeiten... F2  
* Erinnerung verschieben... Ctrl+F2    
* Erinnerung löschen... Del   
* Zusätzliche Anmerkungen zur Erinnerung(Untermenü) mit 3 Einträgen:    
* Hinzufügen... Ctrl+Shift+1    
* Bearbeiten... Ctrl+Shift+2    
* Löschen... Ctrl+Shift+3    
Wenn eine Anmerkung zu einer Erinnerung hinzugefügt wird, wird sie im Ordner ReminderApp_config /ReminderApp_notes gespeichert.    
Anmerkungen haben eine eindeutige Nummer im Dateinamen, z. B. "Notes_xxxx.txt", so dass das Programm sie finden und verwalten kann.    
Hinweis: Im Dialogfeld zum Hinzufügen einer Erinnerung können Sie im Falle eines Jubiläums oder Geburtstags auch eine Melodie in einem entsprechenden Kombinationsfeld auswählen. Beim Auswählen einer Melodie wird diese automatisch abgespielt, mit einer entsprechenden Schaltfläche können Sie die Wiedergabe starten und stoppen.    
Die Melodien werden im Ordner Sounds, Samples, Melodies gespeichert und sind im .wav-Format.    
Sie können weitere Melodien hinzufügen, solange sie das gleiche Format haben und von kurzer Dauer sind.    
Wenn mehrere Jubiläen / Geburtstage auf denselben Tag fallen, werden diese in einer einzigen Benachrichtigung zusammengefasst, so dass die erste Melodie in der Liste verwendet wird.    
Weiter im Menü Bearbeiten:    
* Vergangene Termine löschen... Ctrl+Shift+A    
* nicht mehr benötigte Medikamente löschen... Ctrl+Shift+M    
* Adressbuch... F4  
Für die soeben beschriebenen Optionen öffnet sich ein Dialogfeld, folgen Sie den Anweisungen auf dem Bildschirm.    
* Auf aktuelles Datum einstellen Ctrl+Shift+H    
Dadurch wird die Ausklappliste zum Wählen des Datums im Erinnerungsfenster auf das aktuelle Datum zurückgesetzt.    
* Aktuelle Benachrichtigung stoppen Ctrl+Shift+F1    

# Untermenü ansicht Alt+a

In diesem dritten Menü haben wir die folgenden Optionen:    

* Geburtstage zeigen F5  
* Termine zeigen F6  
* Regelmäßige Termine zeigen Shift+F6    
* Wiederholende Erinnerungen zeigen Ctrl+F6    
* Jubiläen zeigen F7    
* Medikamente zeigen F8    
* Regelmäßige Medikamente zeigen Shift+F8    
Anmerkung:    
Wenn Sie eine Erinnerung erstellen/bearbeiten, sehen Sie auch zwei Arten von regelmäßiger Erinnerung: (regelmäßiger Termin und regelmäßiges Medikament).    
Diese beiden Arten von Erinnerungen können mit  täglicher, wöchentlicher oder jährlicher Wiederholung versehen werden, abhängig von der Woche für Wöchentlich, für Jährlich ist Tag und Monat zu wählen.    
Sie können zwischen 5 und 60 Minuten als Vorankündigung einstellen. Sie werden also rechtzeitig gewarnt und haben die Möglichkeit, sich umzuziehen, sich vorzubereiten, und wenn die Warnung abläuft, geht der eigentliche Alarm los.    
Regelmäßige Erinnerungen sind clever: Sie werden auf das nächste entsprechende Datum verschoben, wenn sie ablaufen. Eine regelmäßige Erinnerung, z. B. Täglich, finden Sie immer am nächsten Tag wieder, und so weiter.    
Die Option zum Löschen regelmäßiger Erinnerungen ist nicht eingebaut (aus offensichtlichen Gründen), aber Sie können sie über das Menü Ansicht sehen. Wenn Sie eine löschen möchten, stellen Sie einfach das Datum ein, das Sie sehen, indem Sie im Menü Ansicht die erste Spalte "Datum" in den angezeigten Listen aktivieren (ausgenommen Termine und Medikamente). Zeigen Sie dann die regelmäßigen Erinnerungen, die Sie löschen möchten, über den gleichnamigen Menüpunkt im Menü "Ansicht" an und notieren Sie das Anfangsdatum, das nun in der ersten Spalte auf der linken Seite sichtbar ist. Stellen Sie schließlich dieses Datum in der Hauptauswahl so ein, dass die Erinnerung angezeigt und gelöscht werden kann.    
Drücken Sie die Eingabetaste bei der gewünschten Option, um sie in einer Liste anzuzeigen.    
Drücken Sie die Anwendungstaste oder Shift+F10, um die verfügbaren Optionen anzuzeigen.    
Drücken Sie die Tabulatortaste und klicken Sie dann auf die Schaltfläche Schließen oder drücken Sie die Escape- oder Eingabetaste, um dieses Dialogfeld zu schließen und zum Hauptfenster zurückzukehren.    
Weiter im Menü Ansicht:    
* Anzeige der ersten Spalte "Datum" in angezeigten Listen (ausgenommen Termine und Medikamente) (standardmäßig nicht aktiviert)    
Die Anzeige dieser Daten ist nützlich, um Erinnerungen zum Bearbeiten oder Löschen zu finden, da Sie das Datum in der Hauptauswahl direkt entsprechend festlegen können.    

# Untermenü Einstellungen Alt+e

In diesem vierten Menü haben wir die folgenden Optionen:    

* Benachrichtigungen konfigurieren Ctrl+Shift+N    
Beim Auswählen dieser Option mit der Eingabetaste erscheint ein Dialogfeld, bewegen Sie sich mit "Tab" und "Shift+Tab" zwischen den Feldern, ändern Sie den Parameterwert mit den Pfeiltasten rauf und runter.    
`Anzahl der Wiederholungen: 3`    
`Intervall zwischen den Wiederholungen (in Sekunden): 8`    
`Alarm: Alarm 01`    
`24-Stunden-Format`    
Mit diesem Kontrollkästchen können Sie das 24-Stunden- oder das 12-Stunden-Format einstellen. Die Standardeinstellung ist 24 Stunden.    
Drücken Sie die Leertaste, um das 12-Stunden-Format einzustellen.    
`Europäisches Datumsformat`    
Dies ist ein Kontrollkästchen, mit dem Sie das US-amerikanische oder das europäische Datumsformat einstellen können; die Standardeinstellung ist europäisch.    
Drücken Sie die Leertaste, um das US-Format einzustellen.    
Des Weiteren gibt es in diesem Dialogfeld noch die folgenden Drei Kontrollkästchen:
- Automatisch mit Windows starten (standardmäßig nicht aktiviert)    
Wenn Sie diese Option wählen, wird das Programm beim Start von Windows automatisch gestartet.    
- Programm beim Start minimieren (standardmäßig nicht aktiviert)    
Wenn Sie sich dafür entscheiden, das Programm beim Start zu minimieren, wird es sich in der Taskleiste verstecken, um nicht zu stören. Sie sollten sein Symbol sehen, natürlich in den ausgeblendeten Symbolen. Mit dem Kontextmenü werden Sie allerdings interagieren können, wann immer Sie wollen und das Programm wird weiterhin alle Erinnerungen des Tages im Blick haben.    
Wenn Sie möchten, dass das Symbol immer in der Taskleiste sichtbar ist, können Sie dies, nachdem das Programm ausgeblendet wurde, in den Windows-Einstellungen aktivieren (Personalisierung, Taskleiste, in der Gruppierung "andere Taskleistensymbole" auf den Schalter "Alle Einstellungen anzeigen" und ReminderApp wählen).    
- beim Start Vorschau der Erinnerungen anzeigen, wenn das Programm minimiert ist (standardmäßig aktiviert)    
Wenn das Programm so konfiguriert ist, dass es beim Start in die Taskleiste minimiert wird, wird eine Vorschau der Erinnerungen des Tages geöffnet.    
Wenn die Konfiguration abgeschlossen ist, drücken Sie die Eingabetaste oder die Schaltfläche "OK", um die Änderungen zu bestätigen. Um die Änderungen zu verwerfen, drücken Sie die Escape-Taste oder die Schaltfläche "Abbrechen".    
* nach Updates suchen (standardmäßig aktiviert)    
Wenn diese Option aktiviert ist, wird beim Programmstart automatisch nach Updates gesucht.    
* Tastenkürzel festlegen Ctrl+Shift+K    
Die Tastenkombinationen zum stoppen der aktuellen Benachrichtigung und zum Anzeigen des Programms (auch wenn es nicht im Vordergrund ist) sind so konzipiert, dass sie außerhalb der ReminderApp-GUI funktionieren.    
Das bedeutet, dass im Falle von Konflikten mit anderen Anwendungen diese individuell angepasst werden können.    
Wenn Sie eine Kombination erstellen, die bereits im Programm verwendet wird, werden Sie durch einen Fehlerton gewarnt und die Kombination wird nicht akzeptiert.    
Ist Ihre neue Kombination gültig, wird sie in der Titelleiste angezeigt. Sie können dann auf die Schaltfläche "Diese Kombination verwenden" klicken, und sie wird so lange verwendet, bis Sie sie wieder ändern.    
* Sprache einstellen Ctrl+Shift+L    
Wenn Sie die Eingabetaste drücken, öffnet sich ein Dialogfeld, in dem einige Sprachen angezeigt werden, die aktiviert sind, wenn die Übersetzung im Ordner "locale" verfügbar ist. 
Sie können die Sprache der Benutzeroberfläche wählen, indem Sie eine der Sprachen auswählen, die dort angezeigt werden. 
Es erscheint ein Dialogfeld, das Sie darüber informiert, dass die Sprache geändert wurde und das Programm neu gestartet werden muss, damit die Änderungen wirksam werden. 

# untermenü Hilfe Alt+h

In diesem fünften und letzten Menü haben wir die folgenden Optionen:    

* Über das Programm... F1  
Wenn Sie die Eingabetaste drücken, öffnet sich ein Dialogfeld mit Informationen über das Programm in Ihrer jeweiligen Sprache, sofern verfügbar.    
Verwenden Sie den Befehl Ihres Bildschirmlesers zum Lesen des gesamten Fensterinhalts (Im Fall von NVDA NVDA + b), um den Text zu lesen.    
Wenn Sie fertig sind, klicken Sie auf die Schaltfläche schließen oder drücken Sie die Eingabetaste oder die Escape-Taste, um dieses Dialogfeld zu schließen und zum Hauptfenster zurückzukehren.    
* Benutzerhandbuch... Shift+F1    
Wenn Sie die Eingabetaste drücken, wird die Programmhilfe in einem HTML-Dokument in Ihrem Standardbrowser in Ihrer jeweiligen Sprache angezeigt, sofern verfügbar. Andernfalls werden Sie gefragt, ob Sie das Handbuch auf englisch lesen möchten, ebenfalls als HTML-Dokument in Ihrem Standardbrowser.    
Drücken Sie Alt+F4, um die Dokumentation zu schließen.    
* Schnelltasten... F9  
Wenn Sie die Eingabetaste drücken, öffnet sich ein Dialogfeld, in dem die Tastenkombinationen des Programms in einer schreibgeschützten Liste angezeigt werden. Mit den Pfeiltasten können Sie sich durch die Liste bewegen.    
Drücken Sie die Tabulatortaste und klicken Sie dann auf die Schaltfläche Schließen, oder drücken Sie die Escape- oder Eingabetaste, um dieses Dialogfeld zu schließen und zum Hauptfenster zurückzukehren.    
* nach Updates suchen... Ctrl+Shift+U    
Wenn Sie die Eingabetaste drücken, werden Sie benachrichtigt, ob es Programmupdates gibt. Ist dies der Fall, folgen Sie den Anweisungen auf dem Bildschirm.    

# 4.\ Zusätzliche Informationen für das Hauptfenster "Erinnerung(en) für den ausgewählten Tag:" <a name="toc4"></a>
Wenn Sie das Datum im Hauptfenster ändern und das gewählte Datum mit einer Erinnerung übereinstimmt, wird ein Sonar-Ton ausgegeben.    
Der Fokus kann sich jedoch auf die Liste verschieben, wenn zuvor eine Erinnerung ausgewählt wurde.    
Um diese Unannehmlichkeit zu vermeiden, können Sie entweder die Erinnerung abwählen, bevor Sie fortfahren, oder das Datum direkt nach der Reihenfolge Tag, Monat, Jahr oder Monat, Tag, Jahr eingeben, je nach den Spracheinstellungen des Systems (und nicht nach denen des Programms).    
MIt Pfeil Links und Rechts können Sie zwischen Tag, Monat und Jahr wechseln, mit den Pfeiltasten rauf und runter gehen Sie in der entsprechenden Einheit vor oder zurück.    
Für Benutzer von Bildschirmlesern wie NVDA ist es wichtig zu wissen, dass diese die aktuelle Position beim drücken von pfeil links und rechts nicht registrieren. Lediglich der Wechsel mit Pfeil hoch und runter wird registriert. NVDA teilt das eingestellte Datum mit und aktualisiert, sobald ein voller Tag, Monat oder Jahr eingegeben wird.    
Sonar löst das Problem bei der Einstellung des Anfangsdatums, anstatt den Fokus auf die Liste der Erinnerungen zu verschieben, wenn es eine an diesem Datum gibt, hören Sie den Ton, der Sie darauf aufmerksam macht, und Sie können ohne Probleme mit Ihrem Datum spielen :)    

# 5.\ Wie funktioniert das Adressbuch? <a name="toc5"></a>
Gehen Sie zu:    
`Untermenü "Bearbeiten" Alt+b`    
Dann:    
`Adressbuch... F4`    
Wenn Sie bei dieser Option die Eingabetaste drücken, erscheint ein Dialogfeld mit der Bezeichnung:    
`Adressbuch`    
Dieses Dialogfeld enthält die Liste Ihrer Kontakte, wenn Sie einen oder mehrere hinzugefügt haben; andernfalls ist diese Liste leer.    
Zum öffnen des Kontextmenüs in diesem Dialogfeld drücken Sie die Anwendungstaste, die sich auf den meisten Tastaturen links neben der rechten Steuerungstaste befindet. Auf einer Tastatur ohne Anwendungstaste drücken Sie stattdessen SHIFT+F10.    
Bitte beachten Sie, dass in der Kontaktliste einige Optionen je nach Kontext nicht verfügbar sind. Sie können die gewünschte Option mit der Eingabetaste auswählen, dann werden folgende Optionen angezeigt:    

* Kontakt hinzufügen... Ctrl+N    
* Kontakt bearbeiten... F2  
* Kontakt löschen... Del   
* Kontakt suchen... Ctrl+F3    
Für die soeben beschriebenen Menüoptionen öffnet sich ein Dialogfeld, folgen Sie den Anweisungen auf dem Bildschirm.    
Für das Eintragen eines Kontakts bietet es sich an, die Kontaktdaten (Name, adresse, usw.) mit Kommata getrennt in das Eingabefeld einzugeben.
* weitersuchen f3    
* rückwärts suchen Shift+F3    
Diese beiden Optionen basieren auf dem Text, der in das Dialogfeld "Kontakt suchen" eingegeben wurde, so dass die Suche nach dem nächsten oder vorherigen Treffer mit entsprechenden Vorkommen in der Kontaktliste durchgeführt wird.    
* E-Mail an Kontakt senden... Ctrl+E    
Es öffnet sich ein Dialogfeld für diese Option. Folgen Sie den Anweisungen auf dem Bildschirm.    

Bitte beachten Sie, dass Sie nur dann eine E-Mail an einen bestimmten Kontakt senden können, wenn dessen E-Mail-Adresse im Eingabefeld durch ein Leerzeichen am Anfang (und ggf. am Ende) getrennt eingegeben wurde, z.B. bei der Bearbeitung des Kontakts. -Wurde in diesem Eingabefeld keine E-Mail-Adresse eingegeben, ist diese Option nicht verfügbar.    

Wenn kein Standard-E-Mail-Programm eingerichtet wurde, zeigt das System automatisch ein Dialogfeld an, in dem Sie die Anwendung auswählen können, die für den Versand der E-Mail verwendet werden soll.    

# 6.\ Wie öffnet man das Programm über die Taskleiste? <a name="toc6"></a>

* Öffnen Sie die Taskleiste, indem Sie Windows+b drücken, gehen Sie mit dem Pfeil nach unten zum Symbol "Erinnerung" und öffnen Sie das Kontextmenü, indem Sie die Anwendungstaste drücken, die sich auf den meisten Tastaturen links neben der rechten Steuerungstaste befindet. Wenn Ihre Tastatur keine Anwendungstaste hat, drücken Sie Shift+f10, oder    
* Klicken Sie mit der rechten Maustaste auf das Symbol "Erinnerungen" im Windows-Infobereich.    

Sobald das Menü erscheint, können Sie mit den pfeiltasten rauf und runter durch das Menü blättern. Um einen der unten aufgeführten Punkte zu aktivieren, drücken Sie wie immer einfach die Eingabetaste.    

* Zeige Erinnerungen    
Wenn Sie bei dieser Option die Eingabetaste drücken, wird das Programm angezeigt.    
* Aktuelle Benachrichtigung stoppen    
Wenn Sie bei dieser Option die Eingabetaste drücken, wird die aktuelle Benachrichtigung beendet.    
* Adressbuch...    
Wenn Sie bei dieser Option die Eingabetaste drücken, öffnet sich das Dialogfeld "Kontaktverzeichnis".    
* Beende Erinnerungen    
Wenn Sie bei dieser Option die Eingabetaste drücken, wird das Programm beendet.    

---

Vielen Dank, dass Sie diese Dokumentation gelesen haben!    

Ich wünsche Ihnen eine gute Nutzung des Programms ReminderApp 😉    
Herzlicher Dank geht an [Rémy Ruiz](mailto:remyruiz@gmail.com) für die Erstellung dieser Dokumentation und die Übersetzung von ReminderApp ins Französische, Englische, Italienische und Spanische sowie für sein Feedback und seine Vorschläge. Auch herzlichen Dank an [Karl Eick](mailto:hozosch@web.de), der das Programm und dessen Handbuch auf deutsch übersetzt und ebenfalls Vorschläge und Feedback eingereicht hat.