# ReminderApp (Reminder) – Používateľská príručka

S ReminderApp (Reminder) už žiadne zabúdanie!
Uisťujeme vás, že tento program je tu, aby vám pripomenul všetko dôležité vďaka pripomienkam, ako sú (napr.: vezmite si lieky, nezabudnite na schôdzku alebo niečiu návštevu, s opatrovateľkou, pomoc v domácnosti, zdravotná sestra atď.).
Dokonca aj pripomenutie narodenín!
Všetci sme aspoň raz v živote zažili tento trápny okamih: zabudnúť na narodeniny niekoho blízkeho! Nutné povedať, že nie vždy je ľahké zapamätať si dáta narodenín všetkých ľudí, ktorých ste zvyknutí poznať (najmä keď pochádzate z veľkej rodiny alebo ste súčasťou veľkej skupiny priateľov) .
Zadáte dáta narodenín celej rodiny a program vám ich každý rok pripomenie budíkom vrátane pripomenutia výročia!
Tento program tiež obsahuje adresár a mnoho ďalšieho na objavovanie!

Ak sa chcete dozvedieť viac a nakonfigurovať tento program, prečítajte si prosím celú túto dokumentáciu.

Poznámka: V tomto dokumente bola prijatá špecifická terminológia pre užívateľov, ktorí používajú IT pomôcky pre nevidiacich.

# Užívateľská príručka

* Autor: [Adriano Barbieri] (mailto: adrianobarb@yahoo.it)
* Posledná úprava: Júl 2025

## Obsah

* [1.\ Úvod](#toc1)
* [2.\ Nastavenie programu](#toc2)
* [3.\ Ponuky](#toc3)
* [4.\ Ďalšie informácie pre hlavné okno pre možnosť "Pripomenutie pre vybraný deň:"](#toc4)
* [5.\ Ako funguje adresár?](#toc5)
* [6.\ Ako otvoriť program zo systémovej lišty?](#toc6)


---


# 1.\ Úvod <a name="toc1"></a>
Tento program, ktorý je kombináciou mnou vyvinutej agendy a adresára, som nazval ReminderApp (interný názov), ale v skutočnosti sa okno programu av systéme stavového riadku zobrazujú s názvom "Reminder".

Program ReminderApp je prenosný a je možné ho nakonfigurovať tak, aby sa minimalizoval a spúšťal automaticky pri spustení systému Windows.

Tento program je veľmi intuitívne a nevyžaduje veľa vysvetľovania, ale dám vám niekoľko pokynov, ktorými sa riadiť.

# 2.\ Nastavenie programu <a name="toc2"></a>
Ak ste získali súbor ReminderApp.zip, extrahujte ho napríklad v ceste:
`C:\Program Files\ReminderApp`

Môžete ho tiež extrahovať do koreňového adresára disku `C:\`, príklad:

`C:\ReminderApp`

alebo ho môžete umiestniť kamkoľvek chcete.

Po rozbalení tento súbor obsahuje nasledujúce prvky:

* Priečinok "Doc", ktorý obsahuje súbory programovej príručky pre aktuálne používaný jazyk (je k dispozícii).
* Priečinok "locale", ktorý obsahuje súbory prekladu jazykového rozhrania dostupného pre program.
* Priečinok "Sounds", ktorý obsahuje zvukové súbory budíka, môžete ich pridať priamo do tohto priečinka, ak sú vo formáte "wav" a ich trvanie je kratšie ako 2 sekundy, ReminderApp automaticky načíta názvy a zoradí ich vloženie do možnosti nastavenia „Nastaviť upozornenie“, čo znamená, že ak pridáte budíky,počet nastavených budíkov sa môže zmeniť a budete ho musieť resetovať v podponuke Nastavenie Alt+s a potom v dialógovom okne „Nastaviť upozornenie“ pod otváracím zoznamom s názvom: Použiť budík: nasledovaný názvom alarmu.    
Vnútri Priečinka"Sounds" je tiež Priečinok"Samples", tieto zvuky program používa.    
* Súbor "ReminderApp.exe" (spustiteľný súbor na spustenie programu kedykoľvek).    
* Súbor ReminderApp.ico (formát súboru ICO je spravovaný operačným systémom Microsoft Windows, tento formát je tiež široko používaný pre favicony. Táto ikona je viditeľná na hlavnom paneli, akonáhle je program minimalizovaný a je odstránený, keď je program uzavretá aplikácia).    

# Varovanie

Súbor ReminderApp.zip bude po rozbalení obsahovať svoj spustiteľný súbor s názvom ReminderApp.exe, ktorý bude pri prvom spustení vyhlásený vašim antivírusom za falošne pozitívny!    

To sa deje napríklad s antivírusom Windows Defender.    

Ako povolím program Windows Defender Antivirus spúšťať program?    

Ak chcete, aby program stále bežal s programom Windows Defender, musíte kliknúť na „Ďalšie informácie“. Potom sa zobrazí tlačidlo „Napriek tomu spustiť“, stačí naň kliknúť a spustiť program vo Windows.    

To je potrebné vykonať zakaždým, keď je do priečinka ReminderApp nainštalovaný nový spustiteľný súbor ReminderApp.exe.    

# 3.\ Ponuky <a name="toc3"></a>
V hlavnom okne programu pri štarte nájdeme nasledujúcich päť ponúk so súvisiacimi príkazmi.    

# Ponuka Súbor Podponuka Alt+f

V tomto prvom menu budeme mať nasledujúce možnosti:    
# Kontakty podmenu:
* Export kontaktov z adresára... Ctrl+Shift+E    
Stlačte Enter, objaví sa dialógové okno s názvom:    
"Exportovať kontakty".    
V poli úprav vyberte umiestnenie a názov exportu zoznamu:    
`Názov súboru`    
Potom v type dokumentu uveďte txt alebo json.    
`Typ : Textové súbory (*.txt)`    
Šípka dole k nájdeniu:    
„Súbory JSON (*.json)“.    
Nakoniec svoj súbor uložte stlačením tlačidla:    
'Uložiť'    
Ak všetko prebehlo v poriadku, zobrazí sa nasledujúca správa:    
'Poznámka! Kontakty boli úspešne exportované!`    
* Import kontaktov do adresára... Ctrl+Shift+I    
Stlačte Enter, objaví sa dialógové okno s názvom:    
`Vyberte súbor k importu`    
`Názov súboru`    
Potom v type dokumentu uveďte txt alebo json.    
`Typy súborov: Súbory JSON (*.json)`    
Šípka dole k nájdeniu:    
Typy súborov: Textové súbory (*.txt)    
Vyberte predtým exportovaný súbor txt alebo json a potom ho otvorte stlačením tlačidla:    
'Otvoriť'    
Ak všetko prebehlo v poriadku, zobrazí sa nasledujúca správa:    
'Poznámka! Import úspešne dokončený!    
Stlačte tlačidlo "OK", objaví sa nové dialógové okno s názvom:    
"Vyberte, ako pokračovať".    
`Výberom Áno budú kontakty prepísané.`    
`Ak zvolíte Nie, budú pridané iba k existujúcim.`    
Stlačte tlačidlo Áno alebo Nie v závislosti na vašej voľbe. PRE VAŠU INFORMÁCIU    
`Súbory JSON sú v prípade tohto programu štruktúrované ako zoznam dát, napríklad: ["...", "...", "..."] a je pre program pohodlnejší pre správu, zatiaľ čo textové súbory sú štruktúrované pomocou novej značky riadku, napríklad:    
riadok    
riadok    
riadok, atď., ktoré sú pre človeka čitateľnejšie`.    
# Nastavenie podmenu:
* Exportovať konfiguračnú zložku... Ctrl+E    
Stlačte Enter, zobrazí sa dialógové okno s názvom:    
`Vyberte cieľovú zložku`    
Vyberte umiestnenie pre export zložky ReminderApp_config v editačnom poli:    
Šípka nadol na nájdenie:    
Vybrať zložku    
Ak všetko prebehlo správne, zobrazí sa nasledujúca správa:    
`Upozornenie! Konfigurácia bola úspešne exportovaná!`    
* Importovať konfiguračnú zložku... Ctrl+I    
Stlačte Enter, zobrazí sa dialógové okno s názvom:    
`Vyberte zdrojovú zložku`    
Vyberte umiestnenie zložky ReminderApp_config v editačnom poli:    
Šípka nadol na nájdenie:    
Vybrať zložku    
Ak všetko prebehlo správne, zobrazí sa nasledujúca správa:    
`Upozornenie! Konfigurácia bola úspešne importovaná!`    
* Ukončite Alt+f4    
Táto možnosť zavrie program až do ďalšieho reštartu prostredníctvom spustiteľného súboru (ReminderApp.exe), ak ste ho nenakonfigurovali pri spustení systému Windows.    

# Ponuka Úpravy Podponuka Alt+ e

V tomto druhom menu budeme mať nasledujúce možnosti:

* Vytvoriť zoznam pripomienok s dátumom vypršania... Ctrl+L    
Táto funkcia umožňuje vytvoriť zoznam pripomienok, z ktorých každá je spojená s udalosťou typu Stretnutie alebo Lieky.    
Pre každú položku je možné nastaviť konkrétny dátum upozornenia.    
Celý zoznam možno nakonfigurovať tak, aby sa opakoval až do konečného dátumu, pričom opakovanie sa vzťahuje na všetky zahrnuté pripomienky.    
Po dokončení stlačte „Uložiť“ pre potvrdenie alebo „Zrušiť“ pre ukončenie bez zmien.    
Pomocou kontextovej ponuky zoznamu (pôvodne prázdneho) je možné spravovať jednotlivé položky: pridávať ich, upravovať alebo mazať.    
* Pridať pripomenutie... Ctrl+N    
* Upraviť pripomienku... F2    
* Presunúť pripomienku... Ctrl+F2    
* Zmazať pripomenutie... Del    
* Ďalšie pripomienky (podponuka) s 3 položkami:    
* Pridať... Ctrl+Shift+1    
* Upraviť Ctrl+Shift+2    
* Zmazať Ctrl+Shift+3    
Ak na pripomenutie pridáte poznámku, uloží sa do priečinka ReminderApp_config /ReminderApp_notes.    
Poznámky majú v názve súboru jedinečné číslo, napr. "Notes_xxxx.txt", program ich teda dokáže nájsť a spravovať.    
Poznámka: V dialógovom okne, keď pridávate výročie alebo narodeniny, môžete tiež vybrať melódiu a prehrať/zastaviť ju pomocou rozbaľovacieho poľa a tlačidla.    
Melódie sú uložené v priečinku Zvuky, Vzorky, Melódie a sú vo formáte .wav.    
Môžete pridať ďalšie, pokiaľ majú rovnaký formát a krátke trvanie.    
Ak je v ten istý deň viacero výročí/narodenín, tieto budú zoskupené do jedného oznámenia, preto sa použije prvá melódia v zozname.

Pokračovat v ponuke Úpravy:    
* Zmazať minulé udalosti... Ctrl+Shift+A    
* Odstráňte minulé lieky... Ctrl+Shift+M    
* Adresár... F4    
Otvorí sa dialógové okno pre práve popísané možnosti, postupujte podľa pokynov na obrazovke.    
* Nastaviť na aktuálny dátum Ctrl+Shift+H    
Vynuluje volič dátumu na aktuálny dátum.    
* Zastaviť aktuálne oznámenie Ctrl+Shift+F1    

# Zobrazenie ponuky Podponuka Alt+ v

V tejto tretej ponuke budeme mať nasledujúce možnosti:    

* Pozri narodeniny F5    
* Pozri udalosti F6    
* Pozri opakujúce sa udalosti Shift+F6    
* Pozri opakovanie pripomenutie Ctrl+F6    
* Pozri výročie F7    
* Pozri lieky F8    
* Pozri opakujúce sa lieky Shift+F8    
* Zobrazte v zoznamoch prvý stĺpec „Dátum“ s výnimkou upomienok a liekov.
Stlačením klávesu Enter na požadované možnosti ju zobrazíte v zozname.    
Stlačením klávesu aplikácií alebo Shift+f10 zobrazíte dostupné možnosti.    
Stlačte Tab a potom kliknite na tlačidlo Zavrieť alebo stlačte kláves Escape alebo Enter pre zatvorenie tohto dialógového okna a návrat do hlavného okna programu.    
Poznámka:    
Keď vytvoríte/upravíte pripomienku, všimnete si tiež 2 opakujúce sa typy: (Opakujúca sa udalosť a Opakujúci sa liek)    
Tieto dva typy pripomenutí je možné nastaviť s opakovaním: (Denne, Týždenne, Ročne), v závislosti na týždni pre Týždenne bude aktivovaná voľba dňa a voľba mesiaca pre Ročné.    
Môžete si nastaviť od 5 do 60 minút, budete včas upozornení a budete mať možnosť, ja neviem, zmeniť sa, pripraviť sa a po vypršaní varovania sa spustí skutočný alarm.    
Opakované pripomenutia sú múdre, po vypršaní platnosti sa presunú na ďalší ekvivalentný dátum. Napríklad opakujúcu sa dennú upomienku, vždy ju nájdete aj ďalší deň a podobne.    
Neposkytoval som možnosť zmazať opakujúce sa pripomenutie (zo zrejmých dôvodov), ale môžete si ich pozrieť prostredníctvom ponuky „Zobraziť“.    
Ak chcete jeden odstrániť, aktivujte v zoznamoch prvý stĺpec "Dátum" s výnimkou schôdzok a liekov. Ďalej vyberte typ opakovanej upomienky, ktorú chcete odstrániť, z ponuky "Zobraziť" a poznamenajte si jej dátum zadania,ktoré je viditeľné v prvom stĺpci vľavo.    
Nakoniec nastavte tento dátum v hlavnom voliči, aby ste ho videli a pokračujte v mazaní.    
Pokračujte v ponuke Zobraziť:    
* Zobraziť prvý stĺpec "Dátum" v zobrazených zoznamoch (okrem schôdzok a liekov) (v predvolenom nastavení nezaškrtnuté)    
Zobrazenie týchto dát je užitočné pre jednoduché vyhľadanie pripomenutia k ich zmene alebo odstráneniu nastavením dátumu z hlavného voliča.    

# Ponuka Nastavenie Podponuka Alt+ s

V tejto štvrtej ponuke budeme mať nasledujúce možnosti:    

* Nastavenie upozornenia Ctrl+Shift+N    
Stlačte enter, objaví sa dialógové okno, pohybom pomocou "Tab" a "Shift+Tab" sa pohybujte medzi ovládacími prvkami, šípkami hore a dole zmeňte hodnotu parametra.    
"Počet opakovaní: 3".    
`Interval medzi opakovaniami (sekundy): 8`    
`Použiť budík: Alarm 01`    
`Umožňuje čítanie hodín v 24-hodinovom formáte`    
Toto je zaškrtávacie políčko pre výber, či chcete nastaviť formát na 24 hodín alebo 12 hodín, východiskové nastavenie je 24 hodín.    
Stlačením medzerníka nastavíte 12-hodinový formát.    
`Povoliť čítanie dáta v európskom formáte`    
Toto je zaškrtávacie políčko pre nastavenie formátu dátumu na americký alebo európsky, východiskové je európsky.    
Stlačením medzerníka nastavte americký formát.    
Tento dialóg tiež obsahuje tieto zaškrtávacie políčka:    
* Minimalizovať program pri spustení (v predvolenom nastavení nezaškrtnuté)    
Pokiaľ zvolíte minimalizáciu programu pri štarte, program sa skryje na paneli úloh, aby vás neobťažoval, mali by ste vidieť jeho ikonu, určite v skrytých ikonách budete môcť pracovať s kontextovou ponukou, kedykoľvek budete chcieť. ale program bude aj naďalej sledovať všetky pripomenutia dňa.    
Ak chcete, aby bola ikona vždy vidieť na paneli úloh, môžete tak urobiť, akonáhle je skrytá, nastavením z nastavení Windows, prispôsobenie, panela úloh, zobrazenie všetkých aplikácií a aktiváciou ReminderApp.    
* Automatické spustenie pri spustení Windows (v predvolenom nastavení nezaškrtnuté)    
Výberom tejto možnosti umožníte automatickému spusteniu programu pri spustení systému Windows.    
* Zobraziť náhľad pripomenutie pri spustení, ak je program minimalizovaný (v predvolenom nastavení začiarknuté)    
Keď sa program pri spustení minimalizuje na systémovú lištu, otvorí náhľad pripomenutie dňa.    
* Check for updates (selected by default)    
If this option is enabled, check for program updates at startup.    
Po dokončení konfigurácie potvrďte zmeny stlačením klávesu Enter alebo tlačidla "OK". Pre zrušenie zmien stlačte Escape alebo tlačidlo "Storno".    
Pokračujte v ponuke Nastavenie:    
* Nastavte kombináciu klávesov Ctrl+Shift+K    
Kombinácie klávesových skratiek, ktoré zabraňujú aktuálnemu upozorneniu v spustení alarmu a zobrazujú pripomenutie (aj keď nie je v popredí), sú navrhnuté tak, aby fungovali mimo grafického používateľského rozhrania ReminderApp.    
To znamená, že v prípade konfliktov s inými aplikáciami si ich budete môcť individuálne prispôsobiť.    
Ak vytvoríte kombináciu, ktorá sa už v programe používa, budete upozornení chybovým zvukom a nebude prijatá.Pokiaľ je vaša nová kombinácia platná, objaví sa v záhlaví, potom môžete kliknúť na tlačidlo „Použiť túto kombináciu“ a bude sa používať, kým sa nerozhodnete ju znovu zmeniť.    
* Nastavení jazyka Ctrl+Shift+L    
Keď na tejto položke stlačíte Enter, otvorí sa dialógové okno s niektorými jazykmi, ktoré bude povolené, ak je preklad dostupný v lokálnom priečinku).    
Jazyk rozhrania si môžete vybrať výberom z aktuálne dostupných jazykov zobrazených v tomto dialógovom okne.    
Zobrazí sa dialógové okno, ktoré vás informuje, že jazyk bol zmenený a že je potrebné reštartovať program, aby sa tieto zmeny prejavili.
# Ponuka Pomocník Podponuka Alt+h

V tejto piatej a poslednej ponuke budeme mať nasledujúce možnosti:    

* Informácie o programe... F1    
Keď na tejto položke stlačíte Enter, otvorí sa dialógové okno, kde sa zobrazia informácie o programe v editačnom dokumente iba na čítanie vo vašom príslušnom jazyku, ak je k dispozícii.    
Na opätovné prečítanie týchto informácií použite klávesy NVDA+b alebo Insert+b čítačky obrazovky v dokumentácii.    
Až budete hotoví, stlačte Tab a potom kliknite na tlačidlo OK alebo stlačte klávesu Enter alebo Escape pre zatvorenie tohto dialógového okna a návrat do hlavného okna programu.    
* Užívateľská príručka... Shift+F1    
Keď na tejto položke stlačíte kláves Enter, otvorí sa okno zobrazujúce pomocníka programu v editačnom html dokumente iba na čítanie v predvolenom prehliadači vo vašom príslušnom jazyku, ak je k dispozícii, inak sa zobrazí varovná správa.    
Stlačením Alt+F4 ho zatvoríte.    
* Klávesové skratky... F9    
Keď na tejto položke stlačíte Enter, otvorí sa dialógové okno, v ktorom sa zobrazia klávesové skratky programu v editačnom zozname iba na čítanie, pre pohyb v zozname použite klávesy so šípkami.    
Stlačte Tab a potom kliknite na tlačidlo Zavrieť alebo stlačte kláves Escape alebo Enter pre zatvorenie tohto dialógového okna a návrat do hlavného okna programu.    
* Check for updatesCtrl+Shift+U    
When you press Enter on this item, you will be notified if there are updates for the program, if so, follow the instructions on the screen.

# 4.\ Ďalšie informácie pre hlavné okno pre možnosť "Pripomenutie pre vybraný deň:" <a name="toc4"></a>
Keď zmeníte dátum vo voliči hlavného okna a vybraný dátum zodpovedá pripomenutiu, zaznie zvuk sonaru.    
Fokus sa však môže presunúť na zoznam, ak bolo predtým vybrané pripomenutie.    
Ak sa chcete tejto nepríjemnosti vyhnúť, môžete pred pokračovaním zrušiť výber pripomenutia alebo zadať dátum priamo nasledujúci po dni, mesiaci, roku alebo mesiaci, dni, roku v závislosti od nastavenia jazyka systému (a nie od nastavenia programu).    
Vo voliči sa môžete pohybovať pomocou vodorovných šípok.    
Pre používateľov odčítačov obrazovky, ako je NVDA, je dôležité poznamenať, že NVDA nezobrazuje aktuálnu pozíciu vo voliči. Odporúčame stlačiť zvislú šípku: NVDA oznámi vami nastavený dátum a poskytne aktualizácie, akonáhle zadáte celý deň, mesiac alebo rok.    
Zvuková signalizácia rieši problém s nastavením počiatočného dátumu, namiesto presunutia fokusu na zoznam pripomenutí, keď v danom dátume nejaké je, budete počuť zvuk, ktorý vás upozorní a môžete sa bez problému hrať so svojím dátumom:)    

# 5.\ Ako funguje adresár? <a name="toc5"></a>
Prístup k:    
`Edit Menu Submenu Alt+ e`    
potom:    
`Adresár... F4`    
Keď pri tejto možnosti stlačíte Enter, otvorí sa dialógové okno s názvom:    
"Adresár".    
Toto dialógové okno bude obsahovať zoznam vašich kontaktov, ak ste nejaký pridali, inak je tento zoznam prázdny.    
Keď v tomto dialógovom okne otvoríte miestnu ponuku stlačením klávesu aplikácií umiestneného vedľa pravého ovládacieho klávesu na väčšine klávesníc. Na klávesnici bez aplikačného klávesu stlačte Shift+f10.    
Upozorňujeme, že niektoré možnosti nie sú v zozname kontaktov dostupné v závislosti od kontextu. Môžete stlačiť Enter na požadované možnosti, takže tu sú možnosti:    

* Pridať kontakt... Ctrl+N    
* Upraviť kontakt... F2    
* Zmazať kontakt... Del    
* Nájsť kontakt... Ctrl+F3    
Otvorí sa dialógové okno pre práve popísané možnosti ponuky, postupujte podľa pokynov na obrazovke.    
* Nájsť ďalšie F3    
* Nájsť predchádzajúce Shift+F3    
Obe tieto možnosti sú založené na mene kontaktu, ktoré ste zadali v dialógovom okne "Nájsť kontakt", takže vyhľadávanie sa vykonáva s ďalšou alebo predchádzajúcou zhodou rovnakého mena nájdeného v zozname adresára.    
* Odoslať email kontaktu... Ctrl+E    
Otvorí sa dialógové okno pre túto možnosť, postupujte podľa pokynov na obrazovke.    

Vezmite prosím na vedomie, že môžete kontaktu poslať e-mail, ak bol e-mail kontaktu zadaný do editačného poľa oddeleného medzerou na začiatku (av prípade potreby na konci), napríklad pri úprave mena kontaktu. V opačnom prípade, ak v tomto editačnom poli nie je žiadny e-mail, táto možnosť nebude k dispozícii na jeho odoslanie.    

Ak ste nenastavili predvolený e-mailový program, systém automaticky zobrazí dialógové okno, ktoré vám umožní vybrať aplikáciu, ktorú chcete použiť na odoslanie e-mailu.    

# 6.\ Ako otvoriť program zo systémovej lišty? <a name="toc6"></a>

* Otvorte systémovú lištu stlačením Windows+b, šípkou nadol prejdite na ikonu „Pripomenutie“ a otvorte kontextovú ponuku stlačením klávesu aplikácií umiestnenej vedľa pravého ovládacieho klávesu na väčšine klávesníc. Na klávesnici bez aplikačného klávesu stlačte Shift+f10.    
* Kliknite pravým tlačidlom myši na ikonu "Pripomenutie" umiestnenú na hlavnom paneli systému Windows.    

Keď sa objaví kontextová ponuka, môžete v ponuke prechádzať klávesmi so šípkami a klávesom Enter aktivovať ktorúkoľvek z nižšie uvedených položiek.    

* Ukáž Pripomienky    
Stlačením klávesu Enter na tejto možnosti zobrazíte program.    
* Zastaviť aktuálne oznámenie    
Stlačenie klávesu Enter na tejto možnosti Aktuálne oznámenie bude zastavené.    
* Adresár...    
Stlačením klávesu Enter na tejto možnosti sa otvorí dialógové okno "Adresár".    
* Ukončite aplikáciu Pripomenutie    
Stlačením klávesu Enter na tejto možnosti ukončíte program.    

---

Ďakujeme, že ste si prečítali túto dokumentáciu! Želám vám dobré používanie programu ReminderApp (Reminder) 😉    
Rád by som úprimne poďakoval [Pavel Partyka] (mailto:ppartyka@email.cz) preložil túto dokumentáciu a aplikáciu ReminderApp do slovenčiny.    
Rád by som úprimne poďakoval [Rémymu Ruizovi] (mailto:remyruiz@gmail.com) za napísanie tejto dokumentácie a preklad aplikácie ReminderApp do francúzštiny, angličtiny, taliančiny a španielčiny a za jeho spätnú väzbu a návrhy.