@echo off
:: ReminderApp Updater Copyright (c) 2024 and beyond by Adriano Barbieri.
:: E-mail: adrianobarb@yahoo.it
:: This program is Free program under the Creative Commons License CC BY 4.0
:: https://creativecommons.org/licenses/by-nc/4.0/

setlocal

:: Set folder and program paths
set "updateFolder=%temp%\update\ReminderApp"
set "appPath=%cd%\ReminderApp.exe"

:: Check if the folder exists and is not empty
echo Check for updates...
if exist "%updateFolder%" (
    for /f %%i in ('dir /b "%updateFolder%"') do (
        set "folderNotEmpty=1"
    )
    
    if defined folderNotEmpty (
        
        :: Terminate the program if it is running.
        tasklist /FI "IMAGENAME eq ReminderApp.exe" | find /I "ReminderApp.exe" >nul
        if not errorlevel 1 (
            echo Closing the ReminderApp.exe...
            taskkill /IM "ReminderApp.exe" /F
            timeout /t 2 /nobreak >nul
        )
        
        :: Copy the contents of the update folder
        echo Copying the files from the update...
        xcopy "%updateFolder%\*" "%cd%\" /E /Y /I
        
        :: Start ReminderApp.exe
        echo Launching ReminderApp.exe...
        start "" "%appPath%"
        
        :: Delete the update folder and its contents
        echo Deleting the update folder and ReminderApp archive.zip...
        rmdir /S /Q "%temp%\update"
        del "%temp%\ReminderApp-*.zip" > NUL 2>&1
    ) else (
        echo The update folder exists but is empty.
    )
) else (
    echo The update folder does not exist.
)

endlocal