/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.lang.BaseWrapper;
import php.runtime.lang.ForeachIterator;
import php.runtime.memory.ArrayMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\UXFileChooser")
public class UXFileChooser
extends BaseWrapper<FileChooser> {
    public UXFileChooser(Environment env, FileChooser wrappedObject) {
        super(env, (Object)wrappedObject);
    }

    public UXFileChooser(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public void __construct() {
        this.__wrappedObject = new FileChooser();
    }

    @Reflection.Getter
    public File getInitialDirectory() {
        return ((FileChooser)this.getWrappedObject()).getInitialDirectory();
    }

    @Reflection.Setter
    public void setInitialDirectory(Memory value) {
        if (value.isNull()) {
            ((FileChooser)this.getWrappedObject()).setInitialDirectory(null);
        } else {
            ((FileChooser)this.getWrappedObject()).setInitialDirectory(new File(value.toString()));
        }
    }

    @Reflection.Getter
    public int getSelectedExtensionFilter() {
        FileChooser.ExtensionFilter filter = ((FileChooser)this.getWrappedObject()).getSelectedExtensionFilter();
        if (filter == null) {
            return -1;
        }
        int i = 0;
        for (FileChooser.ExtensionFilter extensionFilter : ((FileChooser)this.getWrappedObject()).getExtensionFilters()) {
            if (extensionFilter == filter) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Reflection.Setter
    public void setSelectedExtensionFilter(int index) {
        ObservableList extensionFilters = ((FileChooser)this.getWrappedObject()).getExtensionFilters();
        if (index < 0 || index > extensionFilters.size() - 1) {
            ((FileChooser)this.getWrappedObject()).setSelectedExtensionFilter(null);
            return;
        }
        ((FileChooser)this.getWrappedObject()).setSelectedExtensionFilter((FileChooser.ExtensionFilter)extensionFilters.get(index));
    }

    @Reflection.Getter
    public ArrayMemory getExtensionFilters() {
        ArrayMemory result = new ArrayMemory();
        for (FileChooser.ExtensionFilter filter : ((FileChooser)this.getWrappedObject()).getExtensionFilters()) {
            result.refOfIndex("description").assign(filter.getDescription());
            result.refOfIndex("extensions").assign((Memory)ArrayMemory.ofStringCollection((Collection)filter.getExtensions()));
        }
        return result.toConstant();
    }

    @Reflection.Setter
    public void setExtensionFilters(ForeachIterator filters) {
        ((FileChooser)this.getWrappedObject()).getExtensionFilters().clear();
        while (filters.next()) {
            Memory value = filters.getValue();
            if (!value.isArray()) {
                throw new IllegalArgumentException();
            }
            Memory extensions = value.valueOfIndex("extensions");
            if (!extensions.isArray()) {
                throw new IllegalArgumentException();
            }
            FileChooser.ExtensionFilter filter = new FileChooser.ExtensionFilter(value.valueOfIndex("description").toString(), Arrays.asList(((ArrayMemory)extensions.toValue(ArrayMemory.class)).toStringArray()));
            ((FileChooser)this.getWrappedObject()).getExtensionFilters().add((Object)filter);
        }
    }

    @Reflection.Signature
    public File execute() {
        return this.showOpenDialog();
    }

    @Reflection.Signature
    public File showOpenDialog(@Reflection.Nullable Window window) {
        File parentFile;
        File file;
        if (((FileChooser)this.getWrappedObject()).getInitialDirectory() != null && !((FileChooser)this.getWrappedObject()).getInitialDirectory().isDirectory()) {
            ((FileChooser)this.getWrappedObject()).setInitialDirectory(null);
        }
        if ((file = ((FileChooser)this.getWrappedObject()).showOpenDialog(window)) != null && (parentFile = file.getParentFile()) != null) {
            ((FileChooser)this.getWrappedObject()).setInitialDirectory(parentFile);
        }
        return file;
    }

    @Reflection.Signature
    public File showSaveDialog(@Reflection.Nullable Window window) {
        File file;
        if (((FileChooser)this.getWrappedObject()).getInitialDirectory() != null && !((FileChooser)this.getWrappedObject()).getInitialDirectory().isDirectory()) {
            ((FileChooser)this.getWrappedObject()).setInitialDirectory(null);
        }
        if ((file = ((FileChooser)this.getWrappedObject()).showSaveDialog(window)) != null) {
            ((FileChooser)this.getWrappedObject()).setInitialDirectory(file.getParentFile());
        }
        return file;
    }

    @Reflection.Signature
    public List<File> showOpenMultipleDialog(@Reflection.Nullable Window window) {
        List files;
        if (((FileChooser)this.getWrappedObject()).getInitialDirectory() != null && !((FileChooser)this.getWrappedObject()).getInitialDirectory().isDirectory()) {
            ((FileChooser)this.getWrappedObject()).setInitialDirectory(null);
        }
        if ((files = ((FileChooser)this.getWrappedObject()).showOpenMultipleDialog(window)) == null) {
            return Collections.emptyList();
        }
        if (!files.isEmpty()) {
            ((FileChooser)this.getWrappedObject()).setInitialDirectory(((File)files.get(0)).getParentFile());
        }
        return files;
    }

    @Reflection.Signature
    public File showOpenDialog() {
        return this.showOpenDialog(null);
    }

    @Reflection.Signature
    public File showSaveDialog() {
        return this.showSaveDialog(null);
    }

    @Reflection.Signature
    public List<File> showOpenMultipleDialog() {
        return this.showOpenMultipleDialog(null);
    }

    static interface WrappedInterface {
        @Reflection.Property
        public String title();

        @Reflection.Property
        public String initialFileName();
    }
}

