/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import java.io.File;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.Event;
import javafx.print.PrinterJob;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebHistory;
import netscape.javascript.JSObject;
import org.develnext.jphp.ext.javafx.support.EventProvider;
import org.develnext.jphp.ext.javafx.support.JavaFxUtils;
import org.w3c.dom.Document;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseWrapper;
import php.runtime.memory.ArrayMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Abstract
@Reflection.Name(value="php\\gui\\UXWebEngine")
public class UXWebEngine
extends BaseWrapper<WebEngine> {
    public UXWebEngine(Environment env, WebEngine wrappedObject) {
        super(env, (Object)wrappedObject);
    }

    public UXWebEngine(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Setter
    public void setUrl(String url) {
        ((WebEngine)this.getWrappedObject()).load(url);
    }

    @Reflection.Getter
    public String getUrl() {
        return ((WebEngine)this.getWrappedObject()).getLocation();
    }

    @Reflection.Signature
    public Memory executeScript(Environment env, String script) {
        return Memory.wrap((Environment)env, (Object)((WebEngine)this.getWrappedObject()).executeScript(script));
    }

    @Reflection.Signature
    public void refresh() {
        ((WebEngine)this.getWrappedObject()).reload();
    }

    @Reflection.Signature
    public boolean cancel() {
        return ((WebEngine)this.getWrappedObject()).getLoadWorker().cancel();
    }

    @Reflection.Signature
    public Memory callFunction(Environment env, String name, ArrayMemory args) {
        JSObject window = (JSObject)((WebEngine)this.getWrappedObject()).executeScript("window");
        if (window == null) {
            throw new IllegalStateException("Unable to find window object");
        }
        return Memory.wrap((Environment)env, (Object)window.call(name, args.toStringArray()));
    }

    @Reflection.Signature
    public void addSimpleBridge(Environment env, String name, Invoker handler) {
        JSObject window = (JSObject)((WebEngine)this.getWrappedObject()).executeScript("window");
        window.setMember(name, new Bridge(handler));
    }

    @Reflection.Signature
    public ObservableValue observer(String property) {
        return JavaFxUtils.findObservable((Object)this, property);
    }

    @Reflection.Getter
    public Worker.State getState() {
        return ((WebEngine)this.getWrappedObject()).getLoadWorker().getState();
    }

    @Reflection.Signature
    public void watchState(final Environment env, final Invoker invoker) {
        ((WebEngine)this.getWrappedObject()).getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observable, final Worker.State oldValue, final Worker.State newValue) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            invoker.callAny(new Object[]{UXWebEngine.this, oldValue, newValue});
                        }
                        catch (Throwable e) {
                            env.wrapThrow(e);
                        }
                    }
                });
            }
        });
    }

    @Reflection.Signature
    public void on(String event, Invoker invoker, String group) {
        Object target = this.getWrappedObject();
        EventProvider eventProvider = EventProvider.get(target, event);
        if (eventProvider == null) {
            throw new IllegalArgumentException("Unable to find the '" + event + "' event type");
        }
        eventProvider.on(target, event, group, invoker);
    }

    @Reflection.Signature
    public void on(String event, Invoker invoker) {
        this.on(event, invoker, "general");
    }

    @Reflection.Signature
    public void off(String event, @Reflection.Nullable String group) {
        Object target = this.getWrappedObject();
        EventProvider eventProvider = EventProvider.get(target, event);
        if (eventProvider == null) {
            throw new IllegalArgumentException("Unable to find the '" + event + "' event type");
        }
        eventProvider.off(target, event, group);
    }

    @Reflection.Signature
    public void off(String event) {
        this.off(event, null);
    }

    @Reflection.Signature
    public void trigger(String event, @Reflection.Nullable Event e) {
        Object target = this.getWrappedObject();
        EventProvider eventProvider = EventProvider.get(target, event);
        if (eventProvider == null) {
            throw new IllegalArgumentException("Unable to find the '" + event + "' event type");
        }
        eventProvider.trigger(target, event, e);
    }

    @Reflection.Signature
    public void print(PrinterJob printerJob) {
        ((WebEngine)this.getWrappedObject()).print(printerJob);
    }

    public static class Bridge {
        protected final Invoker handler;

        public Bridge(Invoker handler) {
            this.handler = handler;
        }

        public String run(String arg1) {
            return this.handler.callAny(new Object[]{arg1}).toString();
        }
    }

    static interface WrappedInterface {
        @Reflection.Property
        public Document document();

        @Reflection.Property
        public WebHistory history();

        @Reflection.Property
        public boolean javaScriptEnabled();

        @Reflection.Property
        public String location();

        @Reflection.Property
        public String title();

        @Reflection.Property
        public String userAgent();

        @Reflection.Property
        public String userStyleSheetLocation();

        @Reflection.Property
        public File userDataDirectory();

        public void load(String var1);

        public void loadContent(String var1);

        public void loadContent(String var1, String var2);

        public void reload();
    }
}

