/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes.layout;

import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import org.develnext.jphp.ext.javafx.classes.UXControl;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\layout\\UXScrollPane")
public class UXScrollPane<T extends ScrollPane>
extends UXControl<ScrollPane> {
    public UXScrollPane(Environment env, T wrappedObject) {
        super(env, wrappedObject);
    }

    public UXScrollPane(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Override
    @Reflection.Signature
    public void __construct() {
        this.__wrappedObject = new ScrollPane();
    }

    @Reflection.Signature
    public void __construct(@Reflection.Nullable Node content) {
        this.__wrappedObject = new ScrollPane(content);
    }

    @Override
    public T getWrappedObject() {
        return (T)((ScrollPane)super.getWrappedObject());
    }

    @Reflection.Getter
    public double getScrollX() {
        return this.getWrappedObject().getHvalue();
    }

    @Reflection.Setter
    public void setScrollX(double value) {
        this.getWrappedObject().setHvalue(value);
    }

    @Reflection.Getter
    public double getScrollY() {
        return this.getWrappedObject().getVvalue();
    }

    @Reflection.Setter
    public void setScrollY(double value) {
        this.getWrappedObject().setVvalue(value);
    }

    @Reflection.Signature
    public void scrollToNode(Node node) {
        T scrollPane = this.getWrappedObject();
        double h = scrollPane.getContent().getBoundsInLocal().getHeight();
        double w = scrollPane.getContent().getBoundsInLocal().getWidth();
        double y = (node.getBoundsInParent().getMaxY() + node.getBoundsInParent().getMinY()) / 2.0;
        double x = (node.getBoundsInParent().getMaxX() + node.getBoundsInParent().getMinX()) / 2.0;
        double viewHeight = scrollPane.getViewportBounds().getHeight();
        double viewWidth = scrollPane.getViewportBounds().getWidth();
        scrollPane.setVvalue(scrollPane.getVmax() * ((y - 0.5 * viewHeight) / (h - viewHeight)));
        scrollPane.setHvalue(scrollPane.getVmax() * ((x - 0.5 * viewWidth) / (w - viewWidth)));
    }

    static interface WrappedInterface {
        @Reflection.Property
        public Node content();

        @Reflection.Property
        public Bounds viewportBounds();

        @Reflection.Property
        public boolean fitToWidth();

        @Reflection.Property
        public boolean fitToHeight();

        @Reflection.Property
        public ScrollPane.ScrollBarPolicy vbarPolicy();

        @Reflection.Property
        public ScrollPane.ScrollBarPolicy hbarPolicy();

        @Reflection.Property(value="scrollMaxX")
        public double hmax();

        @Reflection.Property(value="scrollMaxY")
        public double vmax();

        @Reflection.Property(value="scrollMinX")
        public double hmin();

        @Reflection.Property(value="scrollMinY")
        public double vmin();
    }
}

