/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes.shape;

import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.scene.shape.Polygon;
import org.develnext.jphp.ext.javafx.classes.UXList;
import org.develnext.jphp.ext.javafx.classes.shape.UXShape;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\shape\\UXPolygon")
public class UXPolygon
extends UXShape<Polygon> {
    protected Double _width = null;
    protected Double _height = null;

    public UXPolygon(Environment env, Polygon wrappedObject) {
        super(env, wrappedObject);
    }

    public UXPolygon(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public void __construct() {
        this.__wrappedObject = new Polygon();
    }

    @Reflection.Signature
    public void __construct(double[] points) {
        this.__wrappedObject = new Polygon(points);
    }

    public static double getWidth(Polygon polygon) {
        double minX = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        Double[] points = (Double[])polygon.getPoints().toArray((Object[])new Double[0]);
        for (int i = 0; i < points.length; i += 2) {
            double x = points[i];
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
        }
        return maxX - minX;
    }

    public static double getHeight(Polygon polygon) {
        double minY = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        Double[] points = (Double[])polygon.getPoints().toArray((Object[])new Double[0]);
        for (int i = 0; i < points.length; i += 2) {
            double y = points[i + 1];
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        return maxY - minY;
    }

    public static void setWidth(Polygon polygon, double newWidth) {
        double width = UXPolygon.getWidth(polygon);
        double offset = newWidth - width;
        int i = 0;
        ObservableList _points = polygon.getPoints();
        ArrayList<Double> points = new ArrayList<Double>(_points.size());
        for (Double point : _points) {
            if (i % 2 == 0 && Double.compare(point, 0.0) != 0) {
                if (point < 0.0) {
                    points.add(point - offset / 2.0);
                } else {
                    points.add(point + offset / 2.0);
                }
            } else {
                points.add(point);
            }
            ++i;
        }
        polygon.getPoints().setAll(points);
    }

    public static void setHeight(Polygon polygon, double newHeight) {
        double height = UXPolygon.getHeight(polygon);
        double offset = newHeight - height;
        int i = 0;
        ObservableList _points = polygon.getPoints();
        ArrayList<Double> points = new ArrayList<Double>(_points.size());
        for (Double point : _points) {
            if (i % 2 != 0 && Double.compare(point, 0.0) != 0) {
                if (point < 0.0) {
                    points.add(point - offset / 2.0);
                } else {
                    points.add(point + offset / 2.0);
                }
            } else {
                points.add(point);
            }
            ++i;
        }
        polygon.getPoints().setAll(points);
    }

    @Override
    @Reflection.Signature
    protected void setWidth(double newWidth) {
        UXPolygon.setWidth((Polygon)this.getWrappedObject(), newWidth);
    }

    @Override
    @Reflection.Signature
    protected void setHeight(double newHeight) {
        UXPolygon.setHeight((Polygon)this.getWrappedObject(), newHeight);
    }

    @Override
    @Reflection.Signature
    protected double getWidth() {
        if (this._width != null) {
            return this._width;
        }
        this._width = UXPolygon.getWidth((Polygon)this.getWrappedObject());
        return this._width;
    }

    @Override
    @Reflection.Signature
    protected double getHeight() {
        if (this._height != null) {
            return this._height;
        }
        this._height = UXPolygon.getHeight((Polygon)this.getWrappedObject());
        return this._height;
    }

    @Override
    public void setX(double v) {
        super.setX(v + this.getWidth() / 2.0);
    }

    @Override
    public void setY(double v) {
        super.setY(v + this.getHeight() / 2.0);
    }

    @Override
    public double getX() {
        return super.getX() - this.getWidth() / 2.0;
    }

    @Override
    public double getY() {
        return super.getY() - this.getHeight() / 2.0;
    }

    @Override
    protected void setSize(double[] size) {
        if (size.length > 1) {
            this.setWidth(size[0]);
            this.setHeight(size[1]);
        }
    }

    static interface WrappedInterface {
        @Reflection.Property
        public UXList points();
    }
}

