/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.control;

import javafx.geometry.Pos;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;

public class NumberSpinner
extends Spinner<Integer> {
    private int min = Integer.MIN_VALUE;
    private int max = Integer.MAX_VALUE;
    private int step = 1;
    private int initial = 0;
    private ArrowsStyle arrowsStyle = ArrowsStyle.RIGHT_VERTICAL;

    public NumberSpinner() {
        this.setMinSize(0.0, 0.0);
        this.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(this.min, this.max, this.initial, this.step));
    }

    public void setAlignment(Pos value) {
        this.getEditor().setAlignment(value);
    }

    public Pos getAlignment() {
        return this.getEditor().getAlignment();
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
        this.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(min, this.max, this.initial, this.step));
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
        this.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(this.min, max, this.initial, this.step));
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int step) {
        this.step = step;
        this.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(this.min, this.max, this.initial, step));
    }

    public int getInitial() {
        return this.initial;
    }

    public void setInitial(int initial) {
        this.initial = initial;
        this.setValueFactory((SpinnerValueFactory)new SpinnerValueFactory.IntegerSpinnerValueFactory(this.min, this.max, initial, this.step));
    }

    public ArrowsStyle getArrowsStyle() {
        return this.arrowsStyle;
    }

    public void setArrowsStyle(ArrowsStyle arrowsStyle) {
        this.arrowsStyle = arrowsStyle;
        for (ArrowsStyle style : ArrowsStyle.values()) {
            this.getStyleClass().remove((Object)style.getStyleClass());
        }
        if (arrowsStyle != null) {
            this.getStyleClass().add((Object)arrowsStyle.getStyleClass());
        }
    }

    public static enum ArrowsStyle {
        RIGHT_VERTICAL(""),
        RIGHT_HORIZONTAL("arrows-on-right-horizontal"),
        LEFT_VERTICAL("arrows-on-left-vertical"),
        LEFT_HORIZONTAL("arrows-on-left-horizontal"),
        SPLIT_VERTICAL("split-arrows-vertical"),
        SPLIT_HORIZONTAL("split-arrows-horizontal");

        private final String style;

        private ArrowsStyle(String style) {
            this.style = style;
        }

        public String getStyleClass() {
            return this.style;
        }
    }
}

