/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.tray.notification;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import org.develnext.jphp.ext.javafx.support.tray.animations.AnimationType;
import org.develnext.jphp.ext.javafx.support.tray.animations.FadeAnimation;
import org.develnext.jphp.ext.javafx.support.tray.animations.PopupAnimation;
import org.develnext.jphp.ext.javafx.support.tray.animations.SlideAnimation;
import org.develnext.jphp.ext.javafx.support.tray.animations.TrayAnimation;
import org.develnext.jphp.ext.javafx.support.tray.models.CustomStage;
import org.develnext.jphp.ext.javafx.support.tray.notification.NotificationLocation;
import org.develnext.jphp.ext.javafx.support.tray.notification.NotificationType;

public final class TrayNotification {
    @FXML
    private Label lblTitle;
    @FXML
    private Label lblMessage;
    @FXML
    private Label lblClose;
    @FXML
    private ImageView imageIcon;
    @FXML
    private Rectangle rectangleColor;
    @FXML
    private AnchorPane rootNode;
    private static Stage tmpStage;
    private CustomStage stage;
    private NotificationType notificationType;
    private AnimationType animationType;
    private EventHandler<ActionEvent> onDismissedCallBack;
    private EventHandler<ActionEvent> onShownCallback;
    private EventHandler<ActionEvent> onClickCallback;
    private NotificationLocation location;
    private double horGap = 5.0;
    private double verGap = 5.0;
    private int viewIndex = 0;
    private TrayAnimation __animator;
    private static Map<NotificationLocation, AtomicInteger> trayCounts;

    public TrayNotification(String title, String body, Image img, Paint rectangleFill) {
        this.initTrayNotification(title, body, NotificationType.CUSTOM);
        this.setImage(img);
        this.setRectangleFill(rectangleFill);
    }

    public TrayNotification(String title, String body, NotificationType notificationType) {
        this.initTrayNotification(title, body, notificationType);
    }

    public TrayNotification() {
        this.initTrayNotification("", "", NotificationType.CUSTOM);
    }

    private void initTrayNotification(String title, String message, NotificationType type) {
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("/tray/views/TrayNotification.fxml"));
            fxmlLoader.setController((Object)this);
            fxmlLoader.load();
            this.initStage();
            this.initAnimations();
            this.setTray(title, message, type);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initAnimations() {
        this.setAnimationType(AnimationType.POPUP);
    }

    private void initStage() {
        this.stage = new CustomStage(this.rootNode, this.horGap, this.verGap);
        this.rootNode.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
        this.stage.getScene().setRoot((Parent)this.rootNode);
        this.setLocation(NotificationLocation.BOTTOM_RIGHT);
        EventHandler<MouseEvent> value = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (TrayNotification.this.onClickCallback != null) {
                    TrayNotification.this.onClickCallback.handle((Event)new ActionEvent((Object)this, null));
                }
                TrayNotification.this.dismiss();
            }
        };
        this.lblClose.setOnMouseClicked((EventHandler)value);
        this.stage.getScene().setOnMouseClicked((EventHandler)value);
    }

    public NotificationLocation getLocation() {
        return this.location;
    }

    public void setLocation(NotificationLocation location) {
        this.stage.setHorGap(this.horGap);
        this.stage.setVerGap(this.verGap);
        switch (location) {
            case BOTTOM_RIGHT: {
                this.stage.setLocation(this.stage.getBottomRight(this.viewIndex));
                break;
            }
            case BOTTOM_LEFT: {
                this.stage.setLocation(this.stage.getBottomLeft(this.viewIndex));
                break;
            }
            case TOP_LEFT: {
                this.stage.setLocation(this.stage.getTopLeft(this.viewIndex));
                break;
            }
            case TOP_RIGHT: {
                this.stage.setLocation(this.stage.getTopRight(this.viewIndex));
            }
        }
        this.location = location;
    }

    public void setNotificationType(NotificationType nType) {
        this.notificationType = nType;
        URL imageLocation = null;
        String paintHex = null;
        switch (nType) {
            case INFORMATION: {
                imageLocation = this.getClass().getResource("/tray/resources/info.png");
                paintHex = "#2C54AB";
                break;
            }
            case NOTICE: {
                imageLocation = this.getClass().getResource("/tray/resources/notice.png");
                paintHex = "#8D9695";
                break;
            }
            case SUCCESS: {
                imageLocation = this.getClass().getResource("/tray/resources/success.png");
                paintHex = "#009961";
                break;
            }
            case WARNING: {
                imageLocation = this.getClass().getResource("/tray/resources/warning.png");
                paintHex = "#E23E0A";
                break;
            }
            case ERROR: {
                imageLocation = this.getClass().getResource("/tray/resources/error.png");
                paintHex = "#CC0033";
                break;
            }
            case CUSTOM: {
                return;
            }
        }
        this.setRectangleFill(Paint.valueOf(paintHex));
        this.setImage(new Image(imageLocation.toString()));
        this.setTrayIcon(this.imageIcon.getImage());
    }

    public NotificationType getNotificationType() {
        return this.notificationType;
    }

    public void setTray(String title, String message, NotificationType type) {
        this.setTitle(title);
        this.setMessage(message);
        this.setNotificationType(type);
    }

    public void setTray(String title, String message, Image img, Paint rectangleFill, AnimationType animType) {
        this.setTitle(title);
        this.setMessage(message);
        this.setImage(img);
        this.setRectangleFill(rectangleFill);
        this.setAnimationType(animType);
    }

    public TrayAnimation animator() {
        if (this.__animator == null || !this.__animator.isShowing()) {
            switch (this.animationType) {
                case FADE: {
                    this.__animator = new FadeAnimation(this.stage);
                    break;
                }
                case POPUP: {
                    this.__animator = new PopupAnimation(this.stage);
                    break;
                }
                case SLIDE: {
                    this.__animator = new SlideAnimation(this.stage);
                }
            }
        }
        if (this.__animator != null) {
            this.__animator.setOnFinished(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    TrayNotification.this.onDismissed();
                }
            });
        }
        return this.__animator;
    }

    public boolean isTrayShowing() {
        return this.animator().isShowing();
    }

    private Stage getTmpStage() {
        if (tmpStage == null) {
            tmpStage = new Stage(StageStyle.UTILITY);
            tmpStage.setWidth(2.0);
            tmpStage.setHeight(2.0);
            tmpStage.setX(-999.0);
            tmpStage.setY(-999.0);
            tmpStage.show();
        }
        return tmpStage;
    }

    public void showAndDismiss(Duration dismissDelay) {
        if (this.isTrayShowing()) {
            this.dismiss();
        } else {
            this.onShown();
            this.setLocation(this.getLocation());
            this.stage.show((Window)this.getTmpStage());
            this.animator().playSequential(dismissDelay);
        }
    }

    public void showAndWait() {
        if (!this.isTrayShowing()) {
            this.onShown();
            this.setLocation(this.getLocation());
            this.stage.show((Window)this.getTmpStage());
            this.animator().playShowAnimation();
        }
    }

    public void dismiss() {
        if (this.isTrayShowing()) {
            this.animator().playDismissAnimation();
        }
    }

    public int getViewIndex() {
        return this.viewIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onShown() {
        if (this.onShownCallback != null) {
            this.onShownCallback.handle((Event)new ActionEvent((Object)this, null));
        }
        TrayNotification trayNotification = this;
        synchronized (trayNotification) {
            AtomicInteger count = trayCounts.get((Object)this.location);
            if (count == null) {
                count = new AtomicInteger();
                trayCounts.put(this.location, count);
            }
            this.viewIndex = count.getAndIncrement();
        }
    }

    private void onDismissed() {
        AtomicInteger count;
        if (this.onDismissedCallBack != null) {
            this.onDismissedCallBack.handle((Event)new ActionEvent((Object)this, null));
        }
        if ((count = trayCounts.get((Object)this.location)) != null) {
            count.decrementAndGet();
        }
        this.viewIndex = 0;
    }

    public void setOnDismiss(EventHandler<ActionEvent> event) {
        this.onDismissedCallBack = event;
    }

    public EventHandler<ActionEvent> getOnDismissed() {
        return this.onDismissedCallBack;
    }

    public void setOnShown(EventHandler<ActionEvent> event) {
        this.onShownCallback = event;
    }

    public EventHandler<ActionEvent> getOnShown() {
        return this.onShownCallback;
    }

    public EventHandler<ActionEvent> getOnClick() {
        return this.onClickCallback;
    }

    public void setOnClick(EventHandler<ActionEvent> onClickCallback) {
        this.onClickCallback = onClickCallback;
    }

    public void setTrayIcon(Image img) {
    }

    public Image getTrayIcon() {
        return null;
    }

    public void setTitle(String txt) {
        this.lblTitle.setText(txt);
    }

    public String getTitle() {
        return this.lblTitle.getText();
    }

    public void setMessage(String txt) {
        this.lblMessage.setText(txt);
    }

    public String getMessage() {
        return this.lblMessage.getText();
    }

    public void setImage(Image img) {
        this.imageIcon.setImage(img);
        this.setTrayIcon(img);
    }

    public Image getImage() {
        return this.imageIcon.getImage();
    }

    public void setRectangleFill(Paint value) {
        this.rectangleColor.setFill(value);
    }

    public Paint getRectangleFill() {
        return this.rectangleColor.getFill();
    }

    public void setAnimationType(AnimationType type) {
        this.animationType = type;
    }

    public AnimationType getAnimationType() {
        return this.animationType;
    }

    public double getHorGap() {
        return this.horGap;
    }

    public void setHorGap(double horGap) {
        this.horGap = horGap;
        this.setLocation(this.getLocation());
    }

    public double getVerGap() {
        return this.verGap;
    }

    public void setVerGap(double verGap) {
        this.verGap = verGap;
        this.setLocation(this.getLocation());
    }

    static {
        trayCounts = new HashMap<NotificationLocation, AtomicInteger>();
    }
}

