/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx;

import java.io.InputStream;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.swing.SwingUtilities;
import org.develnext.jphp.ext.javafx.ExceptionDialog;
import org.develnext.jphp.ext.javafx.support.ImageViewEx;
import php.runtime.Memory;
import php.runtime.launcher.Launcher;

public class FXLauncher
extends Launcher {
    private Stage splashStage;

    public FXLauncher() {
    }

    public FXLauncher(String[] args) {
        super(args);
    }

    public FXLauncher(ClassLoader classLoader) {
        super(classLoader);
    }

    protected void readConfig() {
        super.readConfig();
        Memory fxSplash = this.getConfigValue("fx.splash");
        if (fxSplash.toBoolean()) {
            InputStream fxSplashStream = ((Object)((Object)this)).getClass().getResourceAsStream(fxSplash.toString());
            if (fxSplashStream == null) {
                System.err.println("Failed to load 'fx.splash': " + fxSplash.toString());
                return;
            }
            new JFXPanel();
            Platform.runLater(() -> {
                Memory alwaysOnTop;
                Image image = new Image(fxSplashStream);
                ImageViewEx imageView = new ImageViewEx();
                imageView.setAutoSize(true);
                imageView.setImage(image);
                this.splashStage = new Stage(StageStyle.TRANSPARENT);
                VBox root = new VBox(new Node[]{imageView});
                root.setBackground(null);
                Scene scene = new Scene((Parent)root);
                scene.setFill(null);
                this.splashStage.setScene(scene);
                Memory opacity = this.getConfigValue("fx.splash.opacity");
                if (opacity.isNotNull()) {
                    this.splashStage.setOpacity(opacity.toDouble());
                }
                if ((alwaysOnTop = this.getConfigValue("fx.splash.alwaysOnTop")).isNotNull()) {
                    this.splashStage.setAlwaysOnTop(alwaysOnTop.toBoolean());
                }
                this.splashStage.centerOnScreen();
                this.splashStage.show();
                this.splashStage.centerOnScreen();
            });
        }
    }

    public void run(boolean mustBootstrap, boolean disableExtensions) throws Throwable {
        block2: {
            try {
                super.run(mustBootstrap, disableExtensions);
            }
            catch (Throwable e) {
                e.printStackTrace();
                SwingUtilities.invokeLater(() -> {
                    ExceptionDialog ld = new ExceptionDialog("Unexpected System Error!", e.getMessage(), e);
                    ld.setDefaultCloseOperation(2);
                    ld.setAlwaysOnTop(true);
                    ld.expand();
                    ld.setLocationRelativeTo(null);
                    ld.setVisible(true);
                });
                if (this.splashStage == null) break block2;
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        FXLauncher.this.splashStage.hide();
                    }
                });
            }
        }
    }

    public Stage getSplashStage() {
        return this.splashStage;
    }

    public static FXLauncher current() {
        Launcher current = Launcher.current();
        if (current instanceof FXLauncher) {
            return (FXLauncher)current;
        }
        return null;
    }

    public static void main(String[] args) throws Throwable {
        System.setProperty("org.slf4j.simpleLogger.logFile", "System.out");
        FXLauncher launcher = new FXLauncher(args);
        launcher.run();
    }
}

