/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.tray.models;

import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Rectangle2D;
import javafx.scene.control.PopupControl;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Screen;
import org.develnext.jphp.ext.javafx.support.tray.models.Location;

public class CustomStage
extends PopupControl {
    private Location bottomRight;
    private Location bottomLeft;
    private Location topLeft;
    private Location topRight;
    private final AnchorPane ap;
    private double horGap;
    private double verGap;
    private Location location;
    private SimpleDoubleProperty xLocationProperty = new SimpleDoubleProperty(){

        public void set(double newValue) {
            CustomStage.this.setX(newValue);
        }

        public double get() {
            return CustomStage.this.getX();
        }
    };
    private SimpleDoubleProperty yLocationProperty = new SimpleDoubleProperty(){

        public void set(double newValue) {
            CustomStage.this.setY(newValue);
        }

        public double get() {
            return CustomStage.this.getY();
        }
    };

    public CustomStage(AnchorPane ap, double horGap, double verGap) {
        this.ap = ap;
        this.horGap = horGap;
        this.verGap = verGap;
        this.setSize(ap.getPrefWidth(), ap.getPrefHeight());
    }

    protected void reinit() {
        Rectangle2D screenBounds = Screen.getPrimary().getVisualBounds();
        double x = screenBounds.getMinX() + screenBounds.getWidth() - this.ap.getPrefWidth() - this.horGap;
        double y = screenBounds.getMinY() + screenBounds.getHeight() - this.ap.getPrefHeight() - this.verGap;
        this.bottomRight = new Location(x, y);
        this.bottomLeft = new Location(this.horGap, y);
        this.topLeft = new Location(this.horGap, this.verGap);
        this.topRight = new Location(x, this.verGap);
    }

    public double getHorGap() {
        return this.horGap;
    }

    public double getVerGap() {
        return this.verGap;
    }

    public void setHorGap(double horGap) {
        this.horGap = horGap;
        this.reinit();
    }

    public void setVerGap(double verGap) {
        this.verGap = verGap;
        this.reinit();
    }

    public Location getBottomRight(int viewIndex) {
        if (viewIndex > 0) {
            return new Location(this.bottomRight.getX(), this.bottomRight.getY() - (double)viewIndex * (this.getHeight() + 2.0));
        }
        return this.bottomRight;
    }

    public Location getBottomLeft(int viewIndex) {
        if (viewIndex > 0) {
            return new Location(this.bottomLeft.getX(), this.bottomLeft.getY() - (double)viewIndex * (this.getHeight() + 2.0));
        }
        return this.bottomLeft;
    }

    public Location getTopLeft(int viewIndex) {
        if (viewIndex > 0) {
            return new Location(this.topLeft.getX(), this.topLeft.getY() - (double)viewIndex * (this.getHeight() + 2.0));
        }
        return this.topLeft;
    }

    public Location getTopRight(int viewIndex) {
        if (viewIndex > 0) {
            return new Location(this.topRight.getX(), this.topRight.getY() + (double)viewIndex * (this.getHeight() + 2.0));
        }
        return this.topRight;
    }

    public void setSize(double width, double height) {
        this.setWidth(width);
        this.setHeight(height);
    }

    public Location getOffScreenBounds() {
        Location loc = this.getBottomRight(0);
        return new Location(loc.getX() + this.getWidth(), loc.getY());
    }

    public void setLocation(Location loc) {
        this.setX(loc.getX());
        this.setY(loc.getY());
        this.location = loc;
    }

    public Location getLocation() {
        return this.location;
    }

    public SimpleDoubleProperty xLocationProperty() {
        return this.xLocationProperty;
    }

    public SimpleDoubleProperty yLocationProperty() {
        return this.yLocationProperty;
    }
}

