/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.controls.JFXListCell$$Lambda$1;
import com.jfoenix.controls.JFXListCell$$Lambda$10;
import com.jfoenix.controls.JFXListCell$$Lambda$11;
import com.jfoenix.controls.JFXListCell$$Lambda$12;
import com.jfoenix.controls.JFXListCell$$Lambda$2;
import com.jfoenix.controls.JFXListCell$$Lambda$3;
import com.jfoenix.controls.JFXListCell$$Lambda$4;
import com.jfoenix.controls.JFXListCell$$Lambda$5;
import com.jfoenix.controls.JFXListCell$$Lambda$6;
import com.jfoenix.controls.JFXListCell$$Lambda$7;
import com.jfoenix.controls.JFXListCell$$Lambda$8;
import com.jfoenix.controls.JFXListCell$$Lambda$9;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.svg.SVGGlyph;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public class JFXListCell<T>
extends ListCell<T> {
    protected JFXRippler cellRippler = new JFXRippler((Node)new StackPane());
    protected Node cellContent;
    private Rectangle clip;
    private Timeline expandAnimation;
    private Timeline gapAnimation;
    private double animatedHeight = 0.0;
    private boolean playExpandAnimation = false;
    private boolean selectionChanged = false;
    @Deprecated
    private BooleanProperty expandedProperty = new SimpleBooleanProperty(false);
    private static final String DEFAULT_STYLE_CLASS = "jfx-list-cell";

    public JFXListCell() {
        this.initialize();
        this.initListeners();
    }

    private void initListeners() {
        this.listViewProperty().addListener(JFXListCell$$Lambda$1.lambdaFactory$(this));
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.cellRippler.resizeRelocate(0.0, 0.0, this.getWidth(), this.getHeight());
        double gap = this.getGap();
        if (this.clip == null) {
            this.clip = new Rectangle(0.0, gap / 2.0, this.getWidth(), this.getHeight() - gap);
            this.setClip((Node)this.clip);
        } else {
            if (gap != 0.0) {
                if (this.playExpandAnimation || this.selectionChanged) {
                    if (this.playExpandAnimation) {
                        this.setTranslateY(-gap / 2.0 + -gap * (double)this.getIndex());
                        this.clip.setY(gap / 2.0);
                        this.clip.setHeight(this.getHeight() - gap);
                        this.gapAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)240.0), new KeyValue[]{new KeyValue((WritableValue)this.translateYProperty(), (Object)0, Interpolator.EASE_BOTH)})});
                        this.playExpandAnimation = false;
                    } else if (this.selectionChanged) {
                        this.clip.setY(0.0);
                        this.clip.setHeight(this.getHeight());
                        this.gapAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)240.0), new KeyValue[]{new KeyValue((WritableValue)this.clip.yProperty(), (Object)(gap / 2.0), Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.clip.heightProperty(), (Object)(this.getHeight() - gap), Interpolator.EASE_BOTH)})});
                    }
                    this.playExpandAnimation = false;
                    this.selectionChanged = false;
                    this.gapAnimation.play();
                } else {
                    if (this.gapAnimation != null) {
                        this.gapAnimation.stop();
                    }
                    this.setTranslateY(0.0);
                    this.clip.setY(gap / 2.0);
                    this.clip.setHeight(this.getHeight() - gap);
                }
            } else {
                this.setTranslateY(0.0);
                this.clip.setY(0.0);
                this.clip.setHeight(this.getHeight());
            }
            this.clip.setX(0.0);
            this.clip.setWidth(this.getWidth());
        }
        if (!this.getChildren().contains((Object)this.cellRippler)) {
            this.makeChildrenTransparent();
            this.getChildren().add(0, (Object)this.cellRippler);
            this.cellRippler.rippler.clear();
        }
        if (this.getGraphic() != null && this.getGraphic().getStyleClass().contains((Object)"sublist-container")) {
            this.getStyleClass().add((Object)"sublist-item");
        } else {
            this.getStyleClass().remove((Object)"sublist-item");
        }
    }

    protected void makeChildrenTransparent() {
        for (Node child : this.getChildren()) {
            if (!(child instanceof Label) && !(child instanceof Shape)) continue;
            child.setMouseTransparent(true);
        }
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
            this.setMouseTransparent(true);
            this.setStyle("-fx-background-color:TRANSPARENT;");
        } else {
            this.setMouseTransparent(false);
            this.setStyle(null);
            if (item instanceof Node) {
                this.setText(null);
                Node currentNode = this.getGraphic();
                Node newNode = (Node)item;
                if (currentNode == null || !currentNode.equals(newNode)) {
                    this.cellContent = newNode;
                    this.cellRippler.rippler.cacheRippleClip(false);
                    if (newNode instanceof JFXRippler) {
                        this.cellRippler.ripplerFillProperty().bind(((JFXRippler)newNode).ripplerFillProperty());
                        this.cellRippler.maskTypeProperty().bind(((JFXRippler)newNode).maskTypeProperty());
                        this.cellRippler.positionProperty().bind(((JFXRippler)newNode).positionProperty());
                        this.cellContent = ((JFXRippler)newNode).getControl();
                    } else if (newNode instanceof JFXListView) {
                        ((JFXListView)this.getListView()).addSublist((JFXListView)newNode, this.getIndex());
                        this.getStyleClass().add((Object)"sublist-item");
                        if (this.getPadding() != null) {
                            this.setPadding(new Insets(this.getPadding().getTop(), 0.0, this.getPadding().getBottom(), 0.0));
                        }
                        StackPane groupNode = new StackPane();
                        groupNode.getStyleClass().add((Object)"sublist-header");
                        SVGGlyph dropIcon = new SVGGlyph(0, "ANGLE_RIGHT", "M340 548.571q0 7.429-5.714 13.143l-266.286 266.286q-5.714 5.714-13.143 5.714t-13.143-5.714l-28.571-28.571q-5.714-5.714-5.714-13.143t5.714-13.143l224.571-224.571-224.571-224.571q-5.714-5.714-5.714-13.143t5.714-13.143l28.571-28.571q5.714-5.714 13.143-5.714t13.143 5.714l266.286 266.286q5.714 5.714 5.714 13.143z", (Paint)Color.BLACK);
                        dropIcon.setStyle("-fx-min-width:0.4em;-fx-max-width:0.4em;-fx-min-height:0.6em;-fx-max-height:0.6em;");
                        dropIcon.getStyleClass().add((Object)"drop-icon");
                        groupNode.getChildren().setAll((Object[])new Node[]{((JFXListView)newNode).getGroupnode(), dropIcon});
                        StackPane.setMargin((Node)dropIcon, (Insets)new Insets(0.0, 19.0, 0.0, 0.0));
                        StackPane.setAlignment((Node)dropIcon, (Pos)Pos.CENTER_RIGHT);
                        StackPane sublistContainer = new StackPane();
                        sublistContainer.setMinHeight(0.0);
                        sublistContainer.setMaxHeight(0.0);
                        sublistContainer.getChildren().setAll((Object[])new Node[]{newNode});
                        sublistContainer.setTranslateY(this.snappedBottomInset());
                        sublistContainer.setOpacity(0.0);
                        StackPane.setMargin((Node)newNode, (Insets)new Insets(-1.0, -1.0, 0.0, -1.0));
                        VBox contentHolder = new VBox();
                        contentHolder.getChildren().setAll((Object[])new Node[]{groupNode, sublistContainer});
                        contentHolder.getStyleClass().add((Object)"sublist-container");
                        VBox.setVgrow((Node)groupNode, (Priority)Priority.ALWAYS);
                        this.cellContent = contentHolder;
                        this.cellRippler.ripplerPane.addEventHandler(MouseEvent.ANY, JFXListCell$$Lambda$2.lambdaFactory$());
                        contentHolder.addEventHandler(MouseEvent.ANY, JFXListCell$$Lambda$3.lambdaFactory$(this));
                        this.cellRippler.ripplerPane.addEventHandler(MouseEvent.MOUSE_CLICKED, JFXListCell$$Lambda$4.lambdaFactory$(contentHolder));
                        this.cellRippler.rippler.cacheRippleClip(true);
                        this.setOnMouseClicked(JFXListCell$$Lambda$5.lambdaFactory$());
                        contentHolder.setOnMouseClicked(JFXListCell$$Lambda$6.lambdaFactory$(this, newNode, sublistContainer));
                        this.expandedProperty.addListener(JFXListCell$$Lambda$7.lambdaFactory$(dropIcon));
                    }
                    ((Region)this.cellContent).setMaxHeight(this.cellContent.prefHeight(-1.0));
                    this.setGraphic(this.cellContent);
                }
            } else {
                this.setText(item == null ? "null" : item.toString());
                this.setGraphic(null);
            }
            boolean isJFXListView = this.getListView() instanceof JFXListView;
            if (isJFXListView && ((JFXListView)this.getListView()).isShowTooltip()) {
                if (item instanceof Label) {
                    this.setTooltip(new Tooltip(((Label)item).getText()));
                } else if (this.getText() != null) {
                    this.setTooltip(new Tooltip(this.getText()));
                }
            }
        }
    }

    private void updateClipHeight(double newHeight) {
        this.clip.setHeight(newHeight - this.getGap());
    }

    @Deprecated
    public BooleanProperty expandedProperty() {
        return this.expandedProperty;
    }

    @Deprecated
    public void setExpanded(boolean expand) {
        this.expandedProperty.set(expand);
    }

    @Deprecated
    public boolean isExpanded() {
        return this.expandedProperty.get();
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setPadding(new Insets(8.0, 12.0, 8.0, 12.0));
    }

    protected double computePrefHeight(double width) {
        double gap = this.getGap();
        return super.computePrefHeight(width) + gap;
    }

    private double getGap() {
        return this.getListView() instanceof JFXListView ? (((JFXListView)this.getListView()).isExpanded().booleanValue() ? ((JFXListView)this.getListView()).currentVerticalGapProperty().get() : 0.0) : 0.0;
    }

    static /* synthetic */ void lambda$updateItem$11(SVGGlyph dropIcon, ObservableValue o, Boolean oldVal, Boolean newVal) {
        if (newVal.booleanValue()) {
            new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)dropIcon.rotateProperty(), (Object)90, Interpolator.EASE_BOTH)})}).play();
        } else {
            new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)160.0), new KeyValue[]{new KeyValue((WritableValue)dropIcon.rotateProperty(), (Object)0, Interpolator.EASE_BOTH)})}).play();
        }
    }

    static /* synthetic */ void lambda$updateItem$10(JFXListCell this_, Node newNode, StackPane sublistContainer, MouseEvent click) {
        double contentHeight;
        click.consume();
        if (this_.expandAnimation != null && this_.expandAnimation.getStatus() == Animation.Status.RUNNING) {
            this_.expandAnimation.stop();
        }
        this_.expandedProperty.set(!this_.expandedProperty.get());
        double newAnimatedHeight = newNode.prefHeight(-1.0) * (double)(this_.expandedProperty.get() ? 1 : -1);
        double newHeight = this_.expandedProperty.get() ? this_.getHeight() + newAnimatedHeight : this_.prefHeight(-1.0);
        double d = contentHeight = this_.expandedProperty.get() ? newAnimatedHeight : 0.0;
        if (this_.expandedProperty.get()) {
            this_.updateClipHeight(newHeight);
            this_.getListView().setPrefHeight(this_.getListView().getHeight() + newAnimatedHeight + this_.animatedHeight);
        }
        this_.animatedHeight = newAnimatedHeight;
        int opacity = this_.expandedProperty.get() ? 1 : 0;
        this_.expandAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)320.0), new KeyValue[]{new KeyValue((WritableValue)sublistContainer.minHeightProperty(), (Object)contentHeight, Interpolator.EASE_BOTH), new KeyValue((WritableValue)sublistContainer.maxHeightProperty(), (Object)contentHeight, Interpolator.EASE_BOTH), new KeyValue((WritableValue)sublistContainer.opacityProperty(), (Object)opacity, Interpolator.EASE_BOTH)})});
        if (!this_.expandedProperty.get()) {
            this_.expandAnimation.setOnFinished(JFXListCell$$Lambda$8.lambdaFactory$(this_, newHeight, newAnimatedHeight));
        }
        this_.expandAnimation.play();
    }

    static /* synthetic */ void lambda$null$9(JFXListCell this_, double newHeight, double newAnimatedHeight, ActionEvent finish) {
        this_.updateClipHeight(newHeight);
        this_.getListView().setPrefHeight(this_.getListView().getHeight() + newAnimatedHeight);
        this_.animatedHeight = 0.0;
    }

    static /* synthetic */ void lambda$updateItem$8(MouseEvent e) {
        e.consume();
    }

    static /* synthetic */ void lambda$updateItem$7(VBox contentHolder, MouseEvent e) {
        if (!e.isConsumed()) {
            e.consume();
            contentHolder.fireEvent((Event)e);
        }
    }

    static /* synthetic */ void lambda$updateItem$6(JFXListCell this_, MouseEvent e) {
        if (!e.isConsumed()) {
            this_.cellRippler.ripplerPane.fireEvent((Event)e);
            e.consume();
        }
    }

    static /* synthetic */ void lambda$updateItem$5(MouseEvent e) {
        e.consume();
    }

    static /* synthetic */ void lambda$initListeners$4(JFXListCell this_, ObservableValue listObj, ListView oldList, ListView newList) {
        if (newList != null && this_.getListView() instanceof JFXListView) {
            ((JFXListView)newList).currentVerticalGapProperty().addListener(JFXListCell$$Lambda$9.lambdaFactory$(this_));
            this_.selectedProperty().addListener(JFXListCell$$Lambda$10.lambdaFactory$(this_));
        }
    }

    static /* synthetic */ void lambda$null$3(JFXListCell this_, ObservableValue o, Boolean oldVal, Boolean newVal) {
        if (newVal.booleanValue()) {
            this_.selectionChanged = true;
        }
    }

    static /* synthetic */ void lambda$null$2(JFXListCell this_, ObservableValue o, Number oldVal, Number newVal) {
        this_.cellRippler.rippler.setClip(null);
        if (newVal.doubleValue() != 0.0) {
            this_.playExpandAnimation = true;
            this_.getListView().requestLayout();
        } else {
            double gap = this_.clip.getY() * 2.0;
            this_.gapAnimation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)240.0), new KeyValue[]{new KeyValue((WritableValue)this_.translateYProperty(), (Object)(-gap / 2.0 - gap * (double)this_.getIndex()), Interpolator.EASE_BOTH)})});
            this_.gapAnimation.play();
            this_.gapAnimation.setOnFinished(JFXListCell$$Lambda$11.lambdaFactory$(this_));
        }
    }

    static /* synthetic */ void lambda$null$1(JFXListCell this_, ActionEvent finish) {
        this_.requestLayout();
        Platform.runLater((Runnable)JFXListCell$$Lambda$12.lambdaFactory$(this_));
    }

    static /* synthetic */ void lambda$null$0(JFXListCell this_) {
        this_.getListView().requestLayout();
    }
}

