/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.common.collections.iterators;

import java.util.Iterator;
import php.runtime.common.collections.Unmodifiable;

public final class UnmodifiableIterator<E>
implements Iterator<E>,
Unmodifiable {
    private Iterator<E> iterator;

    public static <E> Iterator<E> decorate(Iterator<E> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("Iterator must not be null");
        }
        if (iterator instanceof Unmodifiable) {
            return iterator;
        }
        return new UnmodifiableIterator<E>(iterator);
    }

    private UnmodifiableIterator(Iterator<E> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported");
    }
}

