/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes;

import java.util.LinkedHashMap;
import java.util.Map;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.lang.BaseObject;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.spl.ArrayAccess;
import php.runtime.lang.spl.Countable;
import php.runtime.lang.spl.Traversable;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="EnvironmentVariables")
@Reflection.Namespace(value="php\\lang")
public class WrapEnvironmentVariables
extends BaseObject
implements Traversable,
ArrayAccess,
Countable {
    private Map<String, String> userEnv;

    public WrapEnvironmentVariables(Environment env) {
        super(env);
        this.init(env);
    }

    public WrapEnvironmentVariables(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    private void init(Environment env) {
        this.userEnv = env.getUserValue("env", Map.class);
        if (this.userEnv == null) {
            this.userEnv = new LinkedHashMap<String, String>();
            env.setUserValue("env", this.userEnv);
        }
        this.userEnv.putAll(System.getenv());
    }

    @Reflection.Signature
    public void __construct(Environment env) {
        this.init(env);
    }

    @Reflection.Signature
    public Memory __debugInfo() {
        return ArrayMemory.ofStringMap(this.userEnv).toConstant();
    }

    @Override
    @Reflection.Signature(value={@Reflection.Arg(value="offset")}, result=@Reflection.Arg(type=HintType.BOOLEAN))
    public synchronized Memory offsetExists(Environment env, Memory ... args) {
        return this.userEnv.containsKey(args[0].toString()) ? Memory.TRUE : Memory.FALSE;
    }

    @Override
    @Reflection.Signature(value={@Reflection.Arg(value="offset")})
    public Memory offsetGet(Environment env, Memory ... args) {
        String value = this.userEnv.get(args[0].toString());
        return value == null ? Memory.NULL : StringMemory.valueOf(value);
    }

    @Override
    @Reflection.Signature(value={@Reflection.Arg(value="offset"), @Reflection.Arg(value="value")})
    public synchronized Memory offsetSet(Environment env, Memory ... args) {
        this.userEnv.put(args[0].toString(), args[1].toString());
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature(value={@Reflection.Arg(value="offset")})
    public synchronized Memory offsetUnset(Environment env, Memory ... args) {
        this.userEnv.remove(args[0].toString());
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory count(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.userEnv.size());
    }

    @Override
    public ForeachIterator getNewIterator(Environment env, boolean getReferences, boolean getKeyReferences) {
        return ForeachIterator.of(env, this.userEnv);
    }

    @Override
    public ForeachIterator getNewIterator(Environment env) {
        return ForeachIterator.of(env, this.userEnv);
    }
}

