/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.lib;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Stack;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseObject;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.spl.Countable;
import php.runtime.lang.spl.Traversable;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\util\\Shared")
public class SharedUtils
extends BaseObject {
    protected static final Map<String, SharedValue> globalValue = new HashMap<String, SharedValue>();

    public SharedUtils(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    private void __construct() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflection.Signature
    public static void resetAll() {
        Map<String, SharedValue> map = globalValue;
        synchronized (map) {
            globalValue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflection.Signature
    public static SharedValue reset(String name) {
        Map<String, SharedValue> map = globalValue;
        synchronized (map) {
            return globalValue.remove(name);
        }
    }

    @Reflection.Signature
    public static SharedValue value(Environment env, String name) throws Throwable {
        return SharedUtils.value(env, name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflection.Signature
    public static SharedValue value(Environment env, String name, @Reflection.Nullable Invoker creator) throws Throwable {
        SharedValue value = globalValue.get(name);
        if (value != null) {
            return value;
        }
        Map<String, SharedValue> map = globalValue;
        synchronized (map) {
            value = new SharedValue(env, (Memory)null);
            SharedValue oldValue = globalValue.get(name);
            if (oldValue != null) {
                return oldValue;
            }
            if (creator != null) {
                value.set(creator.call(new Memory[0]));
            }
            globalValue.put(name, value);
            return value;
        }
    }

    @Reflection.Name(value="php\\util\\SharedMap")
    public static class SharedMap
    extends SharedCollection {
        protected Map<String, Memory> map;

        public SharedMap(Environment env, Map<String, Memory> map) {
            super(env);
            this.map = map;
        }

        public SharedMap(Environment env, ClassEntity clazz) {
            super(env, clazz);
        }

        @Reflection.Signature
        public void __construct(ForeachIterator iterator) {
            this.map = new LinkedHashMap<String, Memory>();
            while (iterator.next()) {
                this.map.put(iterator.getKey().toString(), iterator.getValue().toImmutable());
            }
        }

        @Reflection.Signature
        public void __construct() {
            this.map = new LinkedHashMap<String, Memory>();
        }

        @Reflection.Signature
        public synchronized Memory __debugInfo(Environment env, Memory ... args) {
            ArrayMemory info = new ArrayMemory();
            info.refOfIndex("*map").assign(ArrayMemory.ofMap(this.map));
            return info.toConstant();
        }

        @Override
        @Reflection.Signature
        public synchronized boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Reflection.Signature
        public synchronized boolean has(String key) {
            return this.map.containsKey(key);
        }

        @Override
        @Reflection.Signature
        public synchronized Memory count(Environment env, Memory ... args) {
            return LongMemory.valueOf(this.map.size());
        }

        @Reflection.Signature
        public synchronized Memory get(String key) {
            return this.get(key, Memory.UNDEFINED);
        }

        @Reflection.Signature
        public synchronized Memory getOrCreate(String key, Invoker create) throws Throwable {
            Memory result = this.map.get(key);
            if (result == null) {
                result = create.call(new Memory[0]);
                this.map.put(key, result);
            }
            return result;
        }

        @Reflection.Signature
        public synchronized Memory get(String key, Memory defaultValue) {
            Memory result = this.map.get(key);
            return result == null ? defaultValue : result;
        }

        @Reflection.Signature
        public synchronized Memory set(String key, Memory value, boolean override) {
            if (override || this.map.get(key) == null) {
                Memory result = this.map.put(key, value);
                return result == null ? Memory.UNDEFINED : result;
            }
            return Memory.NULL;
        }

        @Reflection.Signature
        public Memory set(String key, Memory value) {
            return this.set(key, value, true);
        }

        @Reflection.Signature
        public synchronized Memory remove(String key) {
            Memory memory = this.map.remove(key);
            return memory == null ? Memory.UNDEFINED : memory;
        }

        @Override
        @Reflection.Signature
        public synchronized void clear() {
            this.map.clear();
        }

        @Reflection.Signature
        public synchronized void __clone() {
            this.map = new LinkedHashMap<String, Memory>(this.map);
        }

        @Override
        public synchronized ForeachIterator getNewIterator(Environment env, boolean getReferences, boolean getKeyReferences) {
            final SharedMap mutex = this;
            return new ForeachIterator(getReferences, getKeyReferences, false){
                private Iterator<Map.Entry<String, Memory>> entries;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected boolean init() {
                    this.reset();
                    Object object = mutex;
                    synchronized (object) {
                        return !map.isEmpty();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected boolean nextValue() {
                    Object object = mutex;
                    synchronized (object) {
                        if (this.entries.hasNext()) {
                            Map.Entry<String, Memory> entry = this.entries.next();
                            this.currentKey = entry.getKey();
                            this.currentKeyMemory = StringMemory.valueOf(this.currentKey.toString());
                            this.currentValue = entry.getValue();
                            if (!this.getReferences) {
                                this.currentValue = this.currentValue.toValue();
                            }
                            return true;
                        }
                        return false;
                    }
                }

                @Override
                protected boolean prevValue() {
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void reset() {
                    Object object = mutex;
                    synchronized (object) {
                        this.entries = map.entrySet().iterator();
                    }
                }
            };
        }

        @Override
        public ForeachIterator getNewIterator(Environment env) {
            return this.getNewIterator(env, false, false);
        }
    }

    @Reflection.Name(value="php\\util\\SharedStack")
    public static class SharedStack
    extends SharedCollection {
        protected Stack<Memory> stack;

        public SharedStack(Environment env, Stack<Memory> stack) {
            super(env);
            this.stack = stack;
        }

        public SharedStack(Environment env, ClassEntity clazz) {
            super(env, clazz);
        }

        @Reflection.Signature
        public void __construct(ForeachIterator iterator) {
            this.stack = new Stack();
            while (iterator.next()) {
                this.stack.push(iterator.getValue().toImmutable());
            }
        }

        @Reflection.Signature
        public void __construct() {
            this.stack = new Stack();
        }

        @Reflection.Signature
        public synchronized Memory __debugInfo(Environment env, Memory ... args) {
            ArrayMemory info = new ArrayMemory();
            info.refOfIndex("*stack").assign(ArrayMemory.ofCollection(this.stack));
            return info.toConstant();
        }

        @Override
        @Reflection.Signature
        public synchronized Memory count(Environment env, Memory ... args) {
            return LongMemory.valueOf(this.stack.size());
        }

        @Reflection.Signature
        public synchronized Memory push(Memory arg) {
            return this.stack.push(arg);
        }

        @Override
        @Reflection.Signature
        public synchronized boolean isEmpty() {
            return this.stack.empty();
        }

        @Reflection.Signature
        public synchronized Memory pop() {
            if (this.stack.empty()) {
                return Memory.NULL;
            }
            return this.stack.pop();
        }

        @Reflection.Signature
        public synchronized Memory peek() {
            if (this.stack.empty()) {
                return Memory.NULL;
            }
            return this.stack.peek();
        }

        @Override
        @Reflection.Signature
        public synchronized void clear() {
            this.stack.clear();
        }

        @Reflection.Signature
        public synchronized void __clone() {
            Stack<Memory> old = this.stack;
            this.stack = new Stack();
            this.stack.addAll(old);
        }

        @Override
        public synchronized ForeachIterator getNewIterator(Environment env, boolean getReferences, boolean getKeyReferences) {
            final SharedStack mutex = this;
            return new ForeachIterator(getReferences, getKeyReferences, false){
                protected Iterator<Memory> iterator;
                protected int index;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected boolean init() {
                    this.reset();
                    Object object = mutex;
                    synchronized (object) {
                        return !stack.isEmpty();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected boolean nextValue() {
                    Object object = mutex;
                    synchronized (object) {
                        if (this.iterator.hasNext()) {
                            ++this.index;
                            this.currentKeyMemory = LongMemory.valueOf(this.index);
                            this.currentKey = this.currentKeyMemory;
                            this.currentValue = this.iterator.next();
                            if (!this.getReferences) {
                                this.currentValue = this.currentValue.toValue();
                            }
                            return true;
                        }
                        return false;
                    }
                }

                @Override
                protected boolean prevValue() {
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void reset() {
                    Object object = mutex;
                    synchronized (object) {
                        this.index = -1;
                        this.currentKeyMemory = Memory.CONST_INT_M1;
                        this.currentKey = this.currentKeyMemory;
                        this.iterator = stack.iterator();
                    }
                }
            };
        }

        @Override
        public ForeachIterator getNewIterator(Environment env) {
            return this.getNewIterator(env, false, false);
        }
    }

    @Reflection.Name(value="php\\util\\SharedQueue")
    public static class SharedQueue
    extends SharedCollection {
        protected Queue<Memory> queue;

        public SharedQueue(Environment env, Queue<Memory> queue) {
            super(env);
            this.queue = queue;
        }

        public SharedQueue(Environment env, ClassEntity clazz) {
            super(env, clazz);
        }

        @Reflection.Signature
        public void __construct() {
            this.queue = new LinkedList<Memory>();
        }

        @Reflection.Signature
        public synchronized Memory __debugInfo(Environment env, Memory ... args) {
            ArrayMemory info = new ArrayMemory();
            info.refOfIndex("*queue").assign(ArrayMemory.ofCollection(this.queue));
            return info.toConstant();
        }

        @Reflection.Signature
        public void __construct(ForeachIterator iterator) {
            this.queue = new LinkedList<Memory>();
            while (iterator.next()) {
                this.queue.add(iterator.getValue().toImmutable());
            }
        }

        @Override
        @Reflection.Signature
        public synchronized boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        @Reflection.Signature
        public synchronized void clear() {
            this.queue.clear();
        }

        @Reflection.Signature
        public synchronized boolean add(Memory value) {
            return this.queue.offer(value);
        }

        @Reflection.Signature
        public synchronized Memory remove() {
            return this.queue.remove();
        }

        @Reflection.Signature
        public synchronized Memory peek() {
            return this.queue.peek();
        }

        @Reflection.Signature
        public synchronized Memory poll() {
            return this.queue.poll();
        }

        @Override
        @Reflection.Signature
        public synchronized Memory count(Environment env, Memory ... args) {
            return LongMemory.valueOf(this.queue.size());
        }

        @Override
        public synchronized ForeachIterator getNewIterator(Environment env, boolean getReferences, boolean getKeyReferences) {
            final SharedQueue mutex = this;
            return new ForeachIterator(getReferences, getKeyReferences, false){
                private Iterator<Memory> iterator;
                protected int index;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected boolean init() {
                    this.reset();
                    Object object = mutex;
                    synchronized (object) {
                        return !queue.isEmpty();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected boolean nextValue() {
                    Object object = mutex;
                    synchronized (object) {
                        if (this.iterator.hasNext()) {
                            ++this.index;
                            this.currentKeyMemory = LongMemory.valueOf(this.index);
                            this.currentKey = this.currentKeyMemory;
                            this.currentValue = this.iterator.next();
                            if (!this.getReferences) {
                                this.currentValue = this.currentValue.toValue();
                            }
                            return true;
                        }
                        return false;
                    }
                }

                @Override
                protected boolean prevValue() {
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void reset() {
                    Object object = mutex;
                    synchronized (object) {
                        this.currentKeyMemory = Memory.CONST_INT_M1;
                        this.currentKey = this.currentKeyMemory;
                        this.index = -1;
                        this.iterator = queue.iterator();
                    }
                }
            };
        }

        @Override
        public ForeachIterator getNewIterator(Environment env) {
            return this.getNewIterator(env, false, false);
        }
    }

    @Reflection.Name(value="php\\util\\SharedCollection")
    public static abstract class SharedCollection
    extends SharedMemory
    implements Countable,
    Traversable {
        public SharedCollection(Environment env) {
            super(env);
        }

        public SharedCollection(Environment env, ClassEntity clazz) {
            super(env, clazz);
        }

        @Reflection.Signature
        public abstract boolean isEmpty();

        @Reflection.Signature
        public abstract void clear();
    }

    @Reflection.Name(value="php\\util\\SharedValue")
    public static class SharedValue
    extends SharedMemory {
        protected Memory value = null;

        public SharedValue(Environment env, Memory value) {
            super(env);
            this.value = value;
        }

        public SharedValue(Environment env, ClassEntity clazz) {
            super(env, clazz);
        }

        @Reflection.Signature
        public synchronized void __construct() {
            this.value = null;
        }

        @Reflection.Signature
        public synchronized void __construct(Memory value) {
            this.value = value;
        }

        @Reflection.Signature
        public synchronized Memory __debugInfo(Environment env, Memory ... args) {
            ArrayMemory info = new ArrayMemory();
            info.refOfIndex("*value").assign(this.value);
            return info.toConstant();
        }

        @Reflection.Signature
        public synchronized boolean isEmpty() {
            return this.value == null;
        }

        @Reflection.Signature
        public synchronized Memory get() {
            return this.value == null ? Memory.UNDEFINED : this.value;
        }

        @Reflection.Signature
        public Memory set(Memory value) {
            return this.set(value, true);
        }

        @Reflection.Signature
        public synchronized Memory set(Memory value, boolean override) {
            Memory result = this.value;
            if (value == null || override) {
                this.value = value;
            }
            return result == null ? Memory.UNDEFINED : result;
        }

        @Reflection.Signature
        public synchronized Memory remove() {
            Memory result = this.value;
            this.value = null;
            return result == null ? Memory.UNDEFINED : result;
        }

        @Reflection.Signature
        public synchronized Memory getAndSet(Invoker update) throws Throwable {
            Memory result = this.value == null ? Memory.UNDEFINED : this.value;
            this.value = update.call(result);
            return result;
        }

        @Reflection.Signature
        public synchronized Memory setAndGet(Invoker update) throws Throwable {
            this.value = this.value == null ? Memory.UNDEFINED : this.value;
            this.value = update.call(this.value);
            return this.value;
        }

        @Override
        @Reflection.Signature
        public synchronized Memory synchronize(Invoker sync) throws Throwable {
            if (sync.getArgumentCount() > 0) {
                return sync.call(ObjectMemory.valueOf(this));
            }
            return sync.call(new Memory[0]);
        }

        @Reflection.Signature
        public synchronized void __clone(Environment env, TraceInfo trace) throws Throwable {
            this.value = this.value == null ? null : (this.value.isObject() ? this.value.clone(env, trace) : this.value.toImmutable());
        }
    }

    @Reflection.Name(value="php\\util\\SharedMemory")
    public static abstract class SharedMemory
    extends BaseObject {
        public SharedMemory(Environment env) {
            super(env);
        }

        public SharedMemory(Environment env, ClassEntity clazz) {
            super(env, clazz);
        }

        @Reflection.Signature
        public synchronized Memory synchronize(Invoker sync) throws Throwable {
            if (sync.getArgumentCount() > 0) {
                return sync.call(ObjectMemory.valueOf(this));
            }
            return sync.call(new Memory[0]);
        }
    }
}

