/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.stream;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.Constants;
import php.runtime.common.DigestUtils;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.ext.core.classes.stream.WrapIOException;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\io\\File")
public class FileObject
extends BaseObject {
    public static final String PATH_SEPARATOR = File.pathSeparator;
    public static final String DIRECTORY_SEPARATOR = File.separator;
    public static final boolean PATH_NAME_CASE_INSENSITIVE = Constants.PATH_NAME_CASE_INSENSITIVE;
    protected File file;

    public FileObject(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public FileObject(Environment env, File file) {
        super(env);
        this.file = file;
        if (file == null) {
            throw new IllegalArgumentException();
        }
    }

    public FileObject(Environment env, ClassEntity clazz, File file) {
        super(env, clazz);
        this.file = file;
        if (file == null) {
            throw new IllegalArgumentException();
        }
    }

    protected void exception(Environment env, String message, Object ... args) {
        WrapIOException exception = new WrapIOException(env, env.fetchClass("php\\io\\IOException"));
        exception.__construct(env, new StringMemory(String.format(message, args)));
        env.__throwException(exception);
    }

    public File getFile() {
        return this.file;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="path"), @Reflection.Arg(value="child", optional=@Reflection.Optional(value="NULL"))})
    public Memory __construct(Environment env, Memory ... args) {
        String path = args[0].toString();
        if (args[1].isNull()) {
            this.file = new File(path);
        } else {
            String child = args[1].toString();
            this.file = new File(path, child);
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory __debugInfo(Environment env, Memory ... args) {
        ArrayMemory r = new ArrayMemory();
        r.refOfIndex("*path").assign(this.file.getPath());
        return r.toConstant();
    }

    @Reflection.Signature
    public Memory exists(Environment env, Memory ... args) {
        return this.file.exists() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory canExecute(Environment env, Memory ... args) {
        return this.file.canExecute() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory canRead(Environment env, Memory ... args) {
        return this.file.canRead() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory canWrite(Environment env, Memory ... args) {
        return this.file.canWrite() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory getName(Environment env, Memory ... args) {
        return new StringMemory(this.file.getName());
    }

    @Reflection.Signature
    public Memory getAbsolutePath(Environment env, Memory ... args) {
        return new StringMemory(this.file.getAbsolutePath());
    }

    @Reflection.Signature
    public Memory getCanonicalPath(Environment env, Memory ... args) {
        try {
            return new StringMemory(this.file.getCanonicalPath());
        }
        catch (IOException e) {
            this.exception(env, e.getMessage(), new Object[0]);
            return Memory.FALSE;
        }
    }

    @Reflection.Signature
    public Memory getParent(Environment env, Memory ... args) {
        return new StringMemory(this.file.getParent());
    }

    @Reflection.Signature
    public Memory getPath(Environment env, Memory ... args) {
        return new StringMemory(this.file.getPath());
    }

    @Reflection.Signature
    public Memory getAbsoluteFile(Environment env, Memory ... args) {
        FileObject fo = new FileObject(env, this.__class__);
        fo.file = this.file.getAbsoluteFile();
        return new ObjectMemory(fo);
    }

    @Reflection.Signature
    public Memory getCanonicalFile(Environment env, Memory ... args) {
        FileObject fo = new FileObject(env, this.__class__);
        try {
            fo.file = this.file.getCanonicalFile();
        }
        catch (IOException e) {
            this.exception(env, e.getMessage(), new Object[0]);
            return Memory.NULL;
        }
        return new ObjectMemory(fo);
    }

    @Reflection.Signature
    public Memory getParentFile(Environment env, Memory ... args) {
        if (this.file.getParentFile() == null) {
            return Memory.NULL;
        }
        FileObject fo = new FileObject(env, this.__class__);
        fo.file = this.file.getParentFile();
        return new ObjectMemory(fo);
    }

    @Reflection.Signature
    public Memory mkdir(Environment env, Memory ... args) {
        return this.file.mkdir() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory mkdirs(Environment env, Memory ... args) {
        return this.file.mkdirs() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isFile(Environment env, Memory ... args) {
        return this.file.isFile() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isDirectory(Environment env, Memory ... args) {
        return this.file.isDirectory() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isAbsolute(Environment env, Memory ... args) {
        return this.file.isAbsolute() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isHidden(Environment env, Memory ... args) {
        return this.file.isHidden() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory delete(Environment env, Memory ... args) {
        return this.file.delete() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory deleteOnExit(Environment env, Memory ... args) {
        this.file.deleteOnExit();
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="withDirs", optional=@Reflection.Optional(value="false"))})
    public Memory createNewFile(Environment env, Memory ... args) {
        try {
            if (args[0].toBoolean() && !this.file.getParentFile().mkdirs()) {
                return Memory.FALSE;
            }
            return this.file.createNewFile() ? Memory.TRUE : Memory.FALSE;
        }
        catch (IOException e) {
            this.exception(env, e.getMessage(), new Object[0]);
            return Memory.FALSE;
        }
    }

    @Reflection.Signature
    public Memory lastModified(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.file.lastModified());
    }

    @Reflection.Signature
    public Memory length(Environment env, Memory ... args) {
        try {
            return LongMemory.valueOf(this.file.length());
        }
        catch (Exception e) {
            return Memory.FALSE;
        }
    }

    @Reflection.Signature
    public Memory crc32(Environment env, Memory ... args) {
        CRC32 crcMaker = new CRC32();
        byte[] buffer = new byte[1024];
        try {
            int len;
            FileInputStream is = new FileInputStream(this.file);
            while ((len = is.read(buffer)) > 0) {
                crcMaker.update(buffer, 0, len);
            }
            is.close();
            return LongMemory.valueOf(crcMaker.getValue());
        }
        catch (FileNotFoundException e) {
            return Memory.NULL;
        }
        catch (IOException e) {
            return Memory.NULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflection.Signature(value={@Reflection.Arg(value="algorithm", optional=@Reflection.Optional(value="MD5")), @Reflection.Arg(value="progress", type=HintType.CALLABLE, optional=@Reflection.Optional(value="null"))})
    public Memory hash(Environment env, Memory ... args) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(args[0].toString());
        Invoker invoker = Invoker.valueOf(env, null, args[1]);
        byte[] buffer = new byte[8192];
        try {
            int sum = 0;
            try (FileInputStream is = new FileInputStream(this.file);){
                int len;
                while ((len = is.read(buffer)) > 0) {
                    messageDigest.update(buffer, 0, len);
                    if (invoker == null || invoker.callAny(sum += len, len).toValue() != Memory.FALSE) continue;
                    break;
                }
            }
            return StringMemory.valueOf(DigestUtils.bytesToHex(messageDigest.digest()));
        }
        catch (FileNotFoundException e) {
            return Memory.NULL;
        }
        catch (IOException e) {
            return Memory.NULL;
        }
    }

    @Reflection.Signature(value={@Reflection.Arg(value="newName")})
    public Memory renameTo(Environment env, Memory ... args) {
        return this.file.renameTo(new File(args[0].toString())) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="value"), @Reflection.Arg(value="ownerOnly", optional=@Reflection.Optional(value="1", type=HintType.BOOLEAN))})
    public Memory setExecutable(Environment env, Memory ... args) {
        return this.file.setExecutable(args[0].toBoolean(), args[1].toBoolean()) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="value"), @Reflection.Arg(value="ownerOnly", optional=@Reflection.Optional(value="1", type=HintType.BOOLEAN))})
    public Memory setReadable(Environment env, Memory ... args) {
        return this.file.setReadable(args[0].toBoolean(), args[1].toBoolean()) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="value"), @Reflection.Arg(value="ownerOnly", optional=@Reflection.Optional(value="1", type=HintType.BOOLEAN))})
    public Memory setWritable(Environment env, Memory ... args) {
        return this.file.setWritable(args[0].toBoolean(), args[1].toBoolean()) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory setReadOnly(Environment env, Memory ... args) {
        return this.file.setReadOnly() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="time")})
    public Memory setLastModified(Environment env, Memory ... args) {
        return this.file.setLastModified(args[0].toLong()) ? Memory.TRUE : Memory.FALSE;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Reflection.Signature(value={@Reflection.Arg(value="file")})
    public Memory compareTo(Environment env, Memory ... args) {
        File what;
        if (!args[0].isObject()) {
            what = new File(args[0].toString());
            return LongMemory.valueOf(this.file.compareTo(what));
        }
        if (args[0].instanceOf("php\\io\\File")) {
            FileObject fileObject = (FileObject)args[0].toValue(ObjectMemory.class).value;
            what = fileObject.file;
            return LongMemory.valueOf(this.file.compareTo(what));
        }
        this.exception(env, "Argument 1 must be an instance of %s", "php\\io\\File");
        return Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="filter", optional=@Reflection.Optional(value="NULL"))})
    public Memory find(final Environment env, Memory ... args) {
        if (args[0].isNull()) {
            return ArrayMemory.ofStrings(this.file.list()).toConstant();
        }
        final Invoker invoker = Invoker.valueOf(env, null, args[0]);
        if (invoker == null) {
            this.exception(env, "Invalid filter value, must be callable", new Object[0]);
            return Memory.NULL;
        }
        TraceInfo trace = env.trace();
        invoker.setTrace(trace);
        String[] result = this.file.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                FileObject o = new FileObject(env, FileObject.this.__class__, dir);
                Memory[] args = new Memory[]{new ObjectMemory(o), new StringMemory(name)};
                return invoker.callNoThrow(args).toBoolean();
            }
        });
        return ArrayMemory.ofStrings(result);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="filter", optional=@Reflection.Optional(value="NULL"))})
    public Memory findFiles(final Environment env, Memory ... args) {
        File[] result;
        if (args[0].isNull()) {
            result = this.file.listFiles();
        } else {
            final Invoker invoker = Invoker.valueOf(env, null, args[0]);
            if (invoker == null) {
                this.exception(env, "Invalid filter value, must be callable", new Object[0]);
                return Memory.NULL;
            }
            TraceInfo trace = env.trace();
            invoker.setTrace(trace);
            result = this.file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    FileObject o = new FileObject(env, FileObject.this.__class__, dir);
                    Memory[] args = new Memory[]{new ObjectMemory(o), new StringMemory(name)};
                    return invoker.callNoThrow(args).toBoolean();
                }
            });
        }
        ArrayMemory arr = new ArrayMemory();
        if (result != null) {
            for (File e : result) {
                arr.add(new ObjectMemory(new FileObject(env, this.__class__, e)));
            }
        }
        return arr.toConstant();
    }

    @Reflection.Signature
    public Memory toUrl(Environment env, Memory ... args) throws MalformedURLException {
        return StringMemory.valueOf(this.file.toURI().toURL().toString());
    }

    @Reflection.Signature
    public Memory __toString(Environment env, Memory ... args) {
        return new StringMemory(this.file.getPath());
    }

    @Reflection.Signature(value={@Reflection.Arg(value="prefix"), @Reflection.Arg(value="suffix"), @Reflection.Arg(value="directory", optional=@Reflection.Optional(value="NULL"))})
    public static Memory createTemp(Environment env, Memory ... args) throws IOException {
        File file = args[2].isNull() ? File.createTempFile(args[0].toString(), args[1].toString()) : File.createTempFile(args[0].toString(), args[1].toString(), FileObject.valueOf(args[2]));
        return new ObjectMemory(new FileObject(env, file));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="pattern")})
    public Memory matches(Environment env, Memory ... args) {
        FileSystem aDefault = FileSystems.getDefault();
        PathMatcher pathMatcher = aDefault.getPathMatcher(args[0].toString());
        return pathMatcher.matches(aDefault.getPath(this.file.getPath(), new String[0])) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public static Memory listRoots(Environment env, Memory ... args) {
        ArrayMemory r = new ArrayMemory();
        File[] roots = File.listRoots();
        if (roots == null) {
            return r.toConstant();
        }
        for (File e : roots) {
            r.add(new FileObject(env, e));
        }
        return r.toConstant();
    }

    @Reflection.Signature
    public static File of(String path) {
        return new File(path);
    }

    public static File valueOf(Memory arg) {
        if (arg.instanceOf(FileObject.class)) {
            return arg.toObject(FileObject.class).getFile();
        }
        return new File(arg.toString());
    }
}

