/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.reflection;

import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.ext.core.reflection.ReflectionClass;
import php.runtime.ext.core.reflection.ReflectionException;
import php.runtime.lang.BaseObject;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ConstantEntity;

@Reflection.Name(value="ReflectionClassConstant")
@Reflection.Signature(value={@Reflection.Arg(value="name", type=HintType.STRING, readOnly=true), @Reflection.Arg(value="class", type=HintType.STRING, readOnly=true)})
public class ReflectionClassConstant
extends BaseObject {
    public static final int IS_PUBLIC = 256;
    public static final int IS_PROTECTED = 512;
    public static final int IS_PRIVATE = 1024;
    private ConstantEntity entity;

    public ReflectionClassConstant(Environment env, ConstantEntity constantEntity) {
        super(env);
        this.entity = constantEntity;
        this.setProp("name", constantEntity.getName());
        this.setProp("class", constantEntity.getClazz().getName());
    }

    public ReflectionClassConstant(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="class"), @Reflection.Arg(value="name")})
    public Memory __construct(Environment env, Memory ... args) {
        String className = args[0].toString();
        String constName = args[1].toString();
        this.setProp("class", className);
        this.setProp("name", constName);
        ClassEntity classEntity = env.fetchClass(className);
        this.entity = classEntity.findConstant(constName);
        if (this.entity == null) {
            env.exception(ReflectionException.class, "Class Constant %s::%s does not exist", className, constName);
        }
        return Memory.UNDEFINED;
    }

    @Reflection.Signature
    public String getDocComment() {
        return this.entity.getDocComment() == null ? null : this.entity.getDocComment().toString();
    }

    @Reflection.Signature
    public int getModifiers() {
        int mod = 0;
        if (this.entity.isPrivate()) {
            mod |= 0x400;
        } else if (this.entity.isProtected()) {
            mod |= 0x200;
        } else if (this.entity.isPublic()) {
            mod |= 0x100;
        }
        return mod;
    }

    @Reflection.Signature
    public boolean isPrivate() {
        return this.entity.isPrivate();
    }

    @Reflection.Signature
    public boolean isProtected() {
        return this.entity.isProtected();
    }

    @Reflection.Signature
    public boolean isPublic() {
        return this.entity.isPublic();
    }

    @Reflection.Signature
    public Memory getValue(Environment env) {
        return this.entity.getValue(env).toImmutable();
    }

    @Reflection.Signature
    public ReflectionClass getDeclaringClass(Environment env) {
        ReflectionClass reflectionClass = new ReflectionClass(env);
        reflectionClass.setEntity(this.entity.getClazz());
        return reflectionClass;
    }

    @Reflection.Signature
    public Memory __toString(Environment env, Memory ... args) {
        return StringMemory.valueOf("Constant [ " + this.entity.getModifier().name().toLowerCase() + " " + this.entity.getName() + " ] { " + this.entity.getValue(env).toString() + " }");
    }
}

