/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.lang.spl.iterator;

import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.lang.BaseObject;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.spl.exception.InvalidArgumentException;
import php.runtime.lang.spl.iterator.Iterator;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="MultipleIterator")
public class MultipleIterator
extends BaseObject
implements Iterator {
    public static final int MIT_NEED_ANY = 0;
    public static final int MIT_NEED_ALL = 1;
    public static final int MIT_KEYS_NUMERIC = 0;
    public static final int MIT_KEYS_ASSOC = 2;
    protected ArrayMemory iterators = new ArrayMemory();
    protected int flags;

    public MultipleIterator(Environment env) {
        super(env);
    }

    public MultipleIterator(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="flags", optional=@Reflection.Optional(value="0"))})
    public Memory __construct(Environment env, Memory ... args) {
        this.flags = args[0].toInteger();
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="iterator", typeClass="Iterator"), @Reflection.Arg(value="info", optional=@Reflection.Optional(value="null"))})
    public Memory attachIterator(Environment env, Memory ... args) {
        Iterator iterator = args[0].toObject(Iterator.class);
        if (!iterator.valid(env, args).toBoolean()) {
            env.exception(InvalidArgumentException.class, "Iterator is not valid", new Object[0]);
        }
        if (args[1].isNull()) {
            this.iterators.add(args[0]);
        } else {
            if (this.iterators.get(args[1]) != null) {
                env.exception(InvalidArgumentException.class, "Iterator '" + args[1] + "' already exists", new Object[0]);
            }
            this.iterators.refOfIndex(args[1]).assign(args[0]);
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory countIterators(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.iterators.size());
    }

    @Reflection.Signature
    public Memory getFlags(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.flags);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="flags")})
    public Memory setFlags(Environment env, Memory ... args) {
        this.flags = args[0].toInteger();
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory current(Environment env, Memory ... args) {
        if (this.iterators.size() == 0) {
            return Memory.FALSE;
        }
        ArrayMemory result = new ArrayMemory();
        ForeachIterator iterator = this.iterators.getNewIterator(env);
        while (iterator.next()) {
            Iterator el = iterator.getValue().toObject(Iterator.class);
            if (env.invokeMethodNoThrow(el, "valid", new Memory[0]).toBoolean()) {
                Memory current = env.invokeMethodNoThrow(el, "current", new Memory[0]);
                if ((this.flags & 2) == 2) {
                    result.put(iterator.getKey(), current);
                    continue;
                }
                result.add(current);
                continue;
            }
            if ((this.flags & 1) != 1) continue;
            env.exception(InvalidArgumentException.class, "One of iterators is not valid", new Object[0]);
        }
        return result.toConstant();
    }

    @Override
    @Reflection.Signature
    public Memory key(Environment env, Memory ... args) {
        return this.current(env, args);
    }

    @Override
    @Reflection.Signature
    public Memory next(Environment env, Memory ... args) {
        for (Memory el : this.iterators) {
            env.invokeMethodNoThrow(el.toObject(Iterator.class), "next", new Memory[0]);
        }
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory rewind(Environment env, Memory ... args) {
        for (Memory el : this.iterators) {
            env.invokeMethodNoThrow(el.toObject(Iterator.class), "rewind", new Memory[0]);
        }
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory valid(Environment env, Memory ... args) {
        for (Memory el : this.iterators) {
            if (env.invokeMethodNoThrow(el.toObject(Iterator.class), "valid", new Memory[0]).toBoolean()) {
                if ((this.flags & 1) == this.flags) continue;
                return Memory.TRUE;
            }
            if ((this.flags & 1) != this.flags) continue;
            return Memory.FALSE;
        }
        return Memory.TRUE;
    }

    @Override
    public ForeachIterator getNewIterator(Environment env, boolean getReferences, boolean getKeyReferences) {
        return ObjectMemory.valueOf(this).getNewIterator(env, getReferences, getKeyReferences);
    }

    @Override
    public ForeachIterator getNewIterator(Environment env) {
        return ObjectMemory.valueOf(this).getNewIterator(env);
    }
}

