/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.loader.dump;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import php.runtime.common.LangMode;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.loader.dump.ClassDumper;
import php.runtime.loader.dump.ClosureDumper;
import php.runtime.loader.dump.ConstantDumper;
import php.runtime.loader.dump.Dumper;
import php.runtime.loader.dump.FunctionDumper;
import php.runtime.loader.dump.GeneratorDumper;
import php.runtime.loader.dump.io.DumpException;
import php.runtime.loader.dump.io.DumpInputStream;
import php.runtime.loader.dump.io.DumpOutputStream;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ConstantEntity;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.ModuleEntity;
import php.runtime.reflection.helper.ClosureEntity;
import php.runtime.reflection.helper.GeneratorEntity;
import php.runtime.reflection.support.Entity;

public class ModuleDumper
extends Dumper<ModuleEntity> {
    public static final int DUMP_STAMP = 479873682;
    public static final int DUMP_VERSION = 20141011;
    protected ConstantDumper constantDumper;
    protected ClosureDumper closureDumper;
    protected FunctionDumper functionDumper;
    protected ClassDumper classDumper;
    protected GeneratorDumper generatorDumper;

    public ModuleDumper(Context context, Environment env, boolean debugInformation) {
        super(context, env, debugInformation);
        this.constantDumper = new ConstantDumper(this.context, this.env, this.debugInformation);
        this.closureDumper = new ClosureDumper(this.context, this.env, this.debugInformation);
        this.functionDumper = new FunctionDumper(this.context, this.env, this.debugInformation);
        this.classDumper = new ClassDumper(this.context, null, this.env, this.debugInformation);
        this.generatorDumper = new GeneratorDumper(this.context, this.env, this.debugInformation);
    }

    @Override
    public void setIncludeData(boolean includeData) {
        super.setIncludeData(includeData);
        this.constantDumper.setIncludeData(includeData);
        this.closureDumper.setIncludeData(includeData);
        this.functionDumper.setIncludeData(includeData);
        this.classDumper.setIncludeData(includeData);
        this.generatorDumper.setIncludeData(includeData);
    }

    @Override
    public int getType() {
        return -1;
    }

    @Override
    public void save(ModuleEntity entity, OutputStream output) throws IOException {
        if (entity.getData() == null) {
            throw new DumpException("Module '" + entity.getName() + "' not compiled");
        }
        DumpOutputStream data = new DumpOutputStream(output);
        data.writeInt(479873682);
        data.writeInt(20141011);
        data.writeEnum(LangMode.DEFAULT);
        data.writeName(entity.getContext().getModuleName());
        data.writeName(entity.getInternalName());
        data.writeBoolean(entity.isStrictTypes());
        data.writeTrace(entity.getTrace());
        data.writeInt(entity.getConstants().size());
        for (ConstantEntity constantEntity : entity.getConstants()) {
            this.constantDumper.save(constantEntity, output);
        }
        data.writeInt(entity.getClosures().size());
        for (ClosureEntity closureEntity : entity.getClosures()) {
            this.closureDumper.save(closureEntity, output);
        }
        data.writeInt(entity.getGenerators().size());
        for (GeneratorEntity generatorEntity : entity.getGenerators()) {
            this.generatorDumper.save(generatorEntity, output);
        }
        data.writeInt(entity.getFunctions().size());
        for (FunctionEntity functionEntity : entity.getFunctions()) {
            this.functionDumper.save(functionEntity, output);
        }
        data.writeInt(entity.getClasses().size());
        for (ClassEntity classEntity : entity.getClasses()) {
            this.classDumper.save(classEntity, output);
        }
        if (this.includeData) {
            data.writeInt(entity.getData().length);
            data.write(entity.getData());
        } else {
            data.writeInt(0);
        }
        data.writeRawData(null, 0x500000);
    }

    @Override
    public ModuleEntity load(InputStream input) throws IOException {
        Entity el;
        int i;
        DumpInputStream data = new DumpInputStream(input);
        int STAMP = data.readInt();
        if (STAMP != 479873682) {
            throw new DumpException("Invalid file format");
        }
        int VERSION = data.readInt();
        if (VERSION != 20141011) {
            throw new DumpException("Invalid dump version - " + VERSION + ", only " + 20141011);
        }
        data.readLangMode();
        ModuleEntity entity = new ModuleEntity(this.context);
        entity.setName(data.readName());
        entity.setInternalName(data.readName());
        entity.setStrictTypes(data.readBoolean());
        entity.setTrace(data.readTrace(this.context));
        int count = data.readInt();
        for (i = 0; i < count; ++i) {
            el = this.constantDumper.load(input);
            ((ConstantEntity)el).setModule(entity);
            entity.addConstant((ConstantEntity)el);
        }
        count = data.readInt();
        for (i = 0; i < count; ++i) {
            el = this.closureDumper.load(input);
            ((ClassEntity)el).setModule(entity);
            entity.addClosure((ClosureEntity)el);
        }
        count = data.readInt();
        for (i = 0; i < count; ++i) {
            el = this.generatorDumper.load(input);
            ((ClassEntity)el).setModule(entity);
            entity.addGenerator((GeneratorEntity)el);
        }
        count = data.readInt();
        for (i = 0; i < count; ++i) {
            el = this.functionDumper.load(input);
            ((FunctionEntity)el).setModule(entity);
            entity.addFunction((FunctionEntity)el);
        }
        count = data.readInt();
        ClassDumper classDumper = new ClassDumper(this.context, entity, this.env, this.debugInformation);
        for (int i2 = 0; i2 < count; ++i2) {
            ClassEntity el2 = classDumper.load(input);
            el2.setModule(entity);
            entity.addClass(el2);
        }
        entity.setData(data.readRawData(Integer.MAX_VALUE));
        data.readRawData(0x500000);
        return entity;
    }
}

