/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory.helper;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import php.runtime.Memory;
import php.runtime.memory.ReferenceMemory;

public class ObservableMemory
extends ReferenceMemory {
    private final Vector<Observer> observers = new Vector();
    private final Map<Memory, Observer> observerMap = Collections.synchronizedMap(new LinkedHashMap());

    public ObservableMemory(Memory value) {
        super(value);
    }

    public ObservableMemory() {
        this(Memory.NULL);
    }

    @Override
    public Memory setValue(Memory value) {
        Memory oldValue = this.getValue();
        Memory memory = super.setValue(value);
        if (!value.identical(oldValue)) {
            for (Observer observer : this.observers) {
                observer.update(this, oldValue, value);
            }
        }
        return memory;
    }

    public void addObserver(Observer observer) {
        this.observers.add(observer);
    }

    public void addObserver(Observer observer, Memory key) {
        this.observers.add(observer);
        this.observerMap.put(key, observer);
    }

    public void removeObserver(Observer observer) {
        this.observers.remove(observer);
    }

    public Observer removeObserver(Memory key) {
        Observer observer = this.observerMap.get(key);
        if (observer != null) {
            this.observers.remove(observer);
            this.observerMap.remove(key);
            return observer;
        }
        return null;
    }

    public void clearObservers() {
        this.observers.clear();
        this.observerMap.clear();
    }

    public Set<Memory> observerKeys() {
        return this.observerMap.keySet();
    }

    @Override
    public Memory toImmutable() {
        return this;
    }

    public static interface Observer {
        public void update(ObservableMemory var1, Memory var2, Memory var3);
    }
}

