/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory.output;

import java.io.Writer;
import java.util.Set;
import php.runtime.Memory;
import php.runtime.common.StringUtils;
import php.runtime.env.Environment;
import php.runtime.lang.Closure;
import php.runtime.lang.ForeachIterator;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.output.Printer;
import php.runtime.reflection.ClassEntity;

public class VarExport
extends Printer {
    private static final int PRINT_INDENT = 2;

    public VarExport(Environment env, Writer writer) {
        super(env, writer);
    }

    @Override
    protected void printNull() {
        this.printer.append("NULL");
    }

    @Override
    protected void printFalse() {
        this.printer.append("false");
    }

    @Override
    protected void printTrue() {
        this.printer.append("true");
    }

    @Override
    protected void printLong(LongMemory value) {
        this.printer.print(value.toLong() + "");
    }

    @Override
    protected void printDouble(DoubleMemory value) {
        this.printer.print(value.toDouble() + "");
    }

    @Override
    protected void printString(StringMemory value) {
        String v = value.toString();
        int length = v.length();
        this.printer.append('\'');
        for (int i = 0; i < length; ++i) {
            char ch = v.charAt(i);
            if (ch == '\'') {
                this.printer.append("\\'");
                continue;
            }
            if (ch == '\u0000') {
                this.printer.append("' . \"\\0\" . '");
                continue;
            }
            this.printer.append(ch);
        }
        this.printer.append('\'');
    }

    @Override
    protected void printArray(ArrayMemory value, int level, Set<Integer> used) {
        this.printArray(value, level, used, false);
    }

    protected void printArray(ArrayMemory value, int level, Set<Integer> used, boolean stripNulls) {
        if (!used.add(value.getPointer())) {
            this.recursionExists = true;
            this.printNull();
        } else {
            this.printer.write(StringUtils.repeat(' ', level * 2));
            this.printer.write("array (\n");
            ForeachIterator iterator = value.foreachIterator(false, false);
            ++level;
            while (iterator.next()) {
                Memory el = iterator.getValue();
                if (el == Memory.UNDEFINED) continue;
                this.printer.write(StringUtils.repeat(' ', level * 2));
                Memory key = iterator.getMemoryKey();
                if (key.isString()) {
                    int pos;
                    String k = key.toString();
                    if (stripNulls && (pos = k.lastIndexOf(0)) > -1) {
                        k = k.substring(pos + 1);
                    }
                    this.printString(new StringMemory(k));
                } else {
                    this.printer.write(key.toString());
                }
                this.printer.write(" =>");
                if (el.isArray()) {
                    if (!used.contains(el.getPointer())) {
                        this.printer.write("\n");
                    } else {
                        this.printer.write(" ");
                    }
                    this.print(el, level, used);
                } else {
                    this.printer.write(" ");
                    this.print(el, level + 1, used);
                }
                this.printer.append(",\n");
            }
            this.printer.write(StringUtils.repeat(' ', --level * 2));
            this.printer.append(")");
            used.remove(value.getPointer());
        }
    }

    @Override
    protected void printObject(ObjectMemory value, int level, Set<Integer> used) {
        if (used.contains(value.getPointer())) {
            this.recursionExists = true;
            this.printNull();
        } else {
            used.add(value.getPointer());
            ClassEntity entity = value.getReflection();
            this.printer.write(entity.getName());
            this.printer.write("::");
            this.printer.write("__set_state(");
            this.printArray(value.value.getProperties(), 0, used, true);
            this.printer.write(")");
            used.remove(value.getPointer());
        }
    }

    @Override
    protected void printClosure(Closure value, int level, Set<Integer> used) {
        this.printObject(new ObjectMemory(value), level, used);
    }
}

