/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory.support;

import java.io.ByteArrayOutputStream;
import php.runtime.Memory;
import php.runtime.memory.support.MemoryStringUtils;

public class BinaryStringBuilder {
    private ByteArrayOutputStream buffer;

    public BinaryStringBuilder(int size) {
        this.buffer = new ByteArrayOutputStream(size);
    }

    public BinaryStringBuilder() {
        this.buffer = new ByteArrayOutputStream();
    }

    public BinaryStringBuilder(String initValue) {
        this(initValue.length());
        this.append(MemoryStringUtils.getBinaryBytes(initValue));
    }

    public BinaryStringBuilder(Memory initValue) {
        this(initValue.toString());
    }

    public void append(byte[] bytes, int off, int len) {
        this.buffer.write(bytes, off, len);
    }

    public void append(byte[] bytes) {
        this.append(bytes, 0, bytes.length);
    }

    public void append(Memory value) {
        this.append(value.getBinaryBytes());
    }

    public void appendString(String value) {
        this.append(value.getBytes());
    }

    public void appendChar(char ch) {
        this.appendString(String.valueOf(ch));
    }

    public void append(byte b) {
        this.buffer.write(b);
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public String toString() {
        return this.buffer.toString();
    }
}

