/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.reflection;

import java.lang.reflect.Field;
import php.runtime.Memory;
import php.runtime.common.Modifier;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.CriticalException;
import php.runtime.memory.support.MemoryOperation;
import php.runtime.reflection.PropertyEntity;

public class CompilePropertyEntity
extends PropertyEntity {
    protected final Field field;
    protected MemoryOperation operation;

    public CompilePropertyEntity(Context context, Field field) {
        super(context);
        this.field = field;
        this.field.setAccessible(true);
        this.setModifier(Modifier.PUBLIC);
        if (java.lang.reflect.Modifier.isProtected(field.getModifiers())) {
            this.setModifier(Modifier.PROTECTED);
        } else if (java.lang.reflect.Modifier.isPrivate(field.getModifiers())) {
            throw new CriticalException("Unsupported bind private fields: " + field.toGenericString());
        }
        this.operation = MemoryOperation.get(field.getType(), field.getGenericType());
        if (this.operation == null) {
            throw new CriticalException("Unsupported type for field " + field.toGenericString());
        }
        this.setStatic(java.lang.reflect.Modifier.isStatic(field.getModifiers()));
    }

    @Override
    public Memory assignValue(Environment env, TraceInfo trace, Object object, String name, Memory value) {
        try {
            this.field.set(object, this.operation.convertNoThrow(env, trace, value));
        }
        catch (IllegalAccessException e) {
            throw new CriticalException(e);
        }
        return value;
    }

    @Override
    public Memory getStaticValue(Environment env, TraceInfo trace) {
        try {
            return this.operation.unconvertNoThow(env, trace, this.field.get(null));
        }
        catch (IllegalAccessException e) {
            throw new CriticalException(e);
        }
    }

    @Override
    public Memory getValue(Environment env, TraceInfo trace, Object object) {
        try {
            return this.operation.unconvertNoThow(env, trace, this.field.get(object));
        }
        catch (IllegalAccessException e) {
            throw new CriticalException(e);
        }
    }
}

