/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.reflection.helper;

import java.lang.reflect.InvocationTargetException;
import php.runtime.Memory;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.exceptions.CriticalException;
import php.runtime.lang.Closure;
import php.runtime.memory.ObjectMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ParameterEntity;
import php.runtime.reflection.helper.GeneratorEntity;

public class ClosureEntity
extends ClassEntity {
    protected boolean returnReference;
    public ParameterEntity[] parameters;
    public ParameterEntity[] uses;
    protected ObjectMemory singleton;
    protected GeneratorEntity generatorEntity;

    public ClosureEntity(Context context) {
        super(context);
        this.setName(Closure.class.getSimpleName());
        this.setType(ClassEntity.Type.CLOSURE);
    }

    public boolean isReturnReference() {
        return this.returnReference;
    }

    @Override
    public boolean isHiddenInCallStack() {
        return true;
    }

    public void setReturnReference(boolean returnReference) {
        this.returnReference = returnReference;
    }

    public void setParameters(ParameterEntity[] parameters) {
        this.parameters = parameters;
    }

    public void setUses(ParameterEntity[] uses) {
        this.uses = uses;
    }

    @Deprecated
    public ObjectMemory getSingleton() {
        return this.getSingleton(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMemory getSingleton(String selfContextClass) {
        if (this.singleton != null) {
            return this.singleton;
        }
        ClosureEntity closureEntity = this;
        synchronized (closureEntity) {
            if (this.singleton == null) {
                try {
                    this.singleton = new ObjectMemory((Closure)this.nativeConstructor.newInstance(null, this, Memory.NULL, selfContextClass, null));
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new CriticalException(e);
                }
                catch (InvocationTargetException e) {
                    throw new CriticalException(e.getTargetException());
                }
            }
        }
        return this.singleton;
    }

    @Override
    public String getName() {
        return this.parent.getName();
    }

    @Override
    public String getLowerName() {
        return this.parent == null ? super.getLowerName() : this.parent.getLowerName();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof ClosureEntity;
    }

    @Override
    public void setNativeClazz(Class<?> nativeClazz) {
        this.nativeClazz = nativeClazz;
        if (!nativeClazz.isInterface()) {
            try {
                this.nativeConstructor = nativeClazz.getConstructor(Environment.class, ClassEntity.class, Memory.class, String.class, Memory[].class);
                this.nativeConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new CriticalException(e);
            }
        }
    }

    public GeneratorEntity getGeneratorEntity() {
        return this.generatorEntity;
    }

    public void setGeneratorEntity(GeneratorEntity generatorEntity) {
        this.generatorEntity = generatorEntity;
    }
}

