/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.reflection.support;

import java.lang.annotation.Annotation;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.memory.ObjectMemory;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static String getClassName(Class<?> clazz) {
        Reflection.Name name = clazz.getAnnotation(Reflection.Name.class);
        String result = name == null ? clazz.getSimpleName() : name.value();
        Reflection.Namespace namespace = clazz.getAnnotation(Reflection.Namespace.class);
        if (namespace != null) {
            result = namespace.value() + "\\" + result;
        }
        return result;
    }

    public static String getGivenName(Memory value) {
        if (value.isObject()) {
            return "an instance of " + value.toValue(ObjectMemory.class).getReflection().getName();
        }
        return value.getRealType().toString();
    }

    public static <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> annotationClass) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().equals(annotationClass)) continue;
            return (T)annotation;
        }
        return null;
    }
}

