/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.game.support;

import java.util.HashMap;
import java.util.Map;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class Sprite {
    public final Map<String, Animation> animations = new HashMap<String, Animation>();
    protected Image image;
    protected Double frameWidth;
    protected Double frameHeight;
    private int rows = 0;
    private int cols = 0;
    private int maxIndex = -1;
    private int speed = 12;
    private int currentIndex = -1;
    private Animation currentAnimation = null;
    private boolean cycledAnimation = true;
    private boolean freeze = false;
    private boolean flipX = false;
    private boolean flipY = false;
    private Sprite prototype;

    public Sprite() {
    }

    public Sprite(Sprite sprite) {
        this();
        if (sprite == null) {
            return;
        }
        if (sprite.prototype != null) {
            sprite = sprite.prototype;
        }
        this.image = sprite.image;
        this.frameWidth = sprite.frameWidth;
        this.frameHeight = sprite.frameHeight;
        this.flipX = sprite.flipX;
        this.flipY = sprite.flipY;
        this.speed = sprite.speed;
        this.cycledAnimation = sprite.cycledAnimation;
        this.rows = -1;
        this.cols = -1;
        this.maxIndex = -1;
        this.currentAnimation = sprite.currentAnimation;
        this.prototype = sprite;
    }

    public int getMaxIndex() {
        return this.prototype != null ? this.prototype.maxIndex : this.maxIndex;
    }

    public void freeze() {
        this.freeze = true;
    }

    public void unfreeze() {
        this.freeze = false;
    }

    public boolean isFreeze() {
        return this.freeze;
    }

    public double getFrameWidth() {
        return this.prototype != null ? this.prototype.frameWidth : this.frameWidth;
    }

    public double getFrameHeight() {
        return this.prototype != null ? this.prototype.frameHeight : this.frameHeight;
    }

    public void setFrameWidth(double frameWidth) {
        if (this.prototype != null) {
            this.prototype.frameWidth = frameWidth;
        } else {
            this.frameWidth = frameWidth;
        }
    }

    public void setFrameHeight(double frameHeight) {
        if (this.prototype != null) {
            this.prototype.frameHeight = frameHeight;
            this.prototype.setImage(this.getImage());
        } else {
            this.frameHeight = frameHeight;
            this.setImage(this.getImage());
        }
    }

    public void setFrameSize(double[] size) {
        if (size != null && size.length >= 2) {
            this.setFrameSize(size[0], size[1]);
        }
    }

    public void setFrameSize(double width, double height) {
        if (this.prototype != null) {
            this.prototype.setFrameSize(width, height);
            this.prototype.setImage(this.getImage());
        } else {
            this.frameWidth = width;
            this.frameHeight = height;
            this.setImage(this.getImage());
        }
    }

    public double[] getFrameSize() {
        if (this.prototype != null) {
            return this.prototype.getFrameSize();
        }
        return new double[]{this.frameWidth, this.frameHeight};
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex;
    }

    public Image getImage() {
        if (this.prototype != null) {
            return this.prototype.image;
        }
        return this.image;
    }

    public void setImage(Image image) {
        if (this.prototype != null) {
            this.prototype.setImage(image);
            return;
        }
        this.image = image;
        if (image != null) {
            double width = image.getWidth();
            double height = image.getHeight();
            if (this.frameWidth == null || this.frameHeight == null) {
                this.maxIndex = 1;
                this.cols = 1;
                this.rows = 1;
                this.setFrameSize(width, height);
            } else {
                this.cols = (int)Math.floor(width / this.frameWidth);
                this.rows = (int)Math.floor(height / this.frameHeight);
                this.maxIndex = this.cols * this.rows - 1;
            }
        } else {
            this.maxIndex = -1;
            this.cols = -1;
            this.rows = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnimation(String name, int ... indexes) {
        if (this.prototype != null) {
            this.prototype.setAnimation(name, indexes);
            return;
        }
        Map<String, Animation> map = this.animations;
        synchronized (map) {
            this.animations.put(name, new Animation(name, indexes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnimation(String name, int from, int length) {
        if (this.prototype != null) {
            this.prototype.setAnimation(name, from, length);
            return;
        }
        Map<String, Animation> map = this.animations;
        synchronized (map) {
            Animation value = new Animation(name, new int[0]);
            value.setRange(from, from + length + 1);
            this.animations.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAnimationSpeed(String name, int speed) {
        if (this.prototype != null) {
            this.prototype.setAnimationSpeed(name, speed);
            return;
        }
        Map<String, Animation> map = this.animations;
        synchronized (map) {
            if (!this.animations.containsKey(name)) {
                this.setAnimation(name, new int[0]);
            }
            this.animations.get(name).setSpeed(speed);
        }
    }

    public boolean isCycledAnimation() {
        return this.cycledAnimation;
    }

    public void setCycledAnimation(boolean cycledAnimation) {
        this.cycledAnimation = cycledAnimation;
    }

    public String getCurrentAnimation() {
        return this.currentAnimation == null ? null : this.currentAnimation.getName();
    }

    public void setCurrentAnimation(String name) {
        Animation animation = this.currentAnimation = this.prototype != null ? this.prototype.animations.get(name) : this.animations.get(name);
        if (this.currentAnimation != null && this.currentAnimation.getSpeed() != -1) {
            this.setSpeed(this.currentAnimation.getSpeed());
        }
        if (name != null && !name.isEmpty() && this.currentAnimation == null) {
            throw new IllegalArgumentException("Animation '" + name + "' not found");
        }
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void play(String animation) {
        this.unfreeze();
        this.setCurrentAnimation(animation);
    }

    public void play(String animation, int speed) {
        this.unfreeze();
        this.setCurrentAnimation(animation);
        this.setSpeed(speed);
    }

    public boolean isFlipX() {
        return this.flipX;
    }

    public void setFlipX(boolean flipX) {
        this.flipX = flipX;
    }

    public boolean isFlipY() {
        return this.flipY;
    }

    public void setFlipY(boolean flipY) {
        this.flipY = flipY;
    }

    public void drawNext(Canvas canvas) {
        ++this.currentIndex;
        if (this.currentIndex > this.maxIndex) {
            this.currentIndex = 0;
        }
        this.draw(canvas, this.currentIndex);
    }

    public void drawByTime(Canvas canvas, long now) {
        int maxIndex;
        int n = maxIndex = this.prototype == null ? this.maxIndex : this.prototype.maxIndex;
        if (this.freeze || maxIndex < 1) {
            return;
        }
        int drawIndex = -1;
        if (this.currentAnimation != null) {
            if (this.speed <= 0) {
                drawIndex = this.currentAnimation.indexes[this.currentIndex];
            } else {
                int newIndex = (int)Math.floor((now - (long)this.currentIndex) / (long)(1000000000 / this.speed));
                drawIndex = this.currentAnimation.indexes[newIndex %= this.currentAnimation.getMax() + 1];
            }
            if (drawIndex >= 0) {
                boolean last = drawIndex < this.currentIndex;
                this.draw(canvas, drawIndex);
                if (!this.cycledAnimation && last) {
                    this.freeze();
                }
            }
        } else {
            if (this.speed <= 0) {
                drawIndex = this.currentIndex;
            } else {
                int newIndex = (int)Math.floor((now - (long)this.currentIndex) / (long)(1000000000 / this.speed));
                drawIndex = newIndex % (maxIndex + 1);
            }
            if ((this.cycledAnimation || this.currentIndex == -1 || this.currentIndex < drawIndex) && drawIndex >= 0) {
                this.draw(canvas, drawIndex);
            }
        }
    }

    public void draw(Canvas node, int index) {
        Image image;
        if (this.freeze) {
            return;
        }
        this.currentIndex = index;
        GraphicsContext gc = node.getGraphicsContext2D();
        gc.setFill((Paint)Color.TRANSPARENT);
        gc.clearRect(0.0, 0.0, node.getWidth(), node.getHeight());
        double frameWidth = this.getFrameWidth();
        double frameHeight = this.getFrameHeight();
        int maxIndex = this.prototype != null ? this.prototype.maxIndex : this.maxIndex;
        Image image2 = image = this.prototype != null ? this.prototype.image : this.image;
        if (image == null || frameHeight < 0.1 || frameWidth < 0.1 || index > maxIndex || index < 0) {
            return;
        }
        int cols = this.prototype != null ? this.prototype.cols : this.cols;
        int row = index / cols;
        int col = index % cols;
        double x = (double)col * frameWidth;
        double y = (double)row * frameHeight;
        gc.drawImage(image, x, y, frameWidth, frameHeight, this.flipX ? frameWidth : 0.0, this.flipY ? frameHeight : 0.0, frameWidth * (double)(this.flipX ? -1 : 1), frameHeight * (double)(this.flipY ? -1 : 1));
    }

    public Image getFrameImage(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index must be greater or equal to zero");
        }
        if (index > this.maxIndex) {
            throw new IllegalArgumentException("index must be smaller or equal to " + this.maxIndex);
        }
        double w = this.frameWidth == null ? 0.0 : this.frameWidth;
        double h = this.frameHeight == null ? 0.0 : this.frameHeight;
        Canvas canvas = new Canvas(w, h);
        this.draw(canvas, index);
        SnapshotParameters parameters = new SnapshotParameters();
        parameters.setFill((Paint)Color.TRANSPARENT);
        return canvas.snapshot(parameters, null);
    }

    public static class Animation {
        protected String name;
        protected int[] indexes;
        protected int speed = -1;

        public Animation(String name, int ... indexes) {
            this.name = name;
            this.indexes = indexes;
        }

        public void setIndexes(int ... indexes) {
            this.indexes = indexes;
        }

        public void setRange(int from, int to) {
            int len = to - from;
            this.indexes = new int[len];
            for (int i = 0; i < len; ++i) {
                this.indexes[i] = i + from;
            }
        }

        public int getMax() {
            return this.indexes.length - 1;
        }

        public int getSpeed() {
            return this.speed;
        }

        public void setSpeed(int speed) {
            this.speed = speed;
        }

        public String getName() {
            return this.name;
        }
    }
}

