/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement.expr;

import org.develnext.jphp.core.compiler.jvm.misc.LocalVariable;
import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseStatementCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.value.ListCompiler;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ListExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.BodyStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ForeachStmtToken;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.FatalException;
import php.runtime.invoke.ObjectInvokeHelper;
import php.runtime.invoke.cache.PropertyCallCache;
import php.runtime.lang.ForeachIterator;

public class ForeachCompiler
extends BaseStatementCompiler<ForeachStmtToken> {
    public ForeachCompiler(ExpressionStmtCompiler exprCompiler) {
        super(exprCompiler);
    }

    @Override
    public void write(ForeachStmtToken token) {
        this.expr.writeDefineVariables(token.getLocal());
        LabelNode start = new LabelNode();
        LabelNode end = new LabelNode();
        LabelNode l = new LabelNode();
        this.add((AbstractInsnNode)l);
        this.expr.writePushEnv();
        this.expr.writePushTraceInfo(token);
        this.expr.writeExpression(token.getIterator(), true, false, true);
        this.expr.writePopBoxing();
        this.expr.writePushConstBoolean(token.isValueReference());
        this.expr.writePushConstBoolean(token.isKeyReference());
        this.expr.writeSysDynamicCall(Environment.class, "__getIterator", ForeachIterator.class, TraceInfo.class, Memory.class, Boolean.TYPE, Boolean.TYPE);
        String name = "~foreach~" + this.method.nextStatementIndex(ForeachIterator.class);
        LocalVariable foreachVariable = this.method.getLocalVariable(name);
        if (foreachVariable == null) {
            foreachVariable = this.method.addLocalVariable(name, l, ForeachIterator.class);
        }
        foreachVariable.setEndLabel(end);
        this.expr.writeVarStore(foreachVariable, false, false);
        this.method.pushJump(end, start);
        this.add((AbstractInsnNode)start);
        this.expr.writeVarLoad(foreachVariable);
        this.expr.writeSysDynamicCall(ForeachIterator.class, "next", Boolean.TYPE, new Class[0]);
        this.add((AbstractInsnNode)new JumpInsnNode(153, end));
        this.expr.stackPop();
        if (token.getKey() != null) {
            LocalVariable key = this.method.getLocalVariable(token.getKey().getName());
            this.expr.checkAssignableVar(token.getKey());
            this.expr.writeVarLoad(foreachVariable);
            this.expr.writeSysDynamicCall(ForeachIterator.class, "getMemoryKey", Memory.class, new Class[0]);
            if (token.isKeyReference()) {
                throw new FatalException("Key element cannot be a reference", token.getKey().toTraceInfo(this.compiler.getContext()));
            }
            this.expr.writeVarAssign(key, null, false, false);
        }
        Token last = token.getValue().getLast();
        VariableExprToken var = null;
        if (last instanceof DynamicAccessExprToken) {
            DynamicAccessExprToken setter = (DynamicAccessExprToken)last;
            ExprStmtToken value = new ExprStmtToken(this.env, this.compiler.getContext(), token.getValue().getTokens());
            value.getTokens().remove(value.getTokens().size() - 1);
            value.updateAsmExpr(this.env, this.compiler.getContext());
            this.expr.writeExpression(value, true, false);
            this.expr.writeVarLoad(foreachVariable);
            this.expr.writeSysDynamicCall(ForeachIterator.class, "getValue", Memory.class, new Class[0]);
            if (!token.isValueReference()) {
                this.expr.writePopImmutable();
            }
            this.expr.writeDynamicAccessInfo(setter, false);
            this.expr.writeGetStatic("$CALL_PROP_CACHE", PropertyCallCache.class);
            this.expr.writePushConstInt(this.method.clazz.getAndIncCallPropCount());
            this.expr.writeSysStaticCall(ObjectInvokeHelper.class, "assignProperty", Memory.class, Memory.class, Memory.class, String.class, Environment.class, TraceInfo.class, PropertyCallCache.class, Integer.TYPE);
        } else {
            ExprStmtToken value;
            if (token.getValue().getSingle() instanceof VariableExprToken) {
                var = (VariableExprToken)token.getValue().getSingle();
                this.expr.checkAssignableVar(var);
            }
            this.expr.writeVarLoad(foreachVariable);
            this.expr.writeSysDynamicCall(ForeachIterator.class, "getValue", Memory.class, new Class[0]);
            if (!token.isValueReference()) {
                this.expr.writePopImmutable();
            }
            if ((value = token.getValue()).isSingle() && value.getSingle() instanceof ListExprToken) {
                ListCompiler listCompiler = (ListCompiler)this.expr.getCompiler(ListExprToken.class);
                listCompiler.write((ListExprToken)value.getSingle(), false, false);
            } else {
                this.expr.writeExpression(value, true, false);
                if (this.expr.stackPeek().immutable) {
                    this.expr.unexpectedToken(value.getLast());
                }
                this.expr.writeSysStaticCall(Memory.class, token.isValueReference() ? "assignRefRight" : "assignRight", Memory.class, Memory.class, Memory.class);
            }
        }
        this.expr.writePopAll(1);
        this.expr.write(BodyStmtToken.class, token.getBody());
        this.add((AbstractInsnNode)new JumpInsnNode(167, start));
        this.add((AbstractInsnNode)end);
        this.method.popJump();
        this.expr.writeUndefineVariables(token.getLocal());
        this.method.prevStatementIndex(ForeachIterator.class);
    }
}

