/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement.expr.value;

import org.develnext.jphp.core.compiler.jvm.misc.LocalVariable;
import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseExprCompiler;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ListExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.invoke.ObjectInvokeHelper;
import php.runtime.invoke.cache.PropertyCallCache;
import php.runtime.memory.support.MemoryUtils;

public class ListCompiler
extends BaseExprCompiler<ListExprToken> {
    public ListCompiler(ExpressionStmtCompiler exprCompiler) {
        super(exprCompiler);
    }

    @Override
    public void write(ListExprToken list, boolean returnValue) {
        this.write(list, returnValue, true);
    }

    public void write(ListExprToken list, boolean returnValue, boolean writeValue) {
        if (writeValue) {
            this.expr.writeExpression(list.getValue(), true, false);
            this.expr.writePopBoxing();
        }
        int length = list.getVariables().size();
        for (int i = 0; i < length; ++i) {
            ListExprToken.Variable v = list.getVariables().get(i);
            this.expr.writePushDup();
            if (v.indexes != null) {
                for (Object index : v.indexes) {
                    if (index instanceof Integer) {
                        this.expr.writePushConstLong(((Integer)index).intValue());
                    } else {
                        this.expr.writeExpression((ExprStmtToken)index, true, false);
                        switch (this.expr.stackPeek().type) {
                            case INT: 
                            case STRING: {
                                break;
                            }
                            default: {
                                this.expr.writePopBoxing();
                            }
                        }
                    }
                    this.expr.writeSysStaticCall(MemoryUtils.class, "valueForList", Memory.class, Memory.class, this.expr.stackPeek().type.toClass());
                }
            }
            if (v.isWithKey()) {
                this.expr.writeExpression(v.exprIndex, true, false);
                switch (this.expr.stackPeek().type) {
                    case INT: 
                    case STRING: {
                        break;
                    }
                    default: {
                        this.expr.writePopBoxing();
                        break;
                    }
                }
            } else {
                this.expr.writePushConstLong(v.index);
            }
            this.expr.writeSysStaticCall(MemoryUtils.class, "valueForList", Memory.class, Memory.class, this.expr.stackPeek().type.toClass());
            if (v.isVariable()) {
                LocalVariable variable = this.method.getLocalVariable(v.getVariableName());
                this.expr.writeVarAssign(variable, (VariableExprToken)v.var.getSingle(), false, true);
                continue;
            }
            if (v.isArray() || v.isStaticProperty() || v.isArrayPush()) {
                this.expr.writeExpression(v.var, true, false);
                if (this.expr.stackPeek().immutable || this.expr.stackPeek().isConstant()) {
                    this.expr.unexpectedToken(v.var.getSingle());
                }
                this.expr.writeSysStaticCall(Memory.class, "assignRight", Memory.class, Memory.class, Memory.class);
                this.expr.writePopAll(1);
                continue;
            }
            if (!v.isDynamicProperty()) continue;
            DynamicAccessExprToken dynamic = (DynamicAccessExprToken)v.var.getLast();
            ExprStmtToken var = new ExprStmtToken(this.env, this.compiler.getContext(), v.var.getTokens());
            var.getTokens().remove(var.getTokens().size() - 1);
            var.updateAsmExpr(this.env, this.compiler.getContext());
            this.expr.writeDynamicAccessInfo(dynamic, false);
            this.expr.writeExpression(var, true, false);
            this.expr.writePopBoxing(false);
            this.expr.writeGetStatic("$CALL_PROP_CACHE", PropertyCallCache.class);
            this.expr.writePushConstInt(this.method.clazz.getAndIncCallPropCount());
            this.expr.writeSysStaticCall(ObjectInvokeHelper.class, "assignPropertyRight", Memory.class, Memory.class, String.class, Environment.class, TraceInfo.class, Memory.class, PropertyCallCache.class, Integer.TYPE);
            this.expr.writePopAll(1);
        }
        if (!returnValue) {
            this.expr.writePopAll(1);
        }
    }
}

