/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.syntax.generators;

import java.util.ListIterator;
import org.develnext.jphp.core.syntax.SyntaxAnalyzer;
import org.develnext.jphp.core.tokenizer.token.BreakToken;
import org.develnext.jphp.core.tokenizer.token.CommentToken;
import org.develnext.jphp.core.tokenizer.token.SemicolonToken;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.BraceExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import php.runtime.common.Messages;
import php.runtime.exceptions.support.ErrorType;

public abstract class Generator<T extends Token> {
    protected final SyntaxAnalyzer analyzer;

    public Generator(SyntaxAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    public boolean isAutomatic() {
        return true;
    }

    public boolean isSingleton() {
        return true;
    }

    protected void unexpectedToken(ListIterator<Token> iterator) {
        this.unexpectedToken(iterator.previous());
    }

    protected void unexpectedToken(Token token) {
        this.analyzer.getEnvironment().error(token.toTraceInfo(this.analyzer.getContext()), ErrorType.E_PARSE, Messages.ERR_PARSE_UNEXPECTED_X.fetch(new Object[]{token.getWord()}), new Object[0]);
    }

    protected void unexpectedToken(Token token, Object expected) {
        this.unexpectedToken(token, expected, true);
    }

    protected void unexpectedToken(Token token, Object expected, boolean quotes) {
        this.analyzer.getEnvironment().error(token.toTraceInfo(this.analyzer.getContext()), ErrorType.E_PARSE, quotes ? Messages.ERR_PARSE_UNEXPECTED_X_EXPECTED_Y.fetch(new Object[]{token.getWord(), expected}) : Messages.ERR_PARSE_UNEXPECTED_X_EXPECTED_Y_NO_QUOTES.fetch(new Object[]{token.getWord(), expected}), new Object[0]);
    }

    protected <K extends Token> K nextAndExpected(ListIterator<Token> iterator, Class<K> clazz) {
        Token next = this.nextToken(iterator);
        if (!this.isTokenClass(next, clazz)) {
            this.unexpectedToken(next);
        }
        return (K)next;
    }

    protected <K extends Token> K nextAndExpectedSensitive(ListIterator<Token> iterator, Class<K> clazz) {
        Token next = this.nextTokenSensitive(iterator, new Class[0]);
        if (!this.isTokenClass(next, clazz)) {
            this.unexpectedToken(next);
        }
        return (K)next;
    }

    protected boolean isTokenClass(Token token, Class<? extends Token> ... classes) {
        if (token == null) {
            return false;
        }
        if (classes == null) {
            return false;
        }
        Class<?> current = token.getClass();
        for (Class<? extends Token> clazz : classes) {
            if (clazz == null || clazz != current && !clazz.isAssignableFrom(current)) continue;
            return true;
        }
        return false;
    }

    protected boolean isOpenedBrace(Token token, BraceExprToken.Kind kind) {
        if (token instanceof BraceExprToken) {
            return ((BraceExprToken)token).isOpened(kind);
        }
        return false;
    }

    protected boolean isClosedBrace(Token token, BraceExprToken.Kind kind) {
        if (token instanceof BraceExprToken) {
            return ((BraceExprToken)token).isClosed(kind);
        }
        return false;
    }

    protected boolean isBreak(Token token) {
        return token instanceof SemicolonToken || token instanceof BreakToken;
    }

    protected boolean isClosedBrace(Token token) {
        if (token instanceof BraceExprToken) {
            return ((BraceExprToken)token).isClosed();
        }
        return false;
    }

    protected void unexpectedEnd(Token token) {
        this.analyzer.getEnvironment().error(token.toTraceInfo(this.analyzer.getContext()), ErrorType.E_PARSE, Messages.ERR_PARSE_UNEXPECTED_END_OF_FILE, new Object[0]);
    }

    protected void checkUnexpectedEnd(ListIterator<Token> iterator) {
        if (!iterator.hasNext()) {
            iterator.previous();
            Token current = iterator.next();
            this.analyzer.getEnvironment().error(current.toTraceInfo(this.analyzer.getContext()), ErrorType.E_PARSE, Messages.ERR_PARSE_UNEXPECTED_END_OF_FILE, new Object[0]);
        }
    }

    protected Token makeSensitive(Token token) {
        if (token instanceof NameToken) {
            return token;
        }
        if (token.isNamedToken()) {
            return new NameToken(token.getMeta());
        }
        return token;
    }

    @SafeVarargs
    protected final Token nextTokenSensitive(ListIterator<Token> iterator, Class<? extends Token> ... excludes) {
        Token token = this.nextToken(iterator);
        if (token instanceof NameToken) {
            return token;
        }
        if (excludes != null && this.isTokenClass(token, excludes)) {
            return token;
        }
        if (token.isNamedToken()) {
            return new NameToken(token.getMeta());
        }
        return token;
    }

    protected Token nextToken(ListIterator<Token> iterator) {
        this.checkUnexpectedEnd(iterator);
        Token tk = iterator.next();
        if (tk instanceof CommentToken) {
            return this.nextToken(iterator);
        }
        return tk;
    }

    protected Token nextTokenAndPrev(ListIterator<Token> iterator) {
        this.checkUnexpectedEnd(iterator);
        Token result = iterator.next();
        if (result instanceof CommentToken) {
            return this.nextTokenAndPrev(iterator);
        }
        iterator.previous();
        return result;
    }

    public abstract T getToken(Token var1, ListIterator<Token> var2);
}

