/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer.token.expr.value;

import java.math.BigInteger;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;
import php.runtime.common.GrammarUtils;

public class IntegerExprToken
extends ValueExprToken {
    private long value;
    private BigInteger bigValue;

    public IntegerExprToken(TokenMeta meta) {
        super(meta, TokenType.T_LNUMBER);
        int offset;
        int radix;
        String word = meta.getWord();
        boolean isNegative = false;
        if (word.charAt(0) == '-') {
            word = word.substring(1);
            isNegative = true;
        }
        if (GrammarUtils.isOctalInteger((String)word)) {
            radix = 8;
            offset = 1;
        } else if (GrammarUtils.isBinaryInteger((String)word)) {
            radix = 2;
            offset = 2;
        } else if (GrammarUtils.isHexInteger((String)word)) {
            radix = 16;
            offset = 2;
        } else {
            block11: {
                try {
                    this.value = Long.parseLong(word);
                    if (isNegative) {
                        this.value = -this.value;
                    }
                }
                catch (NumberFormatException e) {
                    this.bigValue = new BigInteger(word);
                    if (!isNegative) break block11;
                    this.bigValue = this.bigValue.negate();
                }
            }
            return;
        }
        this.value = new BigInteger(word.substring(offset), radix).longValue();
        if (isNegative) {
            this.value = -this.value;
        }
    }

    public long getValue() {
        return this.value;
    }

    public BigInteger getBigValue() {
        return this.bigValue == null ? BigInteger.valueOf(this.value) : this.bigValue;
    }

    public boolean isBigValue() {
        return this.bigValue != null;
    }

    public boolean isByte() {
        return this.value >= 0L && this.value <= 255L;
    }

    public boolean isShort() {
        return this.value >= 0L && this.value <= 32767L;
    }

    public boolean isInteger() {
        return this.value >= 0L && this.value <= Integer.MAX_VALUE;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public Object toNumeric() {
        return this.value;
    }
}

