/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer.token.expr.value;

import java.util.ArrayList;
import java.util.List;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;

public class StringExprToken
extends ValueExprToken {
    protected final Quote quote;
    private String value;
    protected List<Segment> segments = new ArrayList<Segment>();
    protected ExprStmtToken expression;
    protected boolean binary;

    public StringExprToken(TokenMeta meta, Quote quote) {
        super(meta, TokenType.T_CONSTANT_ENCAPSED_STRING);
        this.quote = quote;
        this.value = meta.getWord();
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public void setSegments(List<Segment> segments) {
        this.segments = segments;
    }

    public Quote getQuote() {
        return this.quote;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public Object toNumeric() {
        int i;
        int len = this.value.length();
        boolean real = false;
        for (i = 0; i < len; ++i) {
            char ch = this.value.charAt(i);
            if ('9' >= ch && ch >= '0') continue;
            if (ch == '.') {
                if (real) break;
                real = true;
                continue;
            }
            if (i != 0) break;
            return 0;
        }
        if (real) {
            if (len == i) {
                return Double.parseDouble(this.value);
            }
            return Double.parseDouble(this.value.substring(0, i));
        }
        if (len == i) {
            return Long.parseLong(this.value);
        }
        return Long.parseLong(this.value.substring(0, i));
    }

    public ExprStmtToken getExpression() {
        return this.expression;
    }

    public void setExpression(ExprStmtToken expression) {
        this.expression = expression;
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }

    public static class Segment {
        public final int from;
        public final int to;
        public final boolean isVariable;

        public Segment(int from, int to, boolean isVariable) {
            this.from = from;
            this.to = to;
            this.isVariable = isVariable;
        }
    }

    public static enum Quote {
        SINGLE,
        DOUBLE,
        SHELL,
        DOC;


        public boolean isMagic() {
            return this == DOUBLE || this == SHELL;
        }
    }
}

