/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement.expr;

import org.develnext.jphp.core.compiler.jvm.misc.LocalVariable;
import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseStatementCompiler;
import org.develnext.jphp.core.tokenizer.token.stmt.ReturnStmtToken;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import php.runtime.Memory;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.invoke.InvokeHelper;
import php.runtime.lang.Generator;
import php.runtime.reflection.MethodEntity;

public class ReturnCompiler
extends BaseStatementCompiler<ReturnStmtToken> {
    public ReturnCompiler(ExpressionStmtCompiler exprCompiler) {
        super(exprCompiler);
    }

    @Override
    public void write(ReturnStmtToken token) {
        boolean isGeneratorReturn = false;
        if (token.getValue() != null && this.method.getGeneratorEntity() != null) {
            isGeneratorReturn = true;
            this.expr.writeVarLoad("~this");
            this.expr.writePushEnv();
            this.expr.writePushTraceInfo(token);
        }
        Memory result = token.isEmpty() ? Memory.UNDEFINED : Memory.NULL;
        boolean isImmutable = ((MethodEntity)this.method.getEntity()).isImmutable();
        if (token.getValue() != null) {
            result = this.expr.writeExpression(token.getValue(), true, true);
            if (this.methodStatement.getReturnHintType() == HintType.VOID) {
                String suffix = result != null && result.isNull() ? " (did you mean \"return;\" instead of \"return null;\"?)" : "";
                this.env.error(token.toTraceInfo(this.compiler.getContext()), ErrorType.E_ERROR, "A void function must not return a value" + suffix, new Object[0]);
            }
        }
        if (result != null) {
            Memory r;
            if (this.methodStatement.getReturnHintType() == HintType.VOID && this.methodStatement.isReturnOptional()) {
                this.env.error(token.toTraceInfo(this.compiler.getContext()), ErrorType.E_ERROR, "Void type cannot be nullable", new Object[0]);
            }
            if (isImmutable && ((r = ((MethodEntity)this.method.getEntity()).getResult()) == null || r.isUndefined())) {
                ((MethodEntity)this.method.getEntity()).setResult(result);
            }
            this.expr.writePushMemory(result);
        } else {
            ((MethodEntity)this.method.getEntity()).setImmutable(false);
        }
        if (this.expr.stackEmpty(false)) {
            this.expr.writePushNull();
        } else {
            this.expr.writePopBoxing(false);
        }
        if (((MethodEntity)this.method.getEntity()).isReturnReference()) {
            this.expr.writePushDup();
            this.expr.writePushEnv();
            this.expr.writePushTraceInfo(token);
            this.expr.writeSysStaticCall(InvokeHelper.class, "checkReturnReference", Void.TYPE, Memory.class, Environment.class, TraceInfo.class);
        } else {
            this.expr.writePopImmutable();
        }
        if (isGeneratorReturn) {
            this.expr.writeSysDynamicCall(Generator.class, "setReturn", Memory.class, Environment.class, TraceInfo.class, Memory.class);
        }
        if (!this.method.getTryStack().empty()) {
            LocalVariable variable = this.method.getLocalVariable("~result~");
            if (variable == null) {
                variable = this.method.addLocalVariable("~result~", null, Memory.class);
            }
            this.expr.writeVarStore(variable, false, false);
            this.add((AbstractInsnNode)new JumpInsnNode(167, this.method.getTryStack().peek().getReturnLabel()));
        } else {
            this.add((AbstractInsnNode)new InsnNode(176));
            this.expr.stackPop();
        }
    }
}

