/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.opcode;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.util.TraceClassVisitor;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.ModuleEntity;
import php.runtime.reflection.helper.ClosureEntity;

public class OpcodePrinter {
    private ClassReader classReader;

    private OpcodePrinter(byte[] data) {
        this.classReader = new ClassReader(data);
    }

    public OpcodePrinter(ModuleEntity module) {
        this(module.getData());
    }

    public OpcodePrinter(ClassEntity clazz) {
        this(clazz.getData());
    }

    public OpcodePrinter(ClosureEntity closure) {
        this(closure.getData());
    }

    public OpcodePrinter(FunctionEntity function) {
        this(function.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toFile(File file, int flags) throws IOException {
        try (FileWriter fileWriter = new FileWriter(file);){
            this.toWriter(fileWriter, flags);
        }
    }

    public void toFile(File file) throws IOException {
        this.toFile(file, 2);
    }

    public String toString(int flags) {
        StringWriter stringWriter = new StringWriter();
        this.toWriter(stringWriter, flags);
        return stringWriter.toString();
    }

    public String toString() {
        return this.toString(2);
    }

    public void toWriter(Writer writer, int flags) {
        PrintWriter printWriter = new PrintWriter(writer);
        TraceClassVisitor traceClassVisitor = new TraceClassVisitor(null, printWriter);
        this.classReader.accept((ClassVisitor)traceClassVisitor, flags);
    }

    public void toWriter(Writer writer) {
        this.toWriter(writer, 2);
    }
}

