/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j;

import java.util.Iterator;
import org.dyn4j.BinarySearchTreeIterator;
import org.dyn4j.BinarySearchTreeNode;
import org.dyn4j.BinarySearchTreeSearchCriteria;

public class BinarySearchTree<E extends Comparable<E>>
implements Iterable<E> {
    BinarySearchTreeNode<E> root;
    int size;
    boolean selfBalancing;

    public BinarySearchTree() {
        this.root = null;
        this.size = 0;
        this.selfBalancing = false;
    }

    public BinarySearchTree(boolean selfBalancing) {
        this.root = null;
        this.size = 0;
        this.selfBalancing = selfBalancing;
    }

    public BinarySearchTree(BinarySearchTree<E> tree) {
        this.selfBalancing = tree.selfBalancing;
        this.insertSubtree(tree);
    }

    public BinarySearchTree(BinarySearchTree<E> tree, boolean selfBalancing) {
        this.selfBalancing = selfBalancing;
        this.insertSubtree(tree);
    }

    public boolean isSelfBalancing() {
        return this.selfBalancing;
    }

    public void setSelfBalancing(boolean flag) {
        if (flag && !this.selfBalancing && this.size > 2) {
            this.balanceTree();
        }
        this.selfBalancing = flag;
    }

    public boolean insert(E comparable) {
        if (comparable == null) {
            return false;
        }
        BinarySearchTreeNode<E> node = new BinarySearchTreeNode<E>(comparable);
        return this.insert(node);
    }

    public boolean remove(E comparable) {
        if (comparable == null) {
            return false;
        }
        if (this.root == null) {
            return false;
        }
        return this.remove(this.root, comparable) != null;
    }

    public E removeMinimum() {
        if (this.root == null) {
            return null;
        }
        return this.removeMinimum(this.root).comparable;
    }

    public E removeMaximum() {
        if (this.root == null) {
            return null;
        }
        return this.removeMaximum(this.root).comparable;
    }

    public E getMinimum() {
        if (this.root == null) {
            return null;
        }
        return this.getMinimum(this.root).comparable;
    }

    public E getMaximum() {
        if (this.root == null) {
            return null;
        }
        return this.getMaximum(this.root).comparable;
    }

    public boolean contains(E comparable) {
        if (comparable == null) {
            return false;
        }
        if (this.root == null) {
            return false;
        }
        return this.contains(this.root, comparable) != null;
    }

    public <T extends BinarySearchTreeSearchCriteria<E>> T search(T criteria) {
        if (this.root == null) {
            return criteria;
        }
        BinarySearchTreeNode<E> node = this.root;
        while (node != null) {
            int result = criteria.evaluate(node.comparable);
            if (result < 0) {
                node = node.left;
                continue;
            }
            if (result <= 0) break;
            node = node.right;
        }
        return criteria;
    }

    public E getRoot() {
        if (this.root == null) {
            return null;
        }
        return this.root.comparable;
    }

    public void clear() {
        this.root = null;
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public int getHeight() {
        return this.getHeight(this.root);
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<E> iterator() {
        return this.inOrderIterator();
    }

    public Iterator<E> inOrderIterator() {
        return new BinarySearchTreeIterator<E>(this.root, true);
    }

    public Iterator<E> reverseOrderIterator() {
        return new BinarySearchTreeIterator<E>(this.root, false);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<E> iterator = this.inOrderIterator();
        sb.append("BinarySearchTree[");
        while (iterator.hasNext()) {
            sb.append(iterator.next());
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    BinarySearchTreeNode<E> getMinimum(BinarySearchTreeNode<E> node) {
        if (node != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            node = node.left;
lbl4:
            // 2 sources

            ** while (node.left != null)
        }
lbl5:
        // 1 sources

        return node;
    }

    /*
     * Unable to fully structure code
     */
    BinarySearchTreeNode<E> getMaximum(BinarySearchTreeNode<E> node) {
        if (node != null) ** GOTO lbl4
        return null;
lbl-1000:
        // 1 sources

        {
            node = node.right;
lbl4:
            // 2 sources

            ** while (node.right != null)
        }
lbl5:
        // 1 sources

        return node;
    }

    BinarySearchTreeNode<E> removeMinimum(BinarySearchTreeNode<E> node) {
        if ((node = this.getMinimum(node)) == null) {
            return null;
        }
        if (node == this.root) {
            this.root = node.right;
        } else if (node.parent.right == node) {
            node.parent.right = node.right;
        } else {
            node.parent.left = node.right;
        }
        --this.size;
        return node;
    }

    BinarySearchTreeNode<E> removeMaximum(BinarySearchTreeNode<E> node) {
        if ((node = this.getMaximum(node)) == null) {
            return null;
        }
        if (node == this.root) {
            this.root = node.left;
        } else if (node.parent.right == node) {
            node.parent.right = node.left;
        } else {
            node.parent.left = node.left;
        }
        --this.size;
        return node;
    }

    int getHeight(BinarySearchTreeNode<E> node) {
        if (node == null) {
            return 0;
        }
        if (node.left == null && node.right == null) {
            return 1;
        }
        return 1 + Math.max(this.getHeight(node.left), this.getHeight(node.right));
    }

    int size(BinarySearchTreeNode<E> node) {
        if (node == null) {
            return 0;
        }
        if (node.left == null && node.right == null) {
            return 1;
        }
        return 1 + this.size(node.left) + this.size(node.right);
    }

    boolean contains(BinarySearchTreeNode<E> node) {
        if (node == null) {
            return false;
        }
        if (this.root == null) {
            return false;
        }
        if (node == this.root) {
            return true;
        }
        BinarySearchTreeNode<E> curr = this.root;
        while (curr != null) {
            if (curr == node) {
                return true;
            }
            int diff = node.compareTo(curr);
            if (diff == 0) {
                return curr == node;
            }
            curr = diff < 0 ? curr.left : curr.right;
        }
        return false;
    }

    BinarySearchTreeNode<E> get(E comparable) {
        if (comparable == null) {
            return null;
        }
        if (this.root == null) {
            return null;
        }
        return this.contains(this.root, comparable);
    }

    boolean insertSubtree(BinarySearchTreeNode<E> node) {
        if (node == null) {
            return false;
        }
        BinarySearchTreeIterator<E> iterator = new BinarySearchTreeIterator<E>(node);
        while (iterator.hasNext()) {
            BinarySearchTreeNode<Comparable> newNode = new BinarySearchTreeNode<Comparable>((Comparable)iterator.next());
            this.insert(newNode);
        }
        return true;
    }

    protected boolean insertSubtree(BinarySearchTree<E> tree) {
        if (tree == null) {
            return false;
        }
        if (tree.root == null) {
            return true;
        }
        Iterator<E> iterator = tree.inOrderIterator();
        while (iterator.hasNext()) {
            BinarySearchTreeNode<Comparable> newNode = new BinarySearchTreeNode<Comparable>((Comparable)iterator.next());
            this.insert(newNode);
        }
        return true;
    }

    protected boolean removeSubtree(E comparable) {
        if (comparable == null) {
            return false;
        }
        if (this.root == null) {
            return false;
        }
        BinarySearchTreeNode<E> node = this.root;
        while (node != null) {
            int diff = comparable.compareTo(node.comparable);
            if (diff < 0) {
                node = node.left;
                continue;
            }
            if (diff > 0) {
                node = node.right;
                continue;
            }
            if (node.comparable.equals(comparable)) {
                if (node.isLeftChild()) {
                    node.parent.left = null;
                } else {
                    node.parent.right = null;
                }
                this.size -= this.size(node);
                if (this.selfBalancing) {
                    this.balanceTree(node.parent);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    boolean removeSubtree(BinarySearchTreeNode<E> node) {
        if (node == null) {
            return false;
        }
        if (this.root == null) {
            return false;
        }
        if (this.root == node) {
            this.root = null;
        } else if (this.contains(node)) {
            if (node.isLeftChild()) {
                node.parent.left = null;
            } else {
                node.parent.right = null;
            }
            this.size -= this.size(node);
            if (this.selfBalancing) {
                this.balanceTree(node.parent);
            }
            return true;
        }
        return false;
    }

    boolean insert(BinarySearchTreeNode<E> item) {
        if (this.root == null) {
            this.root = item;
            ++this.size;
            return true;
        }
        return this.insert(item, this.root);
    }

    /*
     * Unable to fully structure code
     */
    boolean insert(BinarySearchTreeNode<E> item, BinarySearchTreeNode<E> node) {
        if (node != null) ** GOTO lbl15
        return false;
lbl-1000:
        // 1 sources

        {
            if (item.compareTo(node) < 0) {
                if (node.left == null) {
                    node.left = item;
                    item.parent = node;
                    break;
                }
                node = node.left;
                continue;
            }
            if (node.right == null) {
                node.right = item;
                item.parent = node;
                break;
            }
            node = node.right;
lbl15:
            // 3 sources

            ** while (node != null)
        }
lbl16:
        // 3 sources

        ++this.size;
        if (this.selfBalancing) {
            this.balanceTree(node);
        }
        return true;
    }

    boolean remove(BinarySearchTreeNode<E> node) {
        if (node == null) {
            return false;
        }
        if (this.root == null) {
            return false;
        }
        if (this.contains(node)) {
            this.removeNode(node);
            return true;
        }
        return false;
    }

    BinarySearchTreeNode<E> remove(BinarySearchTreeNode<E> node, E comparable) {
        while (node != null) {
            int diff = comparable.compareTo(node.comparable);
            if (diff < 0) {
                node = node.left;
                continue;
            }
            if (diff > 0) {
                node = node.right;
                continue;
            }
            if (node.comparable.equals(comparable)) {
                this.removeNode(node);
                return node;
            }
            return null;
        }
        return null;
    }

    void removeNode(BinarySearchTreeNode<E> node) {
        boolean isLeftChild = node.isLeftChild();
        if (node.left != null && node.right != null) {
            BinarySearchTreeNode min = this.getMinimum(node.right);
            if (min != node.right) {
                min.parent.left = min.right;
                if (min.right != null) {
                    min.right.parent = min.parent;
                }
                min.right = node.right;
            }
            if (node.right != null) {
                node.right.parent = min;
            }
            if (node.left != null) {
                node.left.parent = min;
            }
            if (node == this.root) {
                this.root = min;
            } else if (isLeftChild) {
                node.parent.left = min;
            } else {
                node.parent.right = min;
            }
            min.left = node.left;
            min.parent = node.parent;
            if (this.selfBalancing) {
                this.balanceTree(min.parent);
            }
        } else if (node.left != null) {
            if (node == this.root) {
                this.root = node.left;
            } else if (isLeftChild) {
                node.parent.left = node.left;
            } else {
                node.parent.right = node.left;
            }
            if (node.left != null) {
                node.left.parent = node.parent;
            }
        } else if (node.right != null) {
            if (node == this.root) {
                this.root = node.right;
            } else if (isLeftChild) {
                node.parent.left = node.right;
            } else {
                node.parent.right = node.right;
            }
            if (node.right != null) {
                node.right.parent = node.parent;
            }
        } else if (node == this.root) {
            this.root = null;
        } else if (isLeftChild) {
            node.parent.left = null;
        } else {
            node.parent.right = null;
        }
        --this.size;
    }

    BinarySearchTreeNode<E> contains(BinarySearchTreeNode<E> node, E comparable) {
        while (node != null) {
            Object nodeData = node.comparable;
            int diff = comparable.compareTo(nodeData);
            if (diff == 0) {
                if (node.comparable.equals(comparable)) {
                    return node;
                }
                return null;
            }
            node = diff < 0 ? node.left : node.right;
        }
        return null;
    }

    protected void balanceTree() {
        BinarySearchTreeNode<E> root = this.root;
        boolean balancing = this.selfBalancing;
        this.root = null;
        this.size = 0;
        this.selfBalancing = true;
        BinarySearchTreeIterator<E> iterator = new BinarySearchTreeIterator<E>(root);
        while (iterator.hasNext()) {
            BinarySearchTreeNode<Comparable> node = new BinarySearchTreeNode<Comparable>((Comparable)iterator.next());
            this.insert(node);
        }
        this.selfBalancing = balancing;
    }

    void balanceTree(BinarySearchTreeNode<E> node) {
        while (node != null) {
            node = this.balance(node);
            node = node.parent;
        }
    }

    BinarySearchTreeNode<E> balance(BinarySearchTreeNode<E> node) {
        int bh;
        if (node == null) {
            return null;
        }
        if (this.getHeight(node) < 2) {
            return node;
        }
        BinarySearchTreeNode p = node.parent;
        BinarySearchTreeNode a = node.left;
        BinarySearchTreeNode b = node.right;
        int ah = this.getHeight(a);
        int balance = ah - (bh = this.getHeight(b));
        if (balance > 1) {
            BinarySearchTreeNode c;
            int ach = this.getHeight(a.right);
            if (ach > 1) {
                c = a.right;
                a.right = c.left;
                if (c.left != null) {
                    c.left.parent = a;
                }
                c.left = a;
                a.parent = c;
                node.left = c;
                c.parent = node;
            }
            c = node.left;
            node.left = c.right;
            if (c.right != null) {
                c.right.parent = node;
            }
            c.right = node;
            c.parent = node.parent;
            node.parent = c;
            if (p != null) {
                if (p.left == node) {
                    p.left = c;
                } else {
                    p.right = c;
                }
            } else {
                this.root = c;
            }
            return c;
        }
        if (balance < -1) {
            BinarySearchTreeNode d;
            int bch = this.getHeight(b.left);
            if (bch > 1) {
                d = b.left;
                b.left = d.right;
                if (d.right != null) {
                    d.right.parent = b;
                }
                d.right = b;
                b.parent = d;
                node.right = d;
                d.parent = node;
            }
            d = node.right;
            node.right = d.left;
            if (d.left != null) {
                d.left.parent = node;
            }
            d.left = node;
            d.parent = node.parent;
            node.parent = d;
            if (p != null) {
                if (p.left == node) {
                    p.left = d;
                } else {
                    p.right = d;
                }
            } else {
                this.root = d;
            }
            return d;
        }
        return node;
    }
}

