/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision;

import org.dyn4j.collision.AbstractBounds;
import org.dyn4j.collision.Bounds;
import org.dyn4j.collision.Collidable;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Translatable;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class AxisAlignedBounds
extends AbstractBounds
implements Bounds,
Translatable {
    protected final AABB aabb;

    public AxisAlignedBounds(double width, double height) {
        if (width <= 0.0 || height <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("collision.bounds.axisAligned.invalidArgument"));
        }
        double w2 = width * 0.5;
        double h2 = height * 0.5;
        this.aabb = new AABB(-w2, -h2, w2, h2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AxisAlignedBounds[Width=").append(this.aabb.getWidth()).append("|Height=").append(this.aabb.getHeight()).append("|Translation=").append(this.getTranslation()).append("]");
        return sb.toString();
    }

    @Override
    public boolean isOutside(Collidable<?> collidable) {
        AABB aabbBody;
        Vector2 tx = this.transform.getTranslation();
        AABB aabbBounds = this.aabb.getTranslated(tx);
        return !aabbBounds.overlaps(aabbBody = collidable.createAABB());
    }

    public AABB getBounds() {
        return this.aabb.getTranslated(this.transform.getTranslation());
    }

    public double getWidth() {
        return this.aabb.getWidth();
    }

    public double getHeight() {
        return this.aabb.getHeight();
    }
}

