/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision;

import org.dyn4j.collision.Filter;

public class CategoryFilter
implements Filter {
    protected final long category;
    protected final long mask;

    public CategoryFilter() {
        this.category = 1L;
        this.mask = Long.MAX_VALUE;
    }

    public CategoryFilter(long category, long mask) {
        this.category = category;
        this.mask = mask;
    }

    @Override
    public boolean isAllowed(Filter filter) {
        if (filter == null) {
            return true;
        }
        if (filter instanceof CategoryFilter) {
            CategoryFilter cf = (CategoryFilter)filter;
            return (this.category & cf.mask) > 0L && (cf.category & this.mask) > 0L;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof CategoryFilter) {
            CategoryFilter filter = (CategoryFilter)obj;
            return filter.category == this.category && filter.mask == this.mask;
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + (int)(this.category >>> 32 ^ this.category);
        hash = hash * 31 + (int)(this.mask >>> 32 ^ this.mask);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CategoryFilter[Category=").append(this.category).append("|Mask=").append(this.mask).append("]");
        return sb.toString();
    }

    public long getCategory() {
        return this.category;
    }

    public long getMask() {
        return this.mask;
    }
}

