/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.broadphase;

import java.util.List;
import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.Fixture;
import org.dyn4j.collision.broadphase.BroadphaseFilter;
import org.dyn4j.collision.broadphase.BroadphaseItem;
import org.dyn4j.collision.broadphase.BroadphasePair;
import org.dyn4j.geometry.AABB;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Ray;
import org.dyn4j.geometry.Shiftable;
import org.dyn4j.geometry.Transform;

public interface BroadphaseDetector<E extends Collidable<T>, T extends Fixture>
extends Shiftable {
    public static final double DEFAULT_AABB_EXPANSION = 0.2;
    public static final int DEFAULT_INITIAL_CAPACITY = 64;

    public void add(E var1);

    public void add(E var1, T var2);

    public void remove(E var1);

    public boolean remove(E var1, T var2);

    public void update(E var1);

    public void update(E var1, T var2);

    public AABB getAABB(E var1);

    public AABB getAABB(E var1, T var2);

    public boolean contains(E var1);

    public boolean contains(E var1, T var2);

    public void clear();

    public int size();

    public List<BroadphasePair<E, T>> detect();

    public List<BroadphasePair<E, T>> detect(BroadphaseFilter<E, T> var1);

    public List<BroadphaseItem<E, T>> detect(AABB var1);

    public List<BroadphaseItem<E, T>> detect(AABB var1, BroadphaseFilter<E, T> var2);

    public List<BroadphaseItem<E, T>> raycast(Ray var1, double var2);

    public List<BroadphaseItem<E, T>> raycast(Ray var1, double var2, BroadphaseFilter<E, T> var4);

    public boolean detect(E var1, E var2);

    public boolean detect(Convex var1, Transform var2, Convex var3, Transform var4);

    public double getAABBExpansion();

    public void setAABBExpansion(double var1);
}

