/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.broadphase;

import org.dyn4j.collision.Collidable;
import org.dyn4j.collision.Fixture;

public final class BroadphaseItem<E extends Collidable<T>, T extends Fixture> {
    final E collidable;
    final T fixture;

    public BroadphaseItem(E collidable, T fixture) {
        this.collidable = collidable;
        this.fixture = fixture;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof BroadphaseItem) {
            BroadphaseItem pair = (BroadphaseItem)obj;
            if (pair.collidable == this.collidable && pair.fixture == this.fixture) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.collidable.getId().hashCode();
        hash = hash * 31 + ((Fixture)this.fixture).getId().hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("BroadphaseItem[Collidable=").append(this.collidable.getId()).append("|Fixture=").append(((Fixture)this.fixture).getId()).append("]");
        return sb.toString();
    }

    public E getCollidable() {
        return this.collidable;
    }

    public T getFixture() {
        return this.fixture;
    }
}

