/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.continuous;

import org.dyn4j.Epsilon;
import org.dyn4j.collision.continuous.TimeOfImpact;
import org.dyn4j.collision.continuous.TimeOfImpactDetector;
import org.dyn4j.collision.narrowphase.DistanceDetector;
import org.dyn4j.collision.narrowphase.Gjk;
import org.dyn4j.collision.narrowphase.Separation;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class ConservativeAdvancement
implements TimeOfImpactDetector {
    public static final double DEFAULT_DISTANCE_EPSILON = Math.cbrt(Epsilon.E);
    public static final int DEFAULT_MAX_ITERATIONS = 30;
    protected DistanceDetector distanceDetector = new Gjk();
    protected double distanceEpsilon = DEFAULT_DISTANCE_EPSILON;
    protected int maxIterations = 30;

    public ConservativeAdvancement() {
    }

    public ConservativeAdvancement(DistanceDetector distanceDetector) {
        if (distanceDetector == null) {
            throw new NullPointerException(Messages.getString("collision.continuous.conservativeAdvancement.nullDistanceDetector"));
        }
        this.distanceDetector = distanceDetector;
    }

    @Override
    public boolean getTimeOfImpact(Convex convex1, Transform transform1, Vector2 dp1, double da1, Convex convex2, Transform transform2, Vector2 dp2, double da2, TimeOfImpact toi) {
        return this.getTimeOfImpact(convex1, transform1, dp1, da1, convex2, transform2, dp2, da2, 0.0, 1.0, toi);
    }

    @Override
    public boolean getTimeOfImpact(Convex convex1, Transform transform1, Vector2 dp1, double da1, Convex convex2, Transform transform2, Vector2 dp2, double da2, double t1, double t2, TimeOfImpact toi) {
        double l;
        double amax;
        int iterations = 0;
        Transform lerpTx1 = new Transform();
        Transform lerpTx2 = new Transform();
        Separation separation = new Separation();
        boolean separated = this.distanceDetector.distance(convex1, transform1, convex2, transform2, separation);
        if (!separated) {
            return false;
        }
        double d = separation.getDistance();
        if (d < this.distanceEpsilon) {
            toi.time = 0.0;
            toi.separation = separation;
            return true;
        }
        Vector2 n = separation.getNormal();
        double rmax1 = convex1.getRadius();
        double rmax2 = convex2.getRadius();
        Vector2 rv = dp1.difference(dp2);
        double rvl = rv.getMagnitude();
        if (rvl + (amax = rmax1 * Math.abs(da1) + rmax2 * Math.abs(da2)) == 0.0) {
            return false;
        }
        double l0 = l = t1;
        while (d > this.distanceEpsilon && iterations < this.maxIterations) {
            double rvDotN = rv.dot(n);
            double drel = rvDotN + amax;
            if (drel <= Epsilon.E) {
                return false;
            }
            double dt = d / drel;
            if ((l += dt) < t1) {
                return false;
            }
            if (l > t2) {
                return false;
            }
            if (l <= l0) break;
            l0 = l;
            ++iterations;
            transform1.lerp(dp1, da1, l, lerpTx1);
            transform2.lerp(dp2, da2, l, lerpTx2);
            separated = this.distanceDetector.distance(convex1, lerpTx1, convex2, lerpTx2, separation);
            d = separation.getDistance();
            if (!separated) {
                transform1.lerp(dp1, da1, l -= 0.5 * this.distanceEpsilon / drel, lerpTx1);
                transform2.lerp(dp2, da2, l, lerpTx2);
                this.distanceDetector.distance(convex1, lerpTx1, convex2, lerpTx2, separation);
                d = separation.getDistance();
                break;
            }
            n = separation.getNormal();
            d = separation.getDistance();
        }
        toi.time = l;
        toi.separation = separation;
        return true;
    }

    public DistanceDetector getDistanceDetector() {
        return this.distanceDetector;
    }

    public void setDistanceDetector(DistanceDetector distanceDetector) {
        if (distanceDetector == null) {
            throw new NullPointerException(Messages.getString("collision.continuous.conservativeAdvancement.nullDistanceDetector"));
        }
        this.distanceDetector = distanceDetector;
    }

    public double getDistanceEpsilon() {
        return this.distanceEpsilon;
    }

    public void setDistanceEpsilon(double distanceEpsilon) {
        if (distanceEpsilon <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("collision.continuous.conservativeAdvancement.invalidDistanceEpsilon"));
        }
        this.distanceEpsilon = distanceEpsilon;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        if (maxIterations < 5) {
            throw new IllegalArgumentException(Messages.getString("collision.continuous.conservativeAdvancement.invalidMaximumIterations"));
        }
        this.maxIterations = maxIterations;
    }
}

