/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.manifold;

import java.util.ArrayList;
import java.util.List;
import org.dyn4j.collision.manifold.IndexedManifoldPointId;
import org.dyn4j.collision.manifold.Manifold;
import org.dyn4j.collision.manifold.ManifoldPoint;
import org.dyn4j.collision.manifold.ManifoldPointId;
import org.dyn4j.collision.manifold.ManifoldSolver;
import org.dyn4j.collision.narrowphase.Penetration;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.EdgeFeature;
import org.dyn4j.geometry.Feature;
import org.dyn4j.geometry.PointFeature;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;

public class ClippingManifoldSolver
implements ManifoldSolver {
    @Override
    public boolean getManifold(Penetration penetration, Convex convex1, Transform transform1, Convex convex2, Transform transform2, Manifold manifold) {
        manifold.clear();
        Vector2 n = penetration.getNormal();
        Feature feature1 = convex1.getFarthestFeature(n, transform1);
        if (feature1 instanceof PointFeature) {
            PointFeature vertex = (PointFeature)feature1;
            ManifoldPoint mp = new ManifoldPoint(ManifoldPointId.DISTANCE, vertex.getPoint(), penetration.getDepth());
            manifold.points.add(mp);
            manifold.normal = n.negate();
            return true;
        }
        Feature feature2 = convex2.getFarthestFeature(n.getNegative(), transform2);
        if (feature2 instanceof PointFeature) {
            PointFeature vertex = (PointFeature)feature2;
            ManifoldPoint mp = new ManifoldPoint(ManifoldPointId.DISTANCE, vertex.getPoint(), penetration.getDepth());
            manifold.points.add(mp);
            manifold.normal = n.negate();
            return true;
        }
        EdgeFeature reference = (EdgeFeature)feature1;
        EdgeFeature incident = (EdgeFeature)feature2;
        boolean flipped = false;
        Vector2 e1 = reference.getEdge();
        Vector2 e2 = incident.getEdge();
        if (Math.abs(e1.dot(n)) > Math.abs(e2.dot(n))) {
            EdgeFeature e = reference;
            reference = incident;
            incident = e;
            flipped = true;
        }
        Vector2 refev = reference.getEdge();
        refev.normalize();
        double offset1 = -refev.dot(reference.getVertex1().getPoint());
        double offset2 = refev.dot(reference.getVertex2().getPoint());
        List<PointFeature> clip1 = this.clip(incident.getVertex1(), incident.getVertex2(), refev.getNegative(), offset1);
        if (clip1.size() < 2) {
            return false;
        }
        List<PointFeature> clip2 = this.clip(clip1.get(0), clip1.get(1), refev, offset2);
        if (clip2.size() < 2) {
            return false;
        }
        Vector2 frontNormal = refev.cross(1.0);
        double frontOffset = frontNormal.dot(reference.getMaximum().getPoint());
        manifold.normal = flipped ? frontNormal.getNegative() : frontNormal;
        int i = 0;
        while (i < clip2.size()) {
            PointFeature vertex = clip2.get(i);
            Vector2 point = vertex.getPoint();
            double depth = frontNormal.dot(point) - frontOffset;
            if (depth >= 0.0) {
                IndexedManifoldPointId id = new IndexedManifoldPointId(reference.getIndex(), incident.getIndex(), vertex.getIndex(), flipped);
                ManifoldPoint mp = new ManifoldPoint(id, point, depth);
                manifold.points.add(mp);
            }
            ++i;
        }
        return manifold.points.size() != 0;
    }

    protected List<PointFeature> clip(PointFeature v1, PointFeature v2, Vector2 n, double offset) {
        ArrayList<PointFeature> points = new ArrayList<PointFeature>(2);
        Vector2 p1 = v1.getPoint();
        Vector2 p2 = v2.getPoint();
        double d1 = n.dot(p1) - offset;
        double d2 = n.dot(p2) - offset;
        if (d1 <= 0.0) {
            points.add(v1);
        }
        if (d2 <= 0.0) {
            points.add(v2);
        }
        if (d1 * d2 < 0.0) {
            Vector2 e = p1.to(p2);
            double u = d1 / (d1 - d2);
            e.multiply(u);
            e.add(p1);
            if (d1 > 0.0) {
                points.add(new PointFeature(e, v1.getIndex()));
            } else {
                points.add(new PointFeature(e, v2.getIndex()));
            }
        }
        return points;
    }
}

