/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.manifold;

import org.dyn4j.collision.manifold.ManifoldPointId;

public class IndexedManifoldPointId
implements ManifoldPointId {
    private final int referenceEdge;
    private final int incidentEdge;
    private final int incidentVertex;
    private final boolean flipped;

    public IndexedManifoldPointId(int referenceEdge, int incidentEdge, int incidentVertex) {
        this(referenceEdge, incidentEdge, incidentVertex, false);
    }

    public IndexedManifoldPointId(int referenceEdge, int incidentEdge, int incidentVertex, boolean flipped) {
        this.referenceEdge = referenceEdge;
        this.incidentEdge = incidentEdge;
        this.incidentVertex = incidentVertex;
        this.flipped = flipped;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other instanceof IndexedManifoldPointId) {
            IndexedManifoldPointId o = (IndexedManifoldPointId)other;
            if (this.referenceEdge == o.referenceEdge && this.incidentEdge == o.incidentEdge && this.incidentVertex == o.incidentVertex && this.flipped == o.flipped) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this.referenceEdge;
        hash = 37 * hash + this.incidentEdge;
        hash = 37 * hash + this.incidentVertex;
        hash = 37 * hash + (this.flipped ? 1231 : 1237);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("IndexedManifoldPointId[ReferenceEdge=").append(this.referenceEdge).append("|IncidentEdge=").append(this.incidentEdge).append("|IncidentVertex=").append(this.incidentVertex).append("|IsFlipped=").append(this.flipped).append("]");
        return sb.toString();
    }

    public int getReferenceEdge() {
        return this.referenceEdge;
    }

    public int getIncidentEdge() {
        return this.incidentEdge;
    }

    public int getIncidentVertex() {
        return this.incidentVertex;
    }

    public boolean isFlipped() {
        return this.flipped;
    }
}

