/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import org.dyn4j.collision.narrowphase.Penetration;
import org.dyn4j.collision.narrowphase.Raycast;
import org.dyn4j.collision.narrowphase.Separation;
import org.dyn4j.geometry.Circle;
import org.dyn4j.geometry.Ray;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;

public final class CircleDetector {
    private CircleDetector() {
    }

    public static final boolean detect(Circle circle1, Transform transform1, Circle circle2, Transform transform2, Penetration penetration) {
        Vector2 ce1 = transform1.getTransformed(circle1.getCenter());
        Vector2 ce2 = transform2.getTransformed(circle2.getCenter());
        Vector2 v = ce2.subtract(ce1);
        double radii = circle1.getRadius() + circle2.getRadius();
        double mag = v.getMagnitude();
        if (mag < radii) {
            penetration.normal = v;
            penetration.depth = radii - v.normalize();
            return true;
        }
        return false;
    }

    public static final boolean detect(Circle circle1, Transform transform1, Circle circle2, Transform transform2) {
        Vector2 ce1 = transform1.getTransformed(circle1.getCenter());
        Vector2 ce2 = transform2.getTransformed(circle2.getCenter());
        Vector2 v = ce2.subtract(ce1);
        double radii = circle1.getRadius() + circle2.getRadius();
        double mag = v.getMagnitude();
        return mag < radii;
    }

    public static final boolean distance(Circle circle1, Transform transform1, Circle circle2, Transform transform2, Separation separation) {
        Vector2 ce1 = transform1.getTransformed(circle1.getCenter());
        Vector2 ce2 = transform2.getTransformed(circle2.getCenter());
        double r1 = circle1.getRadius();
        double r2 = circle2.getRadius();
        Vector2 v = ce1.to(ce2);
        double radii = r1 + r2;
        double mag = v.getMagnitude();
        if (mag >= radii) {
            separation.normal = v;
            separation.distance = v.normalize() - radii;
            separation.point1 = ce1.add(v.x * r1, v.y * r1);
            separation.point2 = ce2.add(-v.x * r2, -v.y * r2);
            return true;
        }
        return false;
    }

    public static final boolean raycast(Ray ray, double maxLength, Circle circle, Transform transform, Raycast raycast) {
        Vector2 s = ray.getStart();
        Vector2 d = ray.getDirectionVector();
        Vector2 ce = transform.getTransformed(circle.getCenter());
        double r = circle.getRadius();
        if (circle.contains(s, transform)) {
            return false;
        }
        Vector2 sMinusC = s.difference(ce);
        double a = d.dot(d);
        double b = 2.0 * d.dot(sMinusC);
        double c = sMinusC.dot(sMinusC) - r * r;
        double inv2a = 1.0 / (2.0 * a);
        double b24ac = b * b - 4.0 * a * c;
        if (b24ac < 0.0) {
            return false;
        }
        double sqrt = Math.sqrt(b24ac);
        double t0 = (-b + sqrt) * inv2a;
        double t1 = (-b - sqrt) * inv2a;
        double t = 0.0;
        if (t0 < 0.0) {
            if (t1 < 0.0) {
                return false;
            }
            t = t1;
        } else {
            t = t1 < 0.0 ? t0 : (t0 < t1 ? t0 : t1);
        }
        if (maxLength > 0.0 && t > maxLength) {
            return false;
        }
        Vector2 p = d.product(t).add(s);
        Vector2 n = ce.to(p);
        n.normalize();
        raycast.point = p;
        raycast.normal = n;
        raycast.distance = t;
        return true;
    }
}

