/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import org.dyn4j.geometry.Vector2;

final class ExpandingSimplexEdge
implements Comparable<ExpandingSimplexEdge> {
    final Vector2 point1;
    final Vector2 point2;
    final Vector2 normal;
    final double distance;

    public ExpandingSimplexEdge(Vector2 point1, Vector2 point2, int winding) {
        this.normal = new Vector2(point2.x - point1.x, point2.y - point1.y);
        if (winding < 0) {
            this.normal.right();
        } else {
            this.normal.left();
        }
        this.normal.normalize();
        this.distance = Math.abs(point1.x * this.normal.x + point1.y * this.normal.y);
        this.point1 = point1;
        this.point2 = point2;
    }

    @Override
    public int compareTo(ExpandingSimplexEdge o) {
        if (this.distance < o.distance) {
            return -1;
        }
        if (this.distance > o.distance) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExpandingSimplexEdge[Point1=").append(this.point1).append("|Point2=").append(this.point2).append("|Normal=").append(this.normal).append("|Distance=").append(this.distance).append("]");
        return sb.toString();
    }
}

