/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dyn4j.collision.narrowphase.FallbackCondition;
import org.dyn4j.collision.narrowphase.NarrowphaseDetector;
import org.dyn4j.collision.narrowphase.Penetration;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Transform;

public class FallbackNarrowphaseDetector
implements NarrowphaseDetector {
    protected final NarrowphaseDetector primaryNarrowphaseDetector;
    protected final NarrowphaseDetector fallbackNarrowphaseDetector;
    protected final List<FallbackCondition> fallbackConditions;

    public FallbackNarrowphaseDetector(NarrowphaseDetector primaryNarrowphaseDetector, NarrowphaseDetector fallbackNarrowphaseDetector) {
        this(primaryNarrowphaseDetector, fallbackNarrowphaseDetector, new ArrayList<FallbackCondition>());
    }

    public FallbackNarrowphaseDetector(NarrowphaseDetector primaryNarrowphaseDetector, NarrowphaseDetector fallbackNarrowphaseDetector, List<FallbackCondition> conditions) {
        if (primaryNarrowphaseDetector == null) {
            throw new NullPointerException();
        }
        if (fallbackNarrowphaseDetector == null) {
            throw new NullPointerException();
        }
        this.primaryNarrowphaseDetector = primaryNarrowphaseDetector;
        this.fallbackNarrowphaseDetector = fallbackNarrowphaseDetector;
        this.fallbackConditions = conditions != null ? conditions : new ArrayList<FallbackCondition>();
    }

    public void addCondition(FallbackCondition condition) {
        this.fallbackConditions.add(condition);
        Collections.sort(this.fallbackConditions);
    }

    public boolean removeCondition(FallbackCondition condition) {
        return this.fallbackConditions.remove(condition);
    }

    public boolean containsCondition(FallbackCondition condition) {
        return this.fallbackConditions.contains(condition);
    }

    public int getConditionCount() {
        return this.fallbackConditions.size();
    }

    public FallbackCondition getCondition(int index) {
        return this.fallbackConditions.get(index);
    }

    public boolean isFallbackRequired(Convex convex1, Convex convex2) {
        int size = this.fallbackConditions.size();
        int i = 0;
        while (i < size) {
            FallbackCondition condition = this.fallbackConditions.get(i);
            if (condition != null && condition.isMatch(convex1, convex2)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean detect(Convex convex1, Transform transform1, Convex convex2, Transform transform2) {
        if (this.isFallbackRequired(convex1, convex2)) {
            return this.fallbackNarrowphaseDetector.detect(convex1, transform1, convex2, transform2);
        }
        return this.primaryNarrowphaseDetector.detect(convex1, transform1, convex2, transform2);
    }

    @Override
    public boolean detect(Convex convex1, Transform transform1, Convex convex2, Transform transform2, Penetration penetration) {
        if (this.isFallbackRequired(convex1, convex2)) {
            return this.fallbackNarrowphaseDetector.detect(convex1, transform1, convex2, transform2, penetration);
        }
        return this.primaryNarrowphaseDetector.detect(convex1, transform1, convex2, transform2, penetration);
    }

    public NarrowphaseDetector getPrimaryNarrowphaseDetector() {
        return this.primaryNarrowphaseDetector;
    }

    public NarrowphaseDetector getFallbackNarrowphaseDetector() {
        return this.fallbackNarrowphaseDetector;
    }
}

