/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import java.util.ArrayList;
import java.util.List;
import org.dyn4j.Epsilon;
import org.dyn4j.collision.narrowphase.CircleDetector;
import org.dyn4j.collision.narrowphase.DistanceDetector;
import org.dyn4j.collision.narrowphase.Epa;
import org.dyn4j.collision.narrowphase.MinkowskiPenetrationSolver;
import org.dyn4j.collision.narrowphase.MinkowskiSum;
import org.dyn4j.collision.narrowphase.MinkowskiSumPoint;
import org.dyn4j.collision.narrowphase.NarrowphaseDetector;
import org.dyn4j.collision.narrowphase.Penetration;
import org.dyn4j.collision.narrowphase.Raycast;
import org.dyn4j.collision.narrowphase.RaycastDetector;
import org.dyn4j.collision.narrowphase.SegmentDetector;
import org.dyn4j.collision.narrowphase.Separation;
import org.dyn4j.geometry.Circle;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Ray;
import org.dyn4j.geometry.Segment;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;
import org.dyn4j.resources.Messages;

public class Gjk
implements NarrowphaseDetector,
DistanceDetector,
RaycastDetector {
    private static final Vector2 ORIGIN = new Vector2();
    public static final int DEFAULT_MAX_ITERATIONS = 30;
    public static final double DEFAULT_DISTANCE_EPSILON = Math.sqrt(Epsilon.E);
    protected MinkowskiPenetrationSolver minkowskiPenetrationSolver = new Epa();
    protected int maxIterations = 30;
    protected double distanceEpsilon = DEFAULT_DISTANCE_EPSILON;

    public Gjk() {
    }

    public Gjk(MinkowskiPenetrationSolver minkowskiPenetrationSolver) {
        if (minkowskiPenetrationSolver == null) {
            throw new NullPointerException(Messages.getString("collision.narrowphase.gjk.nullMinkowskiPenetrationSolver"));
        }
        this.minkowskiPenetrationSolver = minkowskiPenetrationSolver;
    }

    @Override
    public boolean detect(Convex convex1, Transform transform1, Convex convex2, Transform transform2, Penetration penetration) {
        if (convex1 instanceof Circle && convex2 instanceof Circle) {
            return CircleDetector.detect((Circle)convex1, transform1, (Circle)convex2, transform2, penetration);
        }
        MinkowskiSum ms = new MinkowskiSum(convex1, transform1, convex2, transform2);
        ArrayList<Vector2> simplex = new ArrayList<Vector2>(3);
        Vector2 d = this.getInitialDirection(convex1, transform1, convex2, transform2);
        if (this.detect(ms, simplex, d)) {
            this.minkowskiPenetrationSolver.getPenetration(simplex, ms, penetration);
            return true;
        }
        return false;
    }

    @Override
    public boolean detect(Convex convex1, Transform transform1, Convex convex2, Transform transform2) {
        if (convex1 instanceof Circle && convex2 instanceof Circle) {
            return CircleDetector.detect((Circle)convex1, transform1, (Circle)convex2, transform2);
        }
        ArrayList<Vector2> simplex = new ArrayList<Vector2>(3);
        MinkowskiSum ms = new MinkowskiSum(convex1, transform1, convex2, transform2);
        Vector2 d = this.getInitialDirection(convex1, transform1, convex2, transform2);
        return this.detect(ms, simplex, d);
    }

    protected Vector2 getInitialDirection(Convex convex1, Transform transform1, Convex convex2, Transform transform2) {
        Vector2 c1 = transform1.getTransformed(convex1.getCenter());
        Vector2 c2 = transform2.getTransformed(convex2.getCenter());
        return c2.subtract(c1);
    }

    protected boolean detect(MinkowskiSum ms, List<Vector2> simplex, Vector2 d) {
        if (d.isZero()) {
            d.set(1.0, 0.0);
        }
        simplex.add(ms.getSupportPoint(d));
        if (simplex.get(0).dot(d) <= 0.0) {
            return false;
        }
        d.negate();
        do {
            simplex.add(ms.getSupportPoint(d));
            if (!(simplex.get(simplex.size() - 1).dot(d) <= 0.0)) continue;
            return false;
        } while (!this.checkSimplex(simplex, d));
        return true;
    }

    protected boolean checkSimplex(List<Vector2> simplex, Vector2 direction) {
        Vector2 a = simplex.get(simplex.size() - 1);
        Vector2 ao = a.getNegative();
        if (simplex.size() == 3) {
            Vector2 b = simplex.get(1);
            Vector2 c = simplex.get(0);
            Vector2 ab = a.to(b);
            Vector2 ac = a.to(c);
            Vector2 abPerp = Vector2.tripleProduct(ac, ab, ab);
            Vector2 acPerp = Vector2.tripleProduct(ab, ac, ac);
            double acLocation = acPerp.dot(ao);
            if (acLocation >= 0.0) {
                simplex.remove(1);
                direction.set(acPerp);
            } else {
                double abLocation = abPerp.dot(ao);
                if (abLocation < 0.0) {
                    return true;
                }
                simplex.remove(0);
                direction.set(abPerp);
            }
        } else {
            Vector2 b = simplex.get(0);
            Vector2 ab = a.to(b);
            direction.set(Vector2.tripleProduct(ab, ao, ab));
            if (direction.getMagnitudeSquared() <= Epsilon.E) {
                direction.set(ab.left());
            }
        }
        return false;
    }

    @Override
    public boolean distance(Convex convex1, Transform transform1, Convex convex2, Transform transform2, Separation separation) {
        Vector2 c2;
        if (convex1 instanceof Circle && convex2 instanceof Circle) {
            return CircleDetector.distance((Circle)convex1, transform1, (Circle)convex2, transform2, separation);
        }
        MinkowskiSum ms = new MinkowskiSum(convex1, transform1, convex2, transform2);
        MinkowskiSumPoint a = null;
        MinkowskiSumPoint b = null;
        MinkowskiSumPoint c = null;
        Vector2 c1 = transform1.getTransformed(convex1.getCenter());
        Vector2 d = c1.to(c2 = transform2.getTransformed(convex2.getCenter()));
        if (d.isZero()) {
            return false;
        }
        a = ms.getSupportPoints(d);
        d.negate();
        b = ms.getSupportPoints(d);
        d = Segment.getPointOnSegmentClosestToPoint(ORIGIN, b.point, a.point);
        int i = 0;
        while (i < this.maxIterations) {
            d.negate();
            if (d.getMagnitudeSquared() <= Epsilon.E) {
                return false;
            }
            c = ms.getSupportPoints(d);
            if (this.containsOrigin(a.point, b.point, c.point)) {
                return false;
            }
            double projection = c.point.dot(d);
            if (projection - a.point.dot(d) < this.distanceEpsilon) {
                d.normalize();
                separation.normal = d;
                separation.distance = -c.point.dot(d);
                this.findClosestPoints(a, b, separation);
                return true;
            }
            Vector2 p1 = Segment.getPointOnSegmentClosestToPoint(ORIGIN, a.point, c.point);
            Vector2 p2 = Segment.getPointOnSegmentClosestToPoint(ORIGIN, c.point, b.point);
            double p1Mag = p1.getMagnitudeSquared();
            double p2Mag = p2.getMagnitudeSquared();
            if (p1Mag <= Epsilon.E) {
                d.normalize();
                separation.distance = p1.normalize();
                separation.normal = d;
                this.findClosestPoints(a, c, separation);
                return true;
            }
            if (p2Mag <= Epsilon.E) {
                d.normalize();
                separation.distance = p2.normalize();
                separation.normal = d;
                this.findClosestPoints(c, b, separation);
                return true;
            }
            if (p1Mag < p2Mag) {
                b = c;
                d = p1;
            } else {
                a = c;
                d = p2;
            }
            ++i;
        }
        d.normalize();
        separation.normal = d;
        separation.distance = -c.point.dot(d);
        this.findClosestPoints(a, b, separation);
        return true;
    }

    protected void findClosestPoints(MinkowskiSumPoint a, MinkowskiSumPoint b, Separation separation) {
        Vector2 p1 = new Vector2();
        Vector2 p2 = new Vector2();
        Vector2 l = a.point.to(b.point);
        if (l.isZero()) {
            p1.set(a.supportPoint1);
            p2.set(a.supportPoint2);
        } else {
            double ll = l.dot(l);
            double l2 = -l.dot(a.point) / ll;
            double l1 = 1.0 - l2;
            if (l1 < 0.0) {
                p1.set(b.supportPoint1);
                p2.set(b.supportPoint2);
            } else if (l2 < 0.0) {
                p1.set(a.supportPoint1);
                p2.set(a.supportPoint2);
            } else {
                p1.x = a.supportPoint1.x * l1 + b.supportPoint1.x * l2;
                p1.y = a.supportPoint1.y * l1 + b.supportPoint1.y * l2;
                p2.x = a.supportPoint2.x * l1 + b.supportPoint2.x * l2;
                p2.y = a.supportPoint2.y * l1 + b.supportPoint2.y * l2;
            }
        }
        separation.point1 = p1;
        separation.point2 = p2;
    }

    protected boolean containsOrigin(Vector2 a, Vector2 b, Vector2 c) {
        double sa = a.cross(b);
        double sb = b.cross(c);
        double sc = c.cross(a);
        return sa * sb > 0.0 && sa * sc > 0.0;
    }

    @Override
    public boolean raycast(Ray ray, double maxLength, Convex convex, Transform transform, Raycast raycast) {
        Vector2 start;
        if (convex instanceof Circle) {
            return CircleDetector.raycast(ray, maxLength, (Circle)convex, transform, raycast);
        }
        if (convex instanceof Segment) {
            return SegmentDetector.raycast(ray, maxLength, (Segment)convex, transform, raycast);
        }
        double lambda = 0.0;
        boolean lengthCheck = maxLength > 0.0;
        Vector2 a = null;
        Vector2 b = null;
        Vector2 x = start = ray.getStart();
        Vector2 r = ray.getDirectionVector();
        Vector2 n = new Vector2();
        if (convex.contains(start, transform)) {
            return false;
        }
        Vector2 c = transform.getTransformed(convex.getCenter());
        Vector2 d = c.to(x);
        double distanceSqrd = Double.MAX_VALUE;
        int iterations = 0;
        while (distanceSqrd > this.distanceEpsilon) {
            Vector2 p = convex.getFarthestPoint(d, transform);
            Vector2 w = p.to(x);
            double dDotW = d.dot(w);
            if (dDotW > 0.0) {
                double dDotR = d.dot(r);
                if (dDotR >= 0.0) {
                    return false;
                }
                lambda -= dDotW / dDotR;
                if (lengthCheck && lambda > maxLength) {
                    return false;
                }
                x = r.product(lambda).add(start);
                n.set(d);
            }
            if (a != null) {
                if (b != null) {
                    Vector2 p1 = Segment.getPointOnSegmentClosestToPoint(x, a, p);
                    Vector2 p2 = Segment.getPointOnSegmentClosestToPoint(x, p, b);
                    if (p1.distanceSquared(x) < p2.distanceSquared(x)) {
                        b.set(p);
                        distanceSqrd = p1.distanceSquared(x);
                    } else {
                        a.set(p);
                        distanceSqrd = p2.distanceSquared(x);
                    }
                    Vector2 ab = a.to(b);
                    Vector2 ax = a.to(x);
                    d = Vector2.tripleProduct(ab, ax, ab);
                } else {
                    b = p;
                    Vector2 ab = a.to(b);
                    Vector2 ax = a.to(x);
                    d = Vector2.tripleProduct(ab, ax, ab);
                }
            } else {
                a = p;
                d.negate();
            }
            if (iterations == this.maxIterations) {
                return false;
            }
            ++iterations;
        }
        raycast.point = x;
        raycast.normal = n;
        n.normalize();
        raycast.distance = lambda;
        return true;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        if (maxIterations < 5) {
            throw new IllegalArgumentException(Messages.getString("collision.narrowphase.gjk.invalidMaximumIterations"));
        }
        this.maxIterations = maxIterations;
    }

    public double getDistanceEpsilon() {
        return this.distanceEpsilon;
    }

    public void setDistanceEpsilon(double distanceEpsilon) {
        if (distanceEpsilon <= 0.0) {
            throw new IllegalArgumentException(Messages.getString("collision.narrowphase.gjk.invalidDistanceEpsilon"));
        }
        this.distanceEpsilon = distanceEpsilon;
    }

    public MinkowskiPenetrationSolver getMinkowskiPenetrationSolver() {
        return this.minkowskiPenetrationSolver;
    }

    public void setMinkowskiPenetrationSolver(MinkowskiPenetrationSolver minkowskiPenetrationSolver) {
        if (minkowskiPenetrationSolver == null) {
            throw new NullPointerException(Messages.getString("collision.narrowphase.gjk.nullMinkowskiPenetrationSolver"));
        }
        this.minkowskiPenetrationSolver = minkowskiPenetrationSolver;
    }
}

