/*
 * Decompiled with CFR 0.152.
 */
package org.dyn4j.collision.narrowphase;

import org.dyn4j.collision.narrowphase.MinkowskiSumPoint;
import org.dyn4j.geometry.Convex;
import org.dyn4j.geometry.Transform;
import org.dyn4j.geometry.Vector2;

public class MinkowskiSum {
    final Convex convex1;
    final Convex convex2;
    final Transform transform1;
    final Transform transform2;

    public MinkowskiSum(Convex convex1, Transform transform1, Convex convex2, Transform transform2) {
        this.convex1 = convex1;
        this.convex2 = convex2;
        this.transform1 = transform1;
        this.transform2 = transform2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MinkowskiSum[Convex1=").append(this.convex1.getId()).append("|Transform1=").append(this.transform1).append("|Convex2=").append(this.convex2.getId()).append("|Transform2=").append(this.transform2).append("]");
        return sb.toString();
    }

    public final Vector2 getSupportPoint(Vector2 direction) {
        Vector2 point1 = this.convex1.getFarthestPoint(direction, this.transform1);
        direction.negate();
        Vector2 point2 = this.convex2.getFarthestPoint(direction, this.transform2);
        direction.negate();
        return point1.subtract(point2);
    }

    public final MinkowskiSumPoint getSupportPoints(Vector2 direction) {
        Vector2 point1 = this.convex1.getFarthestPoint(direction, this.transform1);
        direction.negate();
        Vector2 point2 = this.convex2.getFarthestPoint(direction, this.transform2);
        direction.negate();
        return new MinkowskiSumPoint(point1, point2);
    }

    public Convex getConvex1() {
        return this.convex1;
    }

    public Convex getConvex2() {
        return this.convex2;
    }

    public Transform getTransform1() {
        return this.transform1;
    }

    public Transform getTransform2() {
        return this.transform2;
    }
}

